/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.render.compiler.CodeGenerator;
import yslelf.cloudpick.render.compiler.CompileOptions;
import yslelf.cloudpick.render.compiler.Context;
import yslelf.cloudpick.render.compiler.ErrorHandler;
import yslelf.cloudpick.render.compiler.Inliner;
import yslelf.cloudpick.render.compiler.ModuleUnit;
import yslelf.cloudpick.render.compiler.Parser;
import yslelf.cloudpick.render.compiler.ShaderCaps;
import yslelf.cloudpick.render.compiler.ShaderKind;
import yslelf.cloudpick.render.compiler.TranslationUnit;
import yslelf.cloudpick.render.compiler.spirv.SPIRVCodeGenerator;

public class ShaderCompiler {
    public static final String INVALID_TAG = "<INVALID>";
    public static final String POISON_TAG = "<POISON>";
    private final StringBuilder mErrorBuilder = new StringBuilder();
    private final ErrorHandler mErrorHandler = new ErrorHandler(){

        private void log(int start, int end, String msg) {
            boolean showLocation = false;
            char[] source = this.mSource;
            int sourceStart = this.mOffset;
            int sourceLimit = this.mOffset + this.mLength;
            if (start != -1 && source != null) {
                end += sourceStart;
                int offset = Math.min(start += sourceStart, sourceLimit);
                int line = 1;
                for (int i = sourceStart; i < offset; ++i) {
                    boolean isCR;
                    boolean bl = isCR = source[i] == '\r';
                    if (!isCR && source[i] != '\n') continue;
                    ++line;
                    if (!isCR || i + 1 >= offset || source[i + 1] != '\n') continue;
                    ++i;
                }
                showLocation = start < sourceLimit;
                ShaderCompiler.this.mErrorBuilder.append(line).append(": ");
            }
            ShaderCompiler.this.mErrorBuilder.append(msg).append('\n');
            if (showLocation) {
                int i;
                for (int lineStart = start; lineStart > sourceStart && start - lineStart < 128 && source[lineStart - 1] != '\n'; --lineStart) {
                }
                block11: for (i = lineStart; i < sourceLimit; ++i) {
                    switch (source[i]) {
                        case '\t': {
                            ShaderCompiler.this.mErrorBuilder.append("    ");
                            continue block11;
                        }
                        case '\u0000': {
                            ShaderCompiler.this.mErrorBuilder.append(" ");
                            continue block11;
                        }
                        case '\n': {
                            i = sourceLimit;
                            continue block11;
                        }
                        default: {
                            ShaderCompiler.this.mErrorBuilder.append(source[i]);
                        }
                    }
                }
                ShaderCompiler.this.mErrorBuilder.append('\n');
                block12: for (i = lineStart; i < sourceLimit && i < end; ++i) {
                    switch (source[i]) {
                        case '\t': {
                            ShaderCompiler.this.mErrorBuilder.append(i >= start ? "^^^^" : "    ");
                            continue block12;
                        }
                        case '\n': {
                            assert (i >= start);
                            ShaderCompiler.this.mErrorBuilder.append(end > i + 1 ? "..." : "^");
                            i = sourceLimit;
                            continue block12;
                        }
                        default: {
                            ShaderCompiler.this.mErrorBuilder.append(i >= start ? (char)'^' : ' ');
                        }
                    }
                }
                ShaderCompiler.this.mErrorBuilder.append('\n');
            }
        }

        @Override
        protected void handleError(int start, int end, String msg) {
            ShaderCompiler.this.mErrorBuilder.append("error: ");
            this.log(start, end, msg);
        }

        @Override
        protected void handleWarning(int start, int end, String msg) {
            ShaderCompiler.this.mErrorBuilder.append("warning: ");
            this.log(start, end, msg);
        }
    };
    private final Context mContext = new Context(this.mErrorHandler);
    private final Inliner mInliner = new Inliner();

    public Context getContext() {
        if (this.mContext.isActive()) {
            return this.mContext;
        }
        throw new IllegalStateException("DSL is not started");
    }

    @Nullable
    public TranslationUnit parse(@Nonnull CharSequence source, @Nonnull ShaderKind kind, @Nonnull CompileOptions options, @Nonnull ModuleUnit parent) {
        int length;
        int offset;
        char[] chars;
        CharBuffer buffer;
        if (source instanceof CharBuffer && (buffer = (CharBuffer)source).hasArray()) {
            chars = buffer.array();
            offset = buffer.arrayOffset() + buffer.position();
            length = buffer.remaining();
        } else {
            chars = ShaderCompiler.toChars(source);
            offset = 0;
            length = chars.length;
        }
        return this.parse(chars, offset, length, kind, options, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TranslationUnit parse(@Nonnull char[] source, int offset, int length, @Nonnull ShaderKind kind, @Nonnull CompileOptions options, @Nonnull ModuleUnit parent) {
        Objects.requireNonNull(kind);
        Objects.requireNonNull(parent);
        Objects.checkFromIndexSize(offset, length, source.length);
        this.startContext(kind, options, parent, false, false, source, offset, length);
        try {
            List<Map.Entry<String, Boolean>> includes;
            Parser parser = new Parser(this, kind, options, source, offset, length);
            if (options.mPreprocess && (includes = parser.preprocess()) == null) {
                TranslationUnit translationUnit = null;
                return translationUnit;
            }
            TranslationUnit translationUnit = parser.parse(parent);
            return translationUnit;
        }
        finally {
            this.endContext();
        }
    }

    @Nullable
    public ModuleUnit parseModule(@Nonnull CharSequence source, @Nonnull ShaderKind kind, @Nonnull ModuleUnit parent, boolean builtin) {
        int length;
        int offset;
        char[] chars;
        CharBuffer buffer;
        if (source instanceof CharBuffer && (buffer = (CharBuffer)source).hasArray()) {
            chars = buffer.array();
            offset = buffer.arrayOffset() + buffer.position();
            length = buffer.remaining();
        } else {
            chars = ShaderCompiler.toChars(source);
            offset = 0;
            length = chars.length;
        }
        return this.parseModule(chars, offset, length, kind, parent, builtin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ModuleUnit parseModule(@Nonnull char[] source, int offset, int length, @Nonnull ShaderKind kind, @Nonnull ModuleUnit parent, boolean builtin) {
        Objects.requireNonNull(kind);
        Objects.requireNonNull(parent);
        Objects.checkFromIndexSize(offset, length, source.length);
        CompileOptions options = new CompileOptions();
        this.startContext(kind, options, parent, builtin, true, source, offset, length);
        try {
            Parser parser = new Parser(this, kind, options, source, offset, length);
            List<Map.Entry<String, Boolean>> includes = parser.preprocess();
            if (includes == null) {
                ModuleUnit moduleUnit = null;
                return moduleUnit;
            }
            ModuleUnit moduleUnit = parser.parseModule(parent);
            return moduleUnit;
        }
        finally {
            this.endContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ByteBuffer generateSPIRV(@Nonnull TranslationUnit translationUnit, @Nonnull ShaderCaps shaderCaps) {
        this.startContext(translationUnit.getKind(), translationUnit.getOptions(), null, false, false, translationUnit.getSource(), translationUnit.getSourceOffset(), translationUnit.getSourceLength());
        try {
            SPIRVCodeGenerator generator = new SPIRVCodeGenerator(this, translationUnit, shaderCaps);
            ByteBuffer byteBuffer = ((CodeGenerator)generator).generateCode();
            return byteBuffer;
        }
        finally {
            this.endContext();
        }
    }

    @Nullable
    public ByteBuffer compileIntoSPIRV(@Nonnull CharSequence source, @Nonnull ShaderKind kind, @Nonnull ShaderCaps shaderCaps, @Nonnull CompileOptions options, @Nonnull ModuleUnit parent) {
        int length;
        int offset;
        char[] chars;
        CharBuffer buffer;
        if (source instanceof CharBuffer && (buffer = (CharBuffer)source).hasArray()) {
            chars = buffer.array();
            offset = buffer.arrayOffset() + buffer.position();
            length = buffer.remaining();
        } else {
            chars = ShaderCompiler.toChars(source);
            offset = 0;
            length = chars.length;
        }
        return this.compileIntoSPIRV(chars, offset, length, kind, shaderCaps, options, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ByteBuffer compileIntoSPIRV(@Nonnull char[] source, int offset, int length, @Nonnull ShaderKind kind, @Nonnull ShaderCaps shaderCaps, @Nonnull CompileOptions options, @Nonnull ModuleUnit parent) {
        Objects.requireNonNull(kind);
        Objects.requireNonNull(parent);
        Objects.checkFromIndexSize(offset, length, source.length);
        this.startContext(kind, options, parent, false, false, source, offset, length);
        try {
            List<Map.Entry<String, Boolean>> includes;
            Parser parser = new Parser(this, kind, options, source, offset, length);
            if (options.mPreprocess && (includes = parser.preprocess()) == null) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            TranslationUnit translationUnit = parser.parse(parent);
            if (translationUnit == null) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            SPIRVCodeGenerator generator = new SPIRVCodeGenerator(this, translationUnit, shaderCaps);
            ByteBuffer byteBuffer = ((CodeGenerator)generator).generateCode();
            return byteBuffer;
        }
        finally {
            this.endContext();
        }
    }

    @ApiStatus.Internal
    public void startContext(ShaderKind kind, CompileOptions options, ModuleUnit parent, boolean isBuiltin, boolean isModule, char[] source, int offset, int length) {
        assert (isModule || !isBuiltin);
        this.resetErrors();
        this.mContext.start(kind, options, parent, isBuiltin, isModule);
        this.mContext.getErrorHandler().setSource(source, offset, length);
    }

    @ApiStatus.Internal
    public void endContext() {
        this.mContext.end();
        this.mContext.getErrorHandler().setSource(null, 0, 0);
    }

    @Nonnull
    public static char[] toChars(@Nonnull CharSequence s) {
        if (s instanceof String) {
            return ((String)s).toCharArray();
        }
        int n2 = s.length();
        char[] chars = new char[n2];
        ShaderCompiler.getChars(s, chars, 0, n2);
        return chars;
    }

    @Nonnull
    public static char[] toChars(CharSequence ... elements) {
        return ShaderCompiler.toChars(elements, 0, elements.length);
    }

    @Nonnull
    public static char[] toChars(@Nonnull CharSequence[] elements, int start, int end) {
        Objects.checkFromToIndex(start, end, elements.length);
        if (start == end) {
            return new char[0];
        }
        if (start + 1 == end) {
            return ShaderCompiler.toChars(elements[start]);
        }
        int n2 = 0;
        for (int i = start; i < end; ++i) {
            int len = elements[i].length();
            n2 += len;
        }
        if (n2 == 0) {
            return new char[0];
        }
        char[] chars = new char[n2];
        int p2 = 0;
        for (int i = start; i < end; ++i) {
            CharSequence s = elements[i];
            int len = s.length();
            if (len == 0) continue;
            p2 += ShaderCompiler.getChars(s, chars, p2, len);
        }
        assert (p2 == n2);
        return chars;
    }

    @Nonnull
    public static char[] toChars(@Nonnull List<CharSequence> elements) {
        int size = elements.size();
        if (size == 0) {
            return new char[0];
        }
        if (size == 1) {
            return ShaderCompiler.toChars(elements.get(0));
        }
        int n2 = 0;
        for (int i = 0; i < size; ++i) {
            int len = elements.get(i).length();
            n2 += len;
        }
        if (n2 == 0) {
            return new char[0];
        }
        char[] chars = new char[n2];
        int p2 = 0;
        for (int i = 0; i < size; ++i) {
            CharSequence s = elements.get(i);
            int len = s.length();
            if (len == 0) continue;
            p2 += ShaderCompiler.getChars(s, chars, p2, len);
        }
        assert (p2 == n2);
        return chars;
    }

    private static int getChars(@Nonnull CharSequence s, @Nonnull char[] dst, int offset, int n2) {
        if (s instanceof String) {
            ((String)s).getChars(0, n2, dst, offset);
        } else if (s instanceof StringBuffer) {
            ((StringBuffer)s).getChars(0, n2, dst, offset);
        } else if (s instanceof StringBuilder) {
            ((StringBuilder)s).getChars(0, n2, dst, offset);
        } else if (s instanceof CharBuffer) {
            CharBuffer buf = (CharBuffer)s;
            buf.get(buf.position(), dst, offset, n2);
        } else {
            for (int i = 0; i < n2; ++i) {
                dst[offset++] = s.charAt(i);
            }
        }
        return n2;
    }

    @Nonnull
    public String getErrorMessage() {
        return this.getErrorMessage(true);
    }

    @Nonnull
    public String getErrorMessage(boolean showCount) {
        if (!showCount) {
            return this.mErrorBuilder.toString();
        }
        int errors = this.errorCount();
        int warnings = this.warningCount();
        if (errors == 0 && warnings == 0) {
            assert (this.mErrorBuilder.isEmpty());
            return "";
        }
        int start = this.mErrorBuilder.length();
        this.mErrorBuilder.append(errors).append(" error");
        if (errors != 1) {
            this.mErrorBuilder.append('s');
        }
        this.mErrorBuilder.append(", ").append(warnings).append(" warning");
        if (warnings != 1) {
            this.mErrorBuilder.append('s');
        }
        this.mErrorBuilder.append('\n');
        String msg = this.mErrorBuilder.toString();
        this.mErrorBuilder.delete(start, this.mErrorBuilder.length());
        return msg;
    }

    public ErrorHandler getErrorHandler() {
        return this.mErrorHandler;
    }

    public int errorCount() {
        return this.mErrorHandler.errorCount();
    }

    public int warningCount() {
        return this.mErrorHandler.warningCount();
    }

    private void resetErrors() {
        boolean trim = this.mErrorBuilder.length() > 8192;
        this.mErrorBuilder.setLength(0);
        if (trim) {
            this.mErrorBuilder.trimToSize();
        }
        this.mErrorHandler.reset();
    }
}

