/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.compiler.Context;
import yslelf.cloudpick.render.compiler.tree.FunctionDecl;
import yslelf.cloudpick.render.compiler.tree.Symbol;
import yslelf.cloudpick.render.compiler.tree.Type;

public final class SymbolTable {
    private final Map<String, Symbol> mTable = new HashMap<String, Symbol>();
    private final SymbolTable mParent;
    private final boolean mIsBuiltin;
    private final boolean mIsModuleLevel;

    SymbolTable() {
        this(null, true, false);
    }

    private SymbolTable(SymbolTable parent, boolean isBuiltin, boolean isModuleLevel) {
        this.mParent = parent;
        this.mIsBuiltin = isBuiltin;
        this.mIsModuleLevel = isModuleLevel;
    }

    @Nonnull
    SymbolTable enterScope() {
        return new SymbolTable(this, this.mIsBuiltin, false);
    }

    @Nonnull
    SymbolTable enterModule(boolean isBuiltin) {
        if (isBuiltin && !this.mIsBuiltin || !this.mIsModuleLevel && this.mParent != null) {
            throw new AssertionError();
        }
        return new SymbolTable(this, isBuiltin, true);
    }

    SymbolTable leaveScope() {
        if (this.mIsModuleLevel || this.mParent == null) {
            throw new AssertionError();
        }
        return this.mParent;
    }

    public SymbolTable getParent() {
        return this.mParent;
    }

    public boolean isBuiltin() {
        return this.mIsBuiltin;
    }

    @Nullable
    public Symbol find(String name) {
        Symbol symbol = this.mTable.get(name);
        if (symbol != null) {
            return symbol;
        }
        return this.mParent != null ? this.mParent.find(name) : null;
    }

    @Nullable
    public Symbol findBuiltinSymbol(String name) {
        if (this.mIsBuiltin) {
            return this.find(name);
        }
        return this.mParent != null ? this.mParent.findBuiltinSymbol(name) : null;
    }

    public boolean isType(String name) {
        return this.find(name) instanceof Type;
    }

    public boolean isBuiltinType(String name) {
        if (this.mIsBuiltin) {
            return this.isType(name);
        }
        return this.mParent != null && this.mParent.isBuiltinType(name);
    }

    <T extends Symbol> T insert(@Nonnull T symbol) {
        return Objects.requireNonNull(this.insert(null, symbol));
    }

    @Nullable
    public <T extends Symbol> T insert(Context context, @Nonnull T symbol) {
        Symbol symbol2;
        String key = symbol.getName();
        if (key.isEmpty()) {
            return symbol;
        }
        if (key.length() > 1024) {
            context.error(symbol.mPosition, "symbol name '" + key + "' is too long, " + key.length() + " > 1024 chars");
            return null;
        }
        if (symbol instanceof FunctionDecl && (symbol2 = this.find(key)) instanceof FunctionDecl) {
            FunctionDecl next = (FunctionDecl)symbol2;
            ((FunctionDecl)symbol).setNextOverload(next);
            this.mTable.put(key, symbol);
            return symbol;
        }
        if (!(this.mIsModuleLevel && this.mParent != null && this.mParent.find(key) != null || this.mTable.putIfAbsent(key, symbol) != null)) {
            return symbol;
        }
        context.error(symbol.mPosition, "symbol '" + key + "' is already defined");
        return null;
    }

    public Type getArrayType(Type type, int size) {
        if (size == 0) {
            return type;
        }
        if (!this.mIsModuleLevel && this.mParent != null && type.isInBuiltinTypes()) {
            return this.mParent.getArrayType(type, size);
        }
        String name = type.getArrayName(size);
        Symbol symbol = this.find(name);
        if (symbol != null) {
            return (Type)symbol;
        }
        Type result = Type.makeArrayType(name, type, size);
        return this.insert(result);
    }
}

