/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.analysis;

import java.util.Arrays;
import javax.annotation.Nonnull;
import yslelf.cloudpick.render.compiler.Operator;
import yslelf.cloudpick.render.compiler.tree.BinaryExpression;
import yslelf.cloudpick.render.compiler.tree.ConstructorCall;
import yslelf.cloudpick.render.compiler.tree.Expression;
import yslelf.cloudpick.render.compiler.tree.FieldAccess;
import yslelf.cloudpick.render.compiler.tree.FunctionCall;
import yslelf.cloudpick.render.compiler.tree.IndexExpression;
import yslelf.cloudpick.render.compiler.tree.Literal;
import yslelf.cloudpick.render.compiler.tree.Node;
import yslelf.cloudpick.render.compiler.tree.PostfixExpression;
import yslelf.cloudpick.render.compiler.tree.PrefixExpression;
import yslelf.cloudpick.render.compiler.tree.Swizzle;
import yslelf.cloudpick.render.compiler.tree.TreeVisitor;
import yslelf.cloudpick.render.compiler.tree.VariableReference;

public final class Analysis {
    public static boolean isCompileTimeConstant(Expression expr) {
        class IsCompileTimeConstantVisitor
        extends TreeVisitor {
            static final IsCompileTimeConstantVisitor visitor = new IsCompileTimeConstantVisitor();

            IsCompileTimeConstantVisitor() {
            }

            @Override
            public boolean visitLiteral(Literal expr) {
                return false;
            }

            @Override
            protected boolean visitExpression(Expression expr) {
                return switch (expr.getKind()) {
                    case Node.ExpressionKind.CONSTRUCTOR_ARRAY, Node.ExpressionKind.CONSTRUCTOR_COMPOUND, Node.ExpressionKind.CONSTRUCTOR_DIAGONAL_MATRIX, Node.ExpressionKind.CONSTRUCTOR_MATRIX_RESIZE, Node.ExpressionKind.CONSTRUCTOR_STRUCT, Node.ExpressionKind.CONSTRUCTOR_VECTOR_SPLAT -> false;
                    default -> true;
                };
            }
        }
        return !expr.accept(IsCompileTimeConstantVisitor.visitor);
    }

    public static boolean updateVariableRefKind(Expression expr, int refKind) {
        return true;
    }

    public static boolean isTrivialExpression(@Nonnull Expression expr) {
        switch (expr.getKind()) {
            case LITERAL: 
            case VARIABLE_REFERENCE: {
                return true;
            }
            case SWIZZLE: {
                return Analysis.isTrivialExpression(((Swizzle)expr).getBase());
            }
            case PREFIX: {
                PrefixExpression prefix = (PrefixExpression)expr;
                return switch (prefix.getOperator()) {
                    case Operator.ADD, Operator.SUB, Operator.LOGICAL_NOT, Operator.BITWISE_NOT -> Analysis.isTrivialExpression(prefix.getOperand());
                    default -> false;
                };
            }
            case FIELD_ACCESS: {
                return Analysis.isTrivialExpression(((FieldAccess)expr).getBase());
            }
            case INDEX: {
                IndexExpression inner = (IndexExpression)expr;
                return inner.getIndex().isIntLiteral() && Analysis.isTrivialExpression(inner.getBase());
            }
            case CONSTRUCTOR_ARRAY: 
            case CONSTRUCTOR_STRUCT: {
                return expr.getType().getComponents() <= 4 && Analysis.isCompileTimeConstant(expr);
            }
            case CONSTRUCTOR_MATRIX_RESIZE: 
            case CONSTRUCTOR_ARRAY_CAST: {
                return false;
            }
            case CONSTRUCTOR_COMPOUND: {
                return Analysis.isCompileTimeConstant(expr);
            }
            case CONSTRUCTOR_DIAGONAL_MATRIX: 
            case CONSTRUCTOR_VECTOR_SPLAT: 
            case CONSTRUCTOR_COMPOUND_CAST: 
            case CONSTRUCTOR_SCALAR_CAST: {
                ConstructorCall ctor = (ConstructorCall)expr;
                assert (ctor.getArguments().length == 1);
                Expression inner = ctor.getArgument();
                return Analysis.isTrivialExpression(inner);
            }
        }
        return false;
    }

    public static boolean isSameExpressionTree(Expression left, Expression right) {
        if (left.getKind() != right.getKind() || !left.getType().matches(right.getType())) {
            return false;
        }
        switch (left.getKind()) {
            case LITERAL: {
                return ((Literal)left).getValue() == ((Literal)right).getValue();
            }
            case CONSTRUCTOR_ARRAY: 
            case CONSTRUCTOR_COMPOUND: 
            case CONSTRUCTOR_DIAGONAL_MATRIX: 
            case CONSTRUCTOR_MATRIX_RESIZE: 
            case CONSTRUCTOR_STRUCT: 
            case CONSTRUCTOR_VECTOR_SPLAT: 
            case CONSTRUCTOR_ARRAY_CAST: 
            case CONSTRUCTOR_COMPOUND_CAST: 
            case CONSTRUCTOR_SCALAR_CAST: {
                Expression[] rhsArgs;
                if (left.getKind() != right.getKind()) {
                    return false;
                }
                Expression[] lhsArgs = ((ConstructorCall)left).getArguments();
                if (lhsArgs.length != (rhsArgs = ((ConstructorCall)right).getArguments()).length) {
                    return false;
                }
                for (int i = 0; i < lhsArgs.length; ++i) {
                    if (Analysis.isSameExpressionTree(lhsArgs[i], rhsArgs[i])) continue;
                    return false;
                }
                return true;
            }
            case FIELD_ACCESS: {
                FieldAccess leftExpr = (FieldAccess)left;
                FieldAccess rightExpr = (FieldAccess)right;
                return leftExpr.getFieldIndex() == rightExpr.getFieldIndex() && Analysis.isSameExpressionTree(leftExpr.getBase(), rightExpr.getBase());
            }
            case INDEX: {
                IndexExpression leftExpr = (IndexExpression)left;
                IndexExpression rightExpr = (IndexExpression)right;
                return Analysis.isSameExpressionTree(leftExpr.getIndex(), rightExpr.getIndex()) && Analysis.isSameExpressionTree(leftExpr.getBase(), rightExpr.getBase());
            }
            case PREFIX: {
                PrefixExpression leftExpr = (PrefixExpression)left;
                PrefixExpression rightExpr = (PrefixExpression)right;
                return leftExpr.getOperator() == rightExpr.getOperator() && Analysis.isSameExpressionTree(leftExpr.getOperand(), rightExpr.getOperand());
            }
            case SWIZZLE: {
                Swizzle leftExpr = (Swizzle)left;
                Swizzle rightExpr = (Swizzle)right;
                return Arrays.equals(leftExpr.getComponents(), rightExpr.getComponents()) && Analysis.isSameExpressionTree(leftExpr.getBase(), rightExpr.getBase());
            }
            case VARIABLE_REFERENCE: {
                return ((VariableReference)left).getVariable() == ((VariableReference)right).getVariable();
            }
        }
        return false;
    }

    public static boolean hasSideEffects(Expression expr) {
        class HasSideEffectsVisitor
        extends TreeVisitor {
            HasSideEffectsVisitor() {
            }

            @Override
            public boolean visitFunctionCall(FunctionCall expr) {
                return (expr.getFunction().getModifiers().flags() & 0x8000) == 0;
            }

            @Override
            public boolean visitPrefix(PrefixExpression expr) {
                return expr.getOperator() == Operator.INC || expr.getOperator() == Operator.DEC;
            }

            @Override
            public boolean visitPostfix(PostfixExpression expr) {
                return expr.getOperator() == Operator.INC || expr.getOperator() == Operator.DEC;
            }

            @Override
            public boolean visitBinary(BinaryExpression expr) {
                return expr.getOperator().isAssignment();
            }
        }
        return expr.accept(new HasSideEffectsVisitor());
    }
}

