/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.lex;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import yslelf.cloudpick.render.compiler.lex.DFA;
import yslelf.cloudpick.render.compiler.lex.NFA;
import yslelf.cloudpick.render.compiler.lex.NFAtoDFA;
import yslelf.cloudpick.render.compiler.lex.RegexNode;
import yslelf.cloudpick.render.compiler.lex.RegexParser;
import yslelf.cloudpick.render.core.MathUtil;

public class LexerGenerator {
    public static final String LEXICON = "INTLITERAL     = ([1-9]\\d*|0[0-7]*|0[xX][\\da-fA-F]+)[uU]?\nFLOATLITERAL   = (\\d*\\.\\d+([eE][+-]?\\d+)?|\\d+\\.\\d*([eE][+-]?\\d+)?|\\d+([eE][+-]?\\d+))[fF]?\nSTRINGLITERAL  = \\\"[^\\\"\\\\\\r\\n]*\\\"\nTRUE           = \"true\"\nFALSE          = \"false\"\nBREAK          = \"break\"\nCONTINUE       = \"continue\"\nDO             = \"do\"\nFOR            = \"for\"\nWHILE          = \"while\"\nIF             = \"if\"\nELSE           = \"else\"\nSWITCH         = \"switch\"\nCASE           = \"case\"\nDEFAULT        = \"default\"\nDISCARD        = \"discard\"\nRETURN         = \"return\"\nIN             = \"in\"\nOUT            = \"out\"\nINOUT          = \"inout\"\nCONST          = \"const\"\nUNIFORM        = \"uniform\"\nBUFFER         = \"buffer\"\nWORKGROUP      = \"workgroup\"\nSMOOTH         = \"smooth\"\nFLAT           = \"flat\"\nNOPERSPECTIVE  = \"noperspective\"\nCOHERENT       = \"coherent\"\nVOLATILE       = \"volatile\"\nRESTRICT       = \"restrict\"\nREADONLY       = \"readonly\"\nWRITEONLY      = \"writeonly\"\nSUBROUTINE     = \"subroutine\"\nLAYOUT         = \"layout\"\nSTRUCT         = \"struct\"\nUSING          = \"using\"\nINLINE         = \"inline\"\nNOINLINE       = \"noinline\"\nPURE           = \"__pure\"\nRESERVED       = shared|attribute|varying|atomic_uint|lowp|mediump|highp|precision|common|partition|active|asm|class|union|enum|typedef|template|this|resource|goto|public|static|extern|external|interface|long|double|fixed|unsigned|superp|input|output|hvec[234]|dvec[234]|fvec[234]|filter|sizeof|cast|namespace|[iu]?(sampler|image|texture)2DRect|sampler2DRectShadow|sampler3DRect\nIDENTIFIER     = [a-zA-Z_]\\w*\nHASH           = \"#\"\nLPAREN         = \"(\"\nRPAREN         = \")\"\nLBRACE         = \"{\"\nRBRACE         = \"}\"\nLBRACKET       = \"[\"\nRBRACKET       = \"]\"\nDOT            = \".\"\nCOMMA          = \",\"\nEQ             = \"=\"\nLT             = \"<\"\nGT             = \">\"\nBANG           = \"!\"\nTILDE          = \"~\"\nQUES           = \"?\"\nCOLON          = \":\"\nEQEQ           = \"==\"\nLTEQ           = \"<=\"\nGTEQ           = \">=\"\nBANGEQ         = \"!=\"\nPLUSPLUS       = \"++\"\nMINUSMINUS     = \"--\"\nPLUS           = \"+\"\nMINUS          = \"-\"\nSTAR           = \"*\"\nSLASH          = \"/\"\nPERCENT        = \"%\"\nLTLT           = \"<<\"\nGTGT           = \">>\"\nAMPAMP         = \"&&\"\nPIPEPIPE       = \"||\"\nCARETCARET     = \"^^\"\nAMP            = \"&\"\nPIPE           = \"|\"\nCARET          = \"^\"\nPLUSEQ         = \"+=\"\nMINUSEQ        = \"-=\"\nSTAREQ         = \"*=\"\nSLASHEQ        = \"/=\"\nPERCENTEQ      = \"%=\"\nLTLTEQ         = \"<<=\"\nGTGTEQ         = \">>=\"\nAMPEQ          = \"&=\"\nPIPEEQ         = \"|=\"\nCARETEQ        = \"^=\"\nSEMICOLON      = \";\"\nNEWLINE        = [\\r\\n]+\nWHITESPACE     = [\\t\\013\\014 ]+\nLINE_COMMENT   = //.*\nBLOCK_COMMENT  = /\\*(/|\\**[^/*])*\\*+/\nINVALID        = .";
    public static final int NUM_BITS = 2;
    public static final int NUM_VALUES = 3;
    public static final int DATA_PER_BYTE = 4;
    public static final int DATA_PER_BYTE_SHIFT = Integer.numberOfTrailingZeros(4);

    @Nonnull
    public static DFA process(PrintWriter pw) {
        NFA nfa = new NFA();
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add("END_OF_FILE");
        RegexParser parser = new RegexParser();
        for (String line : LEXICON.split("\n")) {
            String[] split = line.split("=", 2);
            assert (split.length == 2);
            String name = split[0].trim();
            String pattern = split[1].trim();
            assert (!name.isEmpty());
            assert (!pattern.isEmpty());
            tokens.add(name);
            if (pattern.startsWith("\"")) {
                assert (pattern.length() > 2 && pattern.endsWith("\""));
                RegexNode node = RegexNode.Char(pattern.charAt(1));
                for (int i = 2; i < pattern.length() - 1; ++i) {
                    node = RegexNode.Concat(node, RegexNode.Char(pattern.charAt(i)));
                }
                nfa.add(node);
                continue;
            }
            nfa.add(parser.parse(pattern));
        }
        NFAtoDFA converter = new NFAtoDFA(nfa);
        DFA dfa = converter.convert();
        pw.println("public static final int");
        for (int i = 0; i < tokens.size(); ++i) {
            pw.println("TK_" + (String)tokens.get(i) + " = " + i + ",");
        }
        pw.println("TK_NONE = " + tokens.size() + ";");
        return dfa;
    }

    public static void writeTransitionTable(PrintWriter pw, DFA dfa, int states) {
        int numTransitions = dfa.mTransitions.length;
        record MutablePackedEntry(IntList v, IntList data) {
        }
        ArrayList<MutablePackedEntry> packedEntries = new ArrayList<MutablePackedEntry>();
        ArrayList<IntArrayList> fullEntries = new ArrayList<IntArrayList>();
        IntArrayList indices = new IntArrayList();
        for (int s = 0; s < states; ++s) {
            IntArraySet transitionSet = new IntArraySet();
            IntArrayList data = new IntArrayList(numTransitions);
            data.size(numTransitions);
            for (int t2 = 0; t2 < numTransitions; ++t2) {
                if (s >= dfa.mTransitions[t2].length) continue;
                int value = dfa.mTransitions[t2][s];
                assert (value >= 0 && value < states);
                data.set(t2, value);
                transitionSet.add(value);
            }
            transitionSet.remove(0);
            if (transitionSet.size() <= 3) {
                int index;
                MutablePackedEntry result = new MutablePackedEntry((IntList)new IntArrayList(3), (IntList)new IntArrayList());
                result.v.addAll((IntCollection)transitionSet);
                result.v.size(3);
                result.v.sort(IntComparators.OPPOSITE_COMPARATOR);
                Int2IntArrayMap translationTable = new Int2IntArrayMap();
                for (index = 0; index < result.v.size(); ++index) {
                    translationTable.put(result.v.getInt(index), index);
                }
                translationTable.put(0, result.v.size());
                for (index = 0; index < data.size(); ++index) {
                    int value = data.getInt(index);
                    assert (translationTable.containsKey(value));
                    result.data.add(translationTable.get(value));
                }
                index = packedEntries.indexOf(result);
                if (index == -1) {
                    index = packedEntries.size();
                    packedEntries.add(result);
                }
                indices.add(index);
                continue;
            }
            int index = fullEntries.indexOf(data);
            if (index == -1) {
                index = fullEntries.size();
                fullEntries.add(data);
            }
            indices.add(~index);
        }
        int maxValue = 0;
        for (MutablePackedEntry entry : packedEntries) {
            for (int index = 0; index < 3; ++index) {
                maxValue = Math.max(maxValue, entry.v.getInt(index));
            }
        }
        int bitsPerValue = 32 - Integer.numberOfLeadingZeros(maxValue - 1);
        maxValue = (1 << bitsPerValue) - 1;
        assert (bitsPerValue <= 10);
        pw.println("public static final short[][] FULL = {");
        int end = fullEntries.size();
        for (int i = 0; i < end; ++i) {
            IntList data = (IntList)fullEntries.get(i);
            assert (data.size() == numTransitions);
            pw.println("{");
            for (int j = 0; j < numTransitions; ++j) {
                pw.print((short)data.getInt(j));
                if (j == numTransitions - 1) {
                    pw.println();
                    continue;
                }
                if (j % 9 == 8) {
                    pw.println(",");
                    continue;
                }
                pw.print(", ");
            }
            if (i == end - 1) {
                pw.println("}");
                continue;
            }
            pw.println("},");
        }
        pw.println("};");
        int packedDataSize = MathUtil.alignTo(numTransitions, 4);
        pw.println("public static final PackedEntry[] PACKED = {");
        int end2 = packedEntries.size();
        for (int i = 0; i < end2; ++i) {
            MutablePackedEntry entry = (MutablePackedEntry)packedEntries.get(i);
            pw.print("new PackedEntry(");
            assert (entry.v.size() == 3);
            pw.print(entry.v.getInt(0));
            if (entry.v.getInt(1) != 0) {
                pw.print(" | (" + entry.v.getInt(1) + " << " + bitsPerValue + ")");
            }
            if (entry.v.getInt(2) != 0) {
                pw.print(" | (" + entry.v.getInt(2) + " << " + 2 * bitsPerValue + ")");
            }
            pw.println(",");
            pw.println("new byte[]{");
            int j = 0;
            int shiftBits = 0;
            int combinedBits = 0;
            for (int index = 0; index < numTransitions; ++index) {
                combinedBits |= entry.data.getInt(index) << shiftBits;
                if ((shiftBits += 2) != 8) continue;
                pw.print((byte)combinedBits);
                if (j == packedDataSize - 1) {
                    pw.println();
                } else if (j % 4 == 3) {
                    pw.println(",");
                } else {
                    pw.print(", ");
                }
                shiftBits = 0;
                combinedBits = 0;
                ++j;
            }
            if (shiftBits > 0) {
                pw.println((byte)combinedBits);
            }
            if (i == end2 - 1) {
                pw.println("})");
                continue;
            }
            pw.println("}),");
        }
        pw.println("};");
        pw.println("public static final short[] INDICES = {");
        end2 = indices.size();
        for (int index = 0; index < end2; ++index) {
            pw.print(indices.getInt(index));
            if (index == end2 - 1) {
                pw.println();
                continue;
            }
            if (index % 9 == 8) {
                pw.println(",");
                continue;
            }
            pw.print(", ");
        }
        pw.println("};");
        pw.println("public static int getTransition(int transition, int state) {");
        pw.println("short index = INDICES[state];");
        pw.println("if (index < 0) return FULL[~index][transition] & 0xFFFF;");
        pw.println("final PackedEntry entry = PACKED[index];");
        pw.println("int v = entry.data[transition >> " + DATA_PER_BYTE_SHIFT + "] & 0xFF;");
        pw.println("v >>= 2 * (transition & 3);");
        pw.println("v &= 3;");
        pw.println("v *= " + bitsPerValue + ";");
        pw.println("return (entry.values >>> v) & " + maxValue + ";");
        pw.println("}");
    }

    public static void main(String[] args) {
        int c;
        PrintWriter pw = new PrintWriter(System.out, false, StandardCharsets.UTF_8);
        DFA dfa = LexerGenerator.process(pw);
        int length = dfa.mCharMappings.length;
        for (c = 0; c < length && dfa.mCharMappings[c] == 0; ++c) {
        }
        assert (c == 9);
        assert (length == 127);
        pw.println("public static final byte[] MAPPINGS = {");
        for (int i = 0; i <= 117; ++i) {
            pw.print(dfa.mCharMappings[i + 9]);
            if (i == 117) {
                pw.println();
                continue;
            }
            if (i % 9 == 8) {
                pw.println(",");
                continue;
            }
            pw.print(", ");
        }
        pw.println("};");
        int states = 0;
        for (int[] row : dfa.mTransitions) {
            states = Math.max(states, row.length);
        }
        LexerGenerator.writeTransitionTable(pw, dfa, states);
        pw.println("public static final byte[] ACCEPTS = {");
        for (int i = 0; i < states; ++i) {
            if (i < dfa.mAccepts.length) {
                pw.print(dfa.mAccepts[i]);
            } else {
                pw.print(-1);
            }
            if (i == states - 1) {
                pw.println();
                continue;
            }
            if (i % 9 == 8) {
                pw.println(",");
                continue;
            }
            pw.print(", ");
        }
        pw.println("};");
        pw.flush();
    }
}

