/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.lex;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.BitSet;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import yslelf.cloudpick.render.compiler.lex.NFA;
import yslelf.cloudpick.render.compiler.lex.NFAState;

@FunctionalInterface
public interface RegexNode {
    public @Unmodifiable IntList transition(NFA var1, @Unmodifiable IntList var2);

    @Nonnull
    public static RegexNode Char(char c) {
        return new Char(c);
    }

    @Nonnull
    public static RegexNode Range(char start, char end) {
        return new Range(start, end);
    }

    @Nonnull
    public static RegexNode Range(RegexNode start, RegexNode end) {
        try {
            return new Range(((Char)start).mChar, ((Char)end).mChar);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("character range contains non-literal characters", e);
        }
    }

    @Nonnull
    public static RegexNode CharClass(RegexNode ... clazz) {
        return new CharClass(clazz, false);
    }

    @Nonnull
    public static RegexNode CharClass(RegexNode[] clazz, boolean exclusive) {
        return new CharClass(clazz, exclusive);
    }

    @Nonnull
    @Contract(pure=true)
    public static RegexNode Concat(RegexNode x, RegexNode y) {
        return (nfa, next) -> x.transition(nfa, y.transition(nfa, next));
    }

    @Nonnull
    @Contract(pure=true)
    public static RegexNode Union(RegexNode x, RegexNode y) {
        return (nfa, next) -> {
            IntList xn = x.transition(nfa, next);
            IntList yn = y.transition(nfa, next);
            int[] result = new int[xn.size() + yn.size()];
            xn.getElements(0, result, 0, xn.size());
            yn.getElements(0, result, xn.size(), yn.size());
            return IntList.of((int[])result);
        };
    }

    @Nonnull
    @Contract(pure=true)
    public static RegexNode Dot() {
        return (nfa, next) -> {
            int state = nfa.add(NFAState.Filter(ch -> ch != 10 && ch != 13, next));
            return IntList.of((int)state);
        };
    }

    @Nonnull
    @Contract(pure=true)
    public static RegexNode Star(RegexNode x) {
        return (nfa, next) -> {
            int state;
            int[] loop = new int[next.size() + 1];
            next.getElements(0, loop, 0, next.size());
            loop[next.size()] = state = nfa.add((NFAState)null);
            IntList left = x.transition(nfa, IntList.of((int[])loop));
            int[] result = new int[left.size() + next.size()];
            left.getElements(0, result, 0, left.size());
            next.getElements(0, result, left.size(), next.size());
            return nfa.replace(state, IntList.of((int[])result));
        };
    }

    @Nonnull
    @Contract(pure=true)
    public static RegexNode Plus(RegexNode x) {
        return (nfa, next) -> {
            int state;
            int[] loop = new int[next.size() + 1];
            next.getElements(0, loop, 0, next.size());
            loop[next.size()] = state = nfa.add((NFAState)null);
            IntList result = x.transition(nfa, IntList.of((int[])loop));
            return nfa.replace(state, result);
        };
    }

    @Nonnull
    @Contract(pure=true)
    public static RegexNode Ques(RegexNode x) {
        return (nfa, next) -> {
            IntList left = x.transition(nfa, next);
            int[] result = new int[left.size() + next.size()];
            left.getElements(0, result, 0, left.size());
            next.getElements(0, result, left.size(), next.size());
            return IntList.of((int[])result);
        };
    }

    public static class Char
    implements RegexNode {
        public final char mChar;

        private Char(char c) {
            this.mChar = c;
        }

        @Override
        public IntList transition(NFA nfa, @Unmodifiable IntList next) {
            int state = nfa.add(NFAState.Filter(ch -> ch == this.mChar, next));
            return IntList.of((int)state);
        }

        public String toString() {
            return "Char(0x" + Integer.toHexString(this.mChar) + ")";
        }
    }

    public static class Range
    implements RegexNode {
        public final char mStart;
        public final char mEnd;

        private Range(char start, char end) {
            if (start > end) {
                throw new IllegalStateException(String.format("character range '%c'-'%c' is out of order", Character.valueOf(start), Character.valueOf(end)));
            }
            this.mStart = start;
            this.mEnd = end;
        }

        @Override
        public IntList transition(NFA nfa, @Unmodifiable IntList next) {
            int state = nfa.add(NFAState.Filter(ch -> ch >= this.mStart && ch <= this.mEnd, next));
            return IntList.of((int)state);
        }

        public String toString() {
            return "Range(0x" + Integer.toHexString(this.mStart) + ", 0x" + Integer.toHexString(this.mEnd) + ")";
        }
    }

    public static class CharClass
    extends BitSet
    implements RegexNode {
        public final boolean mExclusive;

        private CharClass(RegexNode[] clazz, boolean exclusive) {
            this.mExclusive = exclusive;
            for (RegexNode x : clazz) {
                if (x instanceof Char) {
                    Char node = (Char)x;
                    this.set(node.mChar);
                    continue;
                }
                if (x instanceof Range) {
                    Range node = (Range)x;
                    this.set((int)node.mStart, node.mEnd + '\u0001');
                    continue;
                }
                if (x instanceof CharClass) {
                    CharClass node = (CharClass)x;
                    if (node.mExclusive) {
                        assert (false);
                        this.xor(node);
                        continue;
                    }
                    this.or(node);
                    continue;
                }
                throw new AssertionError(x);
            }
        }

        @Override
        public IntList transition(NFA nfa, @Unmodifiable IntList next) {
            int state = nfa.add(NFAState.Filter(ch -> this.get(ch) ^ this.mExclusive, next));
            return IntList.of((int)state);
        }

        @Override
        public String toString() {
            return "CharClass(" + (this.mExclusive ? "^" : "") + super.toString() + ")";
        }
    }
}

