/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.spirv;

import java.util.Arrays;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
class Instruction {
    static final int kWord = 0;
    static final int kNoResult = 1;
    static final int kDefaultPrecisionResult = 2;
    static final int kRelaxedPrecisionResult = 3;
    static final int kUniqueResult = 4;
    static final int kKeyedResult = 5;
    int mOpcode;
    int mResultKind;
    int[] mWords;
    transient int mHash;

    Instruction() {
    }

    Instruction(int opcode, int resultKind, int[] words, int hash) {
        this.mOpcode = opcode;
        this.mResultKind = resultKind;
        this.mWords = words;
        this.mHash = hash;
    }

    static boolean isResult(int kind) {
        return kind >= 2;
    }

    public int hashCode() {
        int h2 = this.mHash;
        if (h2 == 0) {
            h2 = this.mOpcode;
            h2 = 31 * h2 + this.mResultKind;
            for (int j : this.mWords) {
                h2 = 31 * h2 + j;
            }
            this.mHash = h2;
        }
        return h2;
    }

    public boolean equals(Object o) {
        if (o.getClass() != Instruction.class) {
            return false;
        }
        Instruction key = (Instruction)o;
        return this.mOpcode == key.mOpcode && this.mResultKind == key.mResultKind && Arrays.equals(this.mWords, key.mWords);
    }
}

