/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.spirv;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntStack;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.compiler.CodeGenerator;
import yslelf.cloudpick.render.compiler.ConstantFolder;
import yslelf.cloudpick.render.compiler.MemoryLayout;
import yslelf.cloudpick.render.compiler.Operator;
import yslelf.cloudpick.render.compiler.SPIRVVersion;
import yslelf.cloudpick.render.compiler.ShaderCaps;
import yslelf.cloudpick.render.compiler.ShaderCompiler;
import yslelf.cloudpick.render.compiler.ShaderKind;
import yslelf.cloudpick.render.compiler.TargetApi;
import yslelf.cloudpick.render.compiler.TranslationUnit;
import yslelf.cloudpick.render.compiler.analysis.Analysis;
import yslelf.cloudpick.render.compiler.spirv.BufferWriter;
import yslelf.cloudpick.render.compiler.spirv.Instruction;
import yslelf.cloudpick.render.compiler.spirv.InstructionBuilder;
import yslelf.cloudpick.render.compiler.spirv.LValue;
import yslelf.cloudpick.render.compiler.spirv.OutVar;
import yslelf.cloudpick.render.compiler.spirv.PointerLValue;
import yslelf.cloudpick.render.compiler.spirv.SwizzleLValue;
import yslelf.cloudpick.render.compiler.spirv.WordBuffer;
import yslelf.cloudpick.render.compiler.spirv.Writer;
import yslelf.cloudpick.render.compiler.tree.BinaryExpression;
import yslelf.cloudpick.render.compiler.tree.BlockStatement;
import yslelf.cloudpick.render.compiler.tree.ConditionalExpression;
import yslelf.cloudpick.render.compiler.tree.ConstructorArrayCast;
import yslelf.cloudpick.render.compiler.tree.ConstructorCall;
import yslelf.cloudpick.render.compiler.tree.ConstructorCompound;
import yslelf.cloudpick.render.compiler.tree.ConstructorCompoundCast;
import yslelf.cloudpick.render.compiler.tree.ConstructorDiagonalMatrix;
import yslelf.cloudpick.render.compiler.tree.ConstructorScalarCast;
import yslelf.cloudpick.render.compiler.tree.ConstructorVectorSplat;
import yslelf.cloudpick.render.compiler.tree.Expression;
import yslelf.cloudpick.render.compiler.tree.ExpressionStatement;
import yslelf.cloudpick.render.compiler.tree.FieldAccess;
import yslelf.cloudpick.render.compiler.tree.ForLoop;
import yslelf.cloudpick.render.compiler.tree.FunctionCall;
import yslelf.cloudpick.render.compiler.tree.FunctionDecl;
import yslelf.cloudpick.render.compiler.tree.FunctionDefinition;
import yslelf.cloudpick.render.compiler.tree.GlobalVariableDecl;
import yslelf.cloudpick.render.compiler.tree.IfStatement;
import yslelf.cloudpick.render.compiler.tree.IndexExpression;
import yslelf.cloudpick.render.compiler.tree.InterfaceBlock;
import yslelf.cloudpick.render.compiler.tree.Layout;
import yslelf.cloudpick.render.compiler.tree.Literal;
import yslelf.cloudpick.render.compiler.tree.Modifiers;
import yslelf.cloudpick.render.compiler.tree.Node;
import yslelf.cloudpick.render.compiler.tree.PostfixExpression;
import yslelf.cloudpick.render.compiler.tree.PrefixExpression;
import yslelf.cloudpick.render.compiler.tree.ReturnStatement;
import yslelf.cloudpick.render.compiler.tree.Statement;
import yslelf.cloudpick.render.compiler.tree.SwitchCase;
import yslelf.cloudpick.render.compiler.tree.SwitchStatement;
import yslelf.cloudpick.render.compiler.tree.Swizzle;
import yslelf.cloudpick.render.compiler.tree.TopLevelElement;
import yslelf.cloudpick.render.compiler.tree.Type;
import yslelf.cloudpick.render.compiler.tree.Variable;
import yslelf.cloudpick.render.compiler.tree.VariableDecl;
import yslelf.cloudpick.render.compiler.tree.VariableReference;
import yslelf.cloudpick.render.core.MathUtil;

public final class SPIRVCodeGenerator
extends CodeGenerator {
    public static final int GENERATOR_MAGIC_NUMBER = 0;
    public static final int NONE_ID = -1;
    private static final int kInvalid_IntrinsicOpcodeKind = 0;
    private static final int kGLSLstd450_IntrinsicOpcodeKind = 1;
    private static final int kSPIRV_IntrinsicOpcodeKind = 2;
    private static final int kSpecial_IntrinsicOpcodeKind = 3;
    private static final int kAtan_SpecialIntrinsic = 0;
    private static final int kClamp_SpecialIntrinsic = 1;
    private static final int kMatrixCompMult_SpecialIntrinsic = 2;
    private static final int kMax_SpecialIntrinsic = 3;
    private static final int kMin_SpecialIntrinsic = 4;
    private static final int kMix_SpecialIntrinsic = 5;
    private static final int kMod_SpecialIntrinsic = 6;
    private static final int kSaturate_SpecialIntrinsic = 7;
    private static final int kSampledImage_SpecialIntrinsic = 8;
    private static final int kSmoothStep_SpecialIntrinsic = 9;
    private static final int kStep_SpecialIntrinsic = 10;
    private static final int kSubpassLoad_SpecialIntrinsic = 11;
    private static final int kTexture_SpecialIntrinsic = 12;
    private static final int kTextureGrad_SpecialIntrinsic = 13;
    private static final int kTextureLod_SpecialIntrinsic = 14;
    private static final int kTextureFetch_SpecialIntrinsic = 15;
    private static final int kTextureRead_SpecialIntrinsic = 16;
    private static final int kTextureWrite_SpecialIntrinsic = 17;
    private static final int kTextureWidth_SpecialIntrinsic = 18;
    private static final int kTextureHeight_SpecialIntrinsic = 19;
    private static final int kAtomicAdd_SpecialIntrinsic = 20;
    private static final int kAtomicLoad_SpecialIntrinsic = 21;
    private static final int kAtomicStore_SpecialIntrinsic = 22;
    private static final int kStorageBarrier_SpecialIntrinsic = 23;
    private static final int kWorkgroupBarrier_SpecialIntrinsic = 24;
    private static final int kIntrinsicDataColumn = 5;
    private static final int[] sIntrinsicData = new int[770];
    public final TargetApi mOutputTarget;
    public final SPIRVVersion mOutputVersion;
    private final WordBuffer mNameBuffer = new WordBuffer();
    private final WordBuffer mConstantBuffer = new WordBuffer();
    private final WordBuffer mDecorationBuffer = new WordBuffer();
    private final WordBuffer mFunctionBuffer = new WordBuffer();
    private final WordBuffer mGlobalInitBuffer = new WordBuffer();
    private final WordBuffer mVariableBuffer = new WordBuffer();
    private final WordBuffer mBodyBuffer = new WordBuffer();
    private final HashMap<Type, int[]> mStructTable = new HashMap();
    private final Reference2IntOpenHashMap<FunctionDecl> mFunctionTable = new Reference2IntOpenHashMap();
    private final Reference2IntOpenHashMap<Variable> mVariableTable = new Reference2IntOpenHashMap();
    private final IntArrayList[] mIdListPool = new IntArrayList[6];
    private int mIdListPoolSize = 0;
    private final InstructionBuilder[] mInstBuilderPool = new InstructionBuilder[10];
    private int mInstBuilderPoolSize = 0;
    private final Object2IntOpenHashMap<Instruction> mOpCache = new Object2IntOpenHashMap();
    private final Int2ObjectOpenHashMap<Instruction> mSpvIdCache = new Int2ObjectOpenHashMap();
    final Int2IntOpenHashMap mStoreCache = new Int2IntOpenHashMap();
    private final IntArrayList mReachableOps = new IntArrayList();
    private final IntArrayList mStoreOps = new IntArrayList();
    private int mCurrentBlock = 0;
    private final IntStack mBreakTarget = new IntArrayList();
    private final IntStack mContinueTarget = new IntArrayList();
    private static final int kBranchIsAbove = 0;
    private static final int kBranchIsBelow = 1;
    private static final int kBranchesOnBothSides = 2;
    private final IntArrayList mAccessChain = new IntArrayList();
    private final IntOpenHashSet mCapabilities = new IntOpenHashSet(16, 0.5f);
    private final IntArrayList mInterfaceVariables = new IntArrayList();
    private FunctionDecl mEntryPointFunction;
    private int mIdCount = 1;
    private int mGLSLExtendedInstructions;
    private boolean mEmitNames;

    private static void setIntrinsic(int intrinsic, int opKind, int floatOp, int signedOp, int unsignedOp, int booleanOp) {
        assert (intrinsic >= 0 && intrinsic < 154);
        int index = intrinsic * 5;
        SPIRVCodeGenerator.sIntrinsicData[index] = opKind;
        SPIRVCodeGenerator.sIntrinsicData[index + 1] = floatOp;
        SPIRVCodeGenerator.sIntrinsicData[index + 2] = signedOp;
        SPIRVCodeGenerator.sIntrinsicData[index + 3] = unsignedOp;
        SPIRVCodeGenerator.sIntrinsicData[index + 4] = booleanOp;
    }

    public SPIRVCodeGenerator(@Nonnull ShaderCompiler compiler, @Nonnull TranslationUnit translationUnit, @Nonnull ShaderCaps shaderCaps) {
        super(compiler, translationUnit);
        this.mOutputTarget = Objects.requireNonNullElse(shaderCaps.mTargetApi, TargetApi.VULKAN_1_0);
        this.mOutputVersion = Objects.requireNonNullElse(shaderCaps.mSPIRVVersion, SPIRVVersion.SPIRV_1_0);
    }

    @Override
    @Nullable
    public ByteBuffer generateCode() {
        assert (this.getContext().getErrorHandler().errorCount() == 0);
        if (this.mOutputTarget.isOpenGLES()) {
            this.getContext().error(-1, "OpenGL ES is not a valid client API for SPIR-V");
            return null;
        }
        ShaderKind kind = this.mTranslationUnit.getKind();
        if (!(kind.isVertex() || kind.isFragment() || kind.isCompute())) {
            this.getContext().error(-1, "shader kind " + kind + " is not executable in SPIR-V");
            return null;
        }
        this.mEmitNames = !this.getContext().getOptions().mMinifyNames;
        this.buildInstructions(this.mTranslationUnit);
        if (this.getContext().getErrorHandler().errorCount() != 0) {
            return null;
        }
        String entryPointName = this.mEntryPointFunction.getName();
        int estimatedSize = 20;
        estimatedSize += this.mCapabilities.size() * 2 * 4;
        estimatedSize += 24;
        estimatedSize += 12;
        int entryPointWordCount = 3 + (entryPointName.length() + 4) / 4 + this.mInterfaceVariables.size();
        estimatedSize += entryPointWordCount * 4;
        estimatedSize += this.mNameBuffer.size() * 4;
        estimatedSize += this.mDecorationBuffer.size() * 4;
        estimatedSize += this.mConstantBuffer.size() * 4;
        estimatedSize += this.mFunctionBuffer.size() * 4;
        BufferWriter writer = new BufferWriter(estimatedSize += 12);
        writer.writeWord(119734787);
        writer.writeWord(this.mOutputVersion.mVersionNumber);
        writer.writeWord(0);
        writer.writeWord(this.mIdCount);
        writer.writeWord(0);
        IntIterator it = this.mCapabilities.iterator();
        while (it.hasNext()) {
            this.writeInstruction(17, it.nextInt(), writer);
        }
        this.writeInstruction(11, this.mGLSLExtendedInstructions, "GLSL.std.450", (Writer)writer);
        this.writeInstruction(14, 0, 1, (Writer)writer);
        this.writeOpcode(15, entryPointWordCount, writer);
        if (kind.isVertex()) {
            writer.writeWord(0);
        } else if (kind.isFragment()) {
            writer.writeWord(4);
        } else if (kind.isCompute()) {
            writer.writeWord(5);
        }
        int entryPoint = this.mFunctionTable.getInt((Object)this.mEntryPointFunction);
        writer.writeWord(entryPoint);
        writer.writeString8(this.getContext(), entryPointName);
        IntListIterator intListIterator = this.mInterfaceVariables.iterator();
        while (intListIterator.hasNext()) {
            int id2 = (Integer)intListIterator.next();
            writer.writeWord(id2);
        }
        if (kind.isFragment()) {
            this.writeInstruction(16, entryPoint, this.mOutputTarget.isOpenGL() ? 8 : 7, (Writer)writer);
        }
        writer.writeWords(this.mNameBuffer.elements(), this.mNameBuffer.size());
        writer.writeWords(this.mDecorationBuffer.elements(), this.mDecorationBuffer.size());
        writer.writeWords(this.mConstantBuffer.elements(), this.mConstantBuffer.size());
        writer.writeWords(this.mFunctionBuffer.elements(), this.mFunctionBuffer.size());
        if (this.getContext().getErrorHandler().errorCount() != 0) {
            return null;
        }
        return writer.detach();
    }

    private int getStorageClass(@Nonnull Variable variable) {
        Type type = variable.getType();
        if (type.isArray()) {
            type = type.getElementType();
        }
        if (type.isOpaque()) {
            return 0;
        }
        Modifiers modifiers = variable.getModifiers();
        if (variable.getStorage() == 1) {
            if ((modifiers.flags() & 0x20) != 0) {
                return 1;
            }
            if ((modifiers.flags() & 0x40) != 0) {
                return 3;
            }
        }
        if (modifiers.isBuffer() && this.mOutputVersion.isAtLeast(SPIRVVersion.SPIRV_1_3)) {
            return 12;
        }
        if ((modifiers.flags() & 0x1010) != 0) {
            if ((modifiers.layoutFlags() & 0x10) != 0) {
                return 9;
            }
            if (type.isInterfaceBlock()) {
                return 2;
            }
            if (this.mOutputTarget.isVulkan()) {
                this.getContext().error(variable.mPosition, "uniform variables at global scope are not allowed");
            }
            return 0;
        }
        if ((modifiers.flags() & 0x2000) != 0) {
            return 4;
        }
        return variable.getStorage() == 1 ? 6 : 7;
    }

    private int getStorageClass(@Nonnull Expression expr) {
        switch (expr.getKind()) {
            case VARIABLE_REFERENCE: {
                return this.getStorageClass(((VariableReference)expr).getVariable());
            }
            case INDEX: {
                return this.getStorageClass(((IndexExpression)expr).getBase());
            }
            case FIELD_ACCESS: {
                return this.getStorageClass(((FieldAccess)expr).getBase());
            }
        }
        return 7;
    }

    int getUniqueId(@Nonnull Type type) {
        return this.getUniqueId(type.isRelaxedPrecision());
    }

    private int getUniqueId(boolean relaxedPrecision) {
        int id2 = this.getUniqueId();
        if (relaxedPrecision) {
            this.writeInstruction(71, id2, 0, (Writer)this.mDecorationBuffer);
        }
        return id2;
    }

    private int getUniqueId() {
        return this.mIdCount++;
    }

    @Nullable
    private Instruction resultTypeForInstruction(@Nonnull Instruction inst) {
        int resultTypeWord;
        switch (inst.mOpcode) {
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 61: 
            case 80: 
            case 81: {
                resultTypeWord = 0;
                break;
            }
            default: {
                return null;
            }
        }
        Instruction typeInst = (Instruction)this.mSpvIdCache.get(inst.mWords[resultTypeWord]);
        assert (typeInst != null);
        return typeInst;
    }

    private int numComponentsForVecInstruction(Instruction inst) {
        Instruction typeInst = this.resultTypeForInstruction(inst);
        assert (typeInst != null);
        assert (typeInst.mOpcode == 23 || typeInst.mOpcode == 22 || typeInst.mOpcode == 21 || typeInst.mOpcode == 20);
        return typeInst.mOpcode == 23 ? typeInst.mWords[2] : 1;
    }

    private int getComponent(int id2, int index) {
        Instruction inst = (Instruction)this.mSpvIdCache.get(id2);
        if (inst == null) {
            return -1;
        }
        if (inst.mOpcode == 44) {
            return inst.mWords[2 + index];
        }
        if (inst.mOpcode == 80) {
            Instruction composedType = (Instruction)this.mSpvIdCache.get(inst.mWords[0]);
            assert (composedType != null);
            if (composedType.mOpcode != 23) {
                return inst.mWords[2 + index];
            }
            for (int i = 2; i < inst.mWords.length; ++i) {
                int currentWord = inst.mWords[i];
                Instruction subInst = (Instruction)this.mSpvIdCache.get(currentWord);
                if (subInst == null) {
                    return -1;
                }
                int numComponents = this.numComponentsForVecInstruction(subInst);
                if (index < numComponents) {
                    if (numComponents == 1) {
                        assert (index == 0);
                        return currentWord;
                    }
                    return this.getComponent(currentWord, index);
                }
                index -= numComponents;
            }
            assert (false) : "component index goes past the end of this composite value";
            return -1;
        }
        return -1;
    }

    private boolean getConstants(int value, IntArrayList constants) {
        Instruction inst = (Instruction)this.mSpvIdCache.get(value);
        if (inst == null) {
            return false;
        }
        return switch (inst.mOpcode) {
            case 41, 42, 43 -> {
                constants.add(value);
                yield true;
            }
            case 44 -> {
                for (int i = 2; i < inst.mWords.length; ++i) {
                    if (this.getConstants(inst.mWords[i], constants)) continue;
                    yield false;
                }
                yield true;
            }
            default -> false;
        };
    }

    private boolean getConstants(IntArrayList values, IntArrayList constants) {
        for (int i = 0; i < values.size(); ++i) {
            if (this.getConstants(values.getInt(i), constants)) continue;
            return false;
        }
        return true;
    }

    private InstructionBuilder getInstBuilder(int opcode) {
        if (this.mInstBuilderPoolSize == 0) {
            return new InstructionBuilder(opcode);
        }
        return this.mInstBuilderPool[--this.mInstBuilderPoolSize].reset(opcode);
    }

    int writeType(@Nonnull Type type) {
        return this.writeType(type, null, null);
    }

    private int writeType(@Nonnull Type type, @Nullable Modifiers modifiers, @Nullable MemoryLayout memoryLayout) {
        return switch (type.getTypeKind()) {
            case 8 -> this.writeInstructionWithCache(this.getInstBuilder(19).addResult(), this.mConstantBuffer);
            case 5 -> {
                if (type.isBoolean()) {
                    yield this.writeInstructionWithCache(this.getInstBuilder(20).addResult(), this.mConstantBuffer);
                }
                if (type.isInteger()) {
                    if (!$assertionsDisabled && type.getWidth() != 32) {
                        throw new AssertionError();
                    }
                    yield this.writeInstructionWithCache(this.getInstBuilder(21).addResult().addWord(type.getWidth()).addWord(type.isSigned() ? 1 : 0), this.mConstantBuffer);
                }
                if (type.isFloat()) {
                    if (!$assertionsDisabled && type.getWidth() != 32) {
                        throw new AssertionError();
                    }
                    yield this.writeInstructionWithCache(this.getInstBuilder(22).addResult().addWord(type.getWidth()), this.mConstantBuffer);
                }
                throw new AssertionError();
            }
            case 7 -> {
                int scalarTypeId = this.writeType(type.getElementType(), modifiers, memoryLayout);
                yield this.writeInstructionWithCache(this.getInstBuilder(23).addResult().addWord(scalarTypeId).addWord(type.getRows()), this.mConstantBuffer);
            }
            case 2 -> {
                int vectorTypeId = this.writeType(type.getElementType(), modifiers, memoryLayout);
                yield this.writeInstructionWithCache(this.getInstBuilder(24).addResult().addWord(vectorTypeId).addWord(type.getCols()), this.mConstantBuffer);
            }
            case 0 -> {
                int resultId;
                int stride;
                if (memoryLayout != null) {
                    if (!memoryLayout.isSupported(type)) {
                        this.getContext().error(type.mPosition, "type '" + type + "' is not permitted here");
                        yield -1;
                    }
                    stride = memoryLayout.stride(type);
                    if (!$assertionsDisabled && stride <= 0) {
                        throw new AssertionError();
                    }
                } else if (MemoryLayout.Std140.isSupported(type)) {
                    stride = MemoryLayout.Std140.stride(type);
                    if (!$assertionsDisabled && stride <= 0) {
                        throw new AssertionError();
                    }
                } else {
                    stride = 0;
                }
                int elementTypeId = this.writeType(type.getElementType(), modifiers, memoryLayout);
                if (type.isUnsizedArray()) {
                    resultId = this.writeInstructionWithCache(this.getInstBuilder(29).addKeyedResult(stride).addWord(elementTypeId), this.mConstantBuffer);
                } else {
                    int arraySize = type.getArraySize();
                    if (arraySize <= 0) {
                        this.getContext().error(type.mPosition, "array size must be positive");
                        yield -1;
                    }
                    int arraySizeId = this.writeScalarConstant(arraySize, this.getContext().getTypes().mInt);
                    resultId = this.writeInstructionWithCache(this.getInstBuilder(28).addKeyedResult(stride).addWord(elementTypeId).addWord(arraySizeId), this.mConstantBuffer);
                }
                if (stride > 0) {
                    this.writeInstructionWithCache(this.getInstBuilder(71).addWord(resultId).addWord(6).addWord(stride), this.mDecorationBuffer);
                }
                yield resultId;
            }
            case 6 -> this.writeStruct(type, memoryLayout);
            case 4 -> {
                if (type.isSeparateSampler()) {
                    yield this.writeInstructionWithCache(this.getInstBuilder(26).addResult(), this.mConstantBuffer);
                }
                int sampledTypeId = this.writeType(type.getComponentType());
                int format = 0;
                int imageTypeId = this.writeInstructionWithCache(this.getInstBuilder(25).addResult().addWord(sampledTypeId).addWord(type.getDimensions()).addWord(type.isShadow() ? 1 : 0).addWord(type.isArrayed() ? 1 : 0).addWord(type.isMultiSampled() ? 1 : 0).addWord(type.isSampled() ? 1 : 2).addWord(format), this.mConstantBuffer);
                if (type.isCombinedSampler()) {
                    if (type.getDimensions() == 5) {
                        this.mCapabilities.add(46);
                    }
                    yield this.writeInstructionWithCache(this.getInstBuilder(27).addResult().addWord(imageTypeId), this.mConstantBuffer);
                }
                yield imageTypeId;
            }
            default -> {
                this.getContext().error(type.mPosition, "type '" + type + "' is not permitted here");
                yield -1;
            }
        };
    }

    private int writeStruct(@Nonnull Type type, @Nullable MemoryLayout memoryLayout) {
        boolean unique;
        int slot;
        assert (type.isStruct());
        int[] cached = this.mStructTable.computeIfAbsent(type, __ -> new int[MemoryLayout.Scalar.ordinal() + 2]);
        int resultId = cached[slot = memoryLayout == null ? 0 : memoryLayout.ordinal() + 1];
        if (resultId != 0) {
            return resultId;
        }
        if (slot == 0) {
            for (int i = 1; i < cached.length; ++i) {
                resultId = cached[i];
                if (resultId == 0) continue;
                return resultId;
            }
        } else {
            resultId = cached[0];
            if (resultId != 0) {
                cached[0] = 0;
            }
        }
        Type.Field[] fields = type.getFields();
        if (resultId == 0) {
            unique = true;
            InstructionBuilder builder = this.getInstBuilder(30).addUniqueResult();
            for (Type.Field f2 : fields) {
                int typeId = this.writeType(f2.type(), f2.modifiers(), memoryLayout);
                builder.addWord(typeId);
            }
            resultId = this.writeInstructionWithCache(builder, this.mConstantBuffer);
            if (this.mEmitNames) {
                this.writeInstruction(5, resultId, type.getName(), (Writer)this.mNameBuffer);
            }
        } else {
            unique = false;
        }
        cached[slot] = resultId;
        int offset = 0;
        int[] size = new int[3];
        for (int i = 0; i < fields.length; ++i) {
            Type.Field field = fields[i];
            if (unique) {
                if (this.mEmitNames) {
                    this.writeInstruction(6, resultId, i, field.name(), (Writer)this.mNameBuffer);
                }
                if (field.type().isRelaxedPrecision()) {
                    this.writeInstruction(72, resultId, i, 0, (Writer)this.mDecorationBuffer);
                }
                this.writeFieldModifiers(field.modifiers(), resultId, i);
            }
            if (memoryLayout == null) continue;
            if (!memoryLayout.isSupported(field.type())) {
                this.getContext().error(field.position(), "type '" + field.type() + "' is not permitted here");
                return resultId;
            }
            int alignment = memoryLayout.alignment(field.type(), size);
            int fieldOffset = field.modifiers().layoutOffset();
            if (fieldOffset >= 0) {
                if (fieldOffset < offset) {
                    this.getContext().error(field.position(), "offset of field '" + field.name() + "' must be at least " + offset);
                }
                if ((fieldOffset & alignment - 1) != 0) {
                    this.getContext().error(field.position(), "offset of field '" + field.name() + "' must round up to " + alignment);
                }
                offset = fieldOffset;
            } else {
                offset = MathUtil.alignTo(offset, alignment);
            }
            if (field.modifiers().layoutBuiltin() >= 0) {
                this.getContext().error(field.position(), "builtin field '" + field.name() + "' cannot be explicitly laid out.");
            } else {
                this.writeInstruction(72, resultId, i, 35, offset, this.mDecorationBuffer);
            }
            int matrixStride = size[1];
            if (matrixStride > 0) {
                assert (field.type().isMatrix() || field.type().isArray() && field.type().getElementType().isMatrix());
                this.writeInstruction(72, resultId, i, 5, (Writer)this.mDecorationBuffer);
                this.writeInstruction(72, resultId, i, 7, matrixStride, this.mDecorationBuffer);
            }
            offset += size[0];
        }
        return resultId;
    }

    private int writeFunction(@Nonnull FunctionDefinition func, Writer writer) {
        int numReachableOps = this.mReachableOps.size();
        int numStoreOps = this.mStoreOps.size();
        this.mVariableBuffer.clear();
        int result = this.writeFunctionDecl(func.getFunctionDecl(), writer);
        this.mCurrentBlock = 0;
        this.writeLabel(this.getUniqueId(), writer);
        this.mBodyBuffer.clear();
        this.writeBlockStatement(func.getBody(), this.mBodyBuffer);
        writer.writeWords(this.mVariableBuffer.elements(), this.mVariableBuffer.size());
        if (func.getFunctionDecl().isEntryPoint()) {
            writer.writeWords(this.mGlobalInitBuffer.elements(), this.mGlobalInitBuffer.size());
        }
        writer.writeWords(this.mBodyBuffer.elements(), this.mBodyBuffer.size());
        if (this.mCurrentBlock != 0) {
            if (func.getFunctionDecl().getReturnType().isVoid()) {
                this.writeInstruction(253, writer);
            } else {
                this.writeInstruction(255, writer);
            }
        }
        this.writeInstruction(56, writer);
        this.pruneConditionalOps(numReachableOps, numStoreOps);
        return result;
    }

    private int writeFunctionDecl(@Nonnull FunctionDecl decl, Writer writer) {
        String mangledName;
        int result = this.mFunctionTable.getInt((Object)decl);
        int returnTypeId = this.writeType(decl.getReturnType());
        int functionTypeId = this.writeFunctionType(decl);
        this.writeInstruction(54, returnTypeId, result, 0, functionTypeId, writer);
        if (this.mEmitNames && (mangledName = decl.getMangledName()).length() <= 5200) {
            this.writeInstruction(5, result, mangledName, (Writer)this.mNameBuffer);
        }
        for (Variable parameter : decl.getParameters()) {
            int id2 = this.getUniqueId();
            this.mVariableTable.put((Object)parameter, id2);
            int type = this.writeFunctionParameterType(parameter.getType(), parameter.getModifiers());
            this.writeInstruction(55, type, id2, writer);
        }
        return result;
    }

    private int writeFunctionType(@Nonnull FunctionDecl function) {
        int returnTypeId = this.writeType(function.getReturnType());
        InstructionBuilder builder = this.getInstBuilder(33).addResult().addWord(returnTypeId);
        for (Variable parameter : function.getParameters()) {
            int typeId = this.writeFunctionParameterType(parameter.getType(), parameter.getModifiers());
            builder.addWord(typeId);
        }
        return this.writeInstructionWithCache(builder, this.mConstantBuffer);
    }

    private int writeFunctionParameterType(@Nonnull Type paramType, @Nullable Modifiers paramMods) {
        int storageClass = paramType.isOpaque() ? 0 : 7;
        return this.writePointerType(paramType, paramMods, null, storageClass);
    }

    private int writePointerType(@Nonnull Type type, int storageClass) {
        return this.writePointerType(type, null, null, storageClass);
    }

    private int writePointerType(@Nonnull Type type, @Nullable Modifiers modifiers, @Nullable MemoryLayout memoryLayout, int storageClass) {
        int typeId = this.writeType(type, modifiers, memoryLayout);
        return this.writeInstructionWithCache(this.getInstBuilder(32).addResult().addWord(storageClass).addWord(typeId), this.mConstantBuffer);
    }

    private int writeOpCompositeExtract(@Nonnull Type type, int base, int index, Writer writer) {
        int result = this.getComponent(base, index);
        if (result != -1) {
            return result;
        }
        int typeId = this.writeType(type);
        return this.writeInstructionWithCache(this.getInstBuilder(81).addWord(typeId).addResult().addWord(base).addWord(index), writer);
    }

    private int writeOpCompositeExtract(@Nonnull Type type, int base, int index1, int index2, Writer writer) {
        int result = this.getComponent(base, index1);
        if (result != -1) {
            return this.writeOpCompositeExtract(type, result, index2, writer);
        }
        int typeId = this.writeType(type);
        return this.writeInstructionWithCache(this.getInstBuilder(81).addWord(typeId).addResult().addWord(base).addWord(index1).addWord(index2), writer);
    }

    private int writeOpCompositeConstruct(@Nonnull Type type, IntArrayList values, Writer writer) {
        if (type.isVector() || type.isMatrix()) {
            IntArrayList constants = this.obtainIdList();
            if (this.getConstants(values, constants)) {
                int resultId;
                if (type.isVector()) {
                    resultId = this.writeOpConstantComposite(type, constants.elements(), 0, constants.size());
                } else {
                    assert (type.isMatrix());
                    assert (constants.size() == type.getComponents());
                    int start = constants.size();
                    Type columnType = type.getComponentType().toVector(this.getContext(), type.getRows());
                    for (int index = 0; index < type.getCols(); ++index) {
                        constants.add(this.writeOpConstantComposite(columnType, constants.elements(), index * type.getRows(), type.getRows()));
                    }
                    resultId = this.writeOpConstantComposite(type, constants.elements(), start, type.getCols());
                }
                this.releaseIdList(constants);
                return resultId;
            }
            this.releaseIdList(constants);
        }
        int typeId = this.writeType(type);
        return this.writeInstructionWithCache(this.getInstBuilder(80).addWord(typeId).addResult().addWords(values.elements(), 0, values.size()), writer);
    }

    private int writeOpConstantTrue(@Nonnull Type type) {
        assert (type.isBoolean());
        int typeId = this.writeType(type);
        return this.writeInstructionWithCache(this.getInstBuilder(41).addWord(typeId).addResult(), this.mConstantBuffer);
    }

    private int writeOpConstantFalse(@Nonnull Type type) {
        assert (type.isBoolean());
        int typeId = this.writeType(type);
        return this.writeInstructionWithCache(this.getInstBuilder(42).addWord(typeId).addResult(), this.mConstantBuffer);
    }

    private int writeOpConstant(@Nonnull Type type, int valueBits) {
        assert (type.isInteger() || type.isFloat());
        assert (type.getWidth() == 32);
        int typeId = this.writeType(type);
        return this.writeInstructionWithCache(this.getInstBuilder(43).addWord(typeId).addResult().addWord(valueBits), this.mConstantBuffer);
    }

    private int writeOpConstantComposite(@Nonnull Type type, int[] values, int offset, int count) {
        assert (!type.isVector() || count == type.getRows());
        assert (!type.isMatrix() || count == type.getCols());
        assert (!type.isArray() || count == type.getArraySize());
        assert (!type.isStruct() || count == type.getFields().length);
        int typeId = this.writeType(type);
        return this.writeInstructionWithCache(this.getInstBuilder(44).addWord(typeId).addResult().addWords(values, offset, count), this.mConstantBuffer);
    }

    private int writeScalarConstant(double value, Type type) {
        int valueBits;
        switch (type.getScalarKind()) {
            case 3: {
                return value != 0.0 ? this.writeOpConstantTrue(type) : this.writeOpConstantFalse(type);
            }
            case 0: {
                valueBits = Float.floatToRawIntBits((float)value);
                break;
            }
            case 1: {
                valueBits = (int)value;
                break;
            }
            case 2: {
                valueBits = (int)value;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        assert (type.getWidth() == 32);
        return this.writeOpConstant(type, valueBits);
    }

    private int writeLiteral(@Nonnull Literal literal) {
        return this.writeScalarConstant(literal.getValue(), literal.getType());
    }

    private void writeModifiers(@Nonnull Modifiers modifiers, int targetId) {
        Layout layout = modifiers.layout();
        boolean hasLocation = false;
        boolean hasBinding = false;
        boolean isPushConstant = false;
        int descriptorSet = -1;
        if (layout != null) {
            boolean bl = isPushConstant = (layout.layoutFlags() & 0x10) != 0;
            if (layout.mLocation >= 0) {
                this.writeInstruction(71, targetId, 30, layout.mLocation, (Writer)this.mDecorationBuffer);
                hasLocation = true;
            }
            if (layout.mComponent >= 0) {
                this.writeInstruction(71, targetId, 31, layout.mComponent, (Writer)this.mDecorationBuffer);
            }
            if (layout.mIndex >= 0) {
                this.writeInstruction(71, targetId, 32, layout.mIndex, (Writer)this.mDecorationBuffer);
            }
            if (layout.mBinding >= 0) {
                if (isPushConstant) {
                    this.getContext().error(modifiers.mPosition, "cannot combine 'binding' with 'push_constants'");
                } else {
                    this.writeInstruction(71, targetId, 33, layout.mBinding, (Writer)this.mDecorationBuffer);
                }
                hasBinding = true;
            }
            if (layout.mSet >= 0) {
                if (isPushConstant) {
                    this.getContext().error(modifiers.mPosition, "cannot combine 'set' with 'push_constants'");
                } else {
                    this.writeInstruction(71, targetId, 34, layout.mSet, (Writer)this.mDecorationBuffer);
                }
                descriptorSet = layout.mSet;
            }
            if (layout.mInputAttachmentIndex >= 0) {
                this.writeInstruction(71, targetId, 43, layout.mInputAttachmentIndex, (Writer)this.mDecorationBuffer);
                this.mCapabilities.add(40);
            }
            if (layout.mBuiltin >= 0) {
                this.writeInstruction(71, targetId, 11, layout.mBuiltin, (Writer)this.mDecorationBuffer);
            }
        }
        if ((modifiers.flags() & 0x1010) != 0) {
            if (!hasBinding) {
                this.getContext().warning(modifiers.mPosition, "'binding' is missing");
            }
            if (descriptorSet < 0) {
                if (this.mOutputTarget.isVulkan() && !isPushConstant) {
                    this.writeInstruction(71, targetId, 34, 0, (Writer)this.mDecorationBuffer);
                }
            } else if (this.mOutputTarget.isOpenGL()) {
                this.getContext().error(modifiers.mPosition, "'set' is not allowed");
            }
        }
        if ((modifiers.flags() & 1) == 0) {
            if ((modifiers.flags() & 4) != 0) {
                this.writeInstruction(71, targetId, 13, (Writer)this.mDecorationBuffer);
            } else if ((modifiers.flags() & 2) != 0) {
                this.writeInstruction(71, targetId, 14, (Writer)this.mDecorationBuffer);
            }
        }
        if ((modifiers.flags() & 0x100) != 0) {
            this.writeInstruction(71, targetId, 21, (Writer)this.mDecorationBuffer);
        }
        if ((modifiers.flags() & 0x180) != 0) {
            this.writeInstruction(71, targetId, 23, (Writer)this.mDecorationBuffer);
        }
        if ((modifiers.flags() & 0x200) != 0) {
            this.writeInstruction(71, targetId, 19, (Writer)this.mDecorationBuffer);
        }
        if ((modifiers.flags() & 0x400) != 0) {
            this.writeInstruction(71, targetId, 24, (Writer)this.mDecorationBuffer);
        }
        if ((modifiers.flags() & 0x800) != 0) {
            this.writeInstruction(71, targetId, 25, (Writer)this.mDecorationBuffer);
        }
    }

    private void writeFieldModifiers(@Nonnull Modifiers modifiers, int targetId, int member) {
        Layout layout = modifiers.layout();
        if (layout != null) {
            assert (layout.mIndex == -1);
            assert (layout.mBinding == -1);
            assert (layout.mSet == -1);
            assert (layout.mInputAttachmentIndex == -1);
            if (layout.mLocation >= 0) {
                this.writeInstruction(72, targetId, member, 30, layout.mLocation, this.mDecorationBuffer);
            }
            if (layout.mComponent >= 0) {
                this.writeInstruction(72, targetId, member, 31, layout.mComponent, this.mDecorationBuffer);
            }
            if (layout.mBuiltin >= 0) {
                this.writeInstruction(72, targetId, member, 11, layout.mBuiltin, this.mDecorationBuffer);
            }
        }
        if ((modifiers.flags() & 1) == 0) {
            if ((modifiers.flags() & 4) != 0) {
                this.writeInstruction(72, targetId, member, 13, (Writer)this.mDecorationBuffer);
            } else if ((modifiers.flags() & 2) != 0) {
                this.writeInstruction(72, targetId, member, 14, (Writer)this.mDecorationBuffer);
            }
        }
        if ((modifiers.flags() & 0x100) != 0) {
            this.writeInstruction(72, targetId, member, 21, (Writer)this.mDecorationBuffer);
        }
        if ((modifiers.flags() & 0x180) != 0) {
            this.writeInstruction(72, targetId, member, 23, (Writer)this.mDecorationBuffer);
        }
        if ((modifiers.flags() & 0x200) != 0) {
            this.writeInstruction(72, targetId, member, 19, (Writer)this.mDecorationBuffer);
        }
        if ((modifiers.flags() & 0x400) != 0) {
            this.writeInstruction(72, targetId, member, 24, (Writer)this.mDecorationBuffer);
        }
        if ((modifiers.flags() & 0x800) != 0) {
            this.writeInstruction(72, targetId, member, 25, (Writer)this.mDecorationBuffer);
        }
    }

    private int writeInterfaceBlock(@Nonnull InterfaceBlock block) {
        int resultId = this.getUniqueId();
        Variable variable = block.getVariable();
        Modifiers modifiers = variable.getModifiers();
        MemoryLayout desiredLayout = (modifiers.layoutFlags() & 0x20) != 0 ? MemoryLayout.Std140 : ((modifiers.layoutFlags() & 0x40) != 0 ? MemoryLayout.Std430 : null);
        MemoryLayout memoryLayout = modifiers.isBuffer() ? (desiredLayout != null ? desiredLayout : MemoryLayout.Std430) : (modifiers.isUniform() ? (desiredLayout != null ? desiredLayout : ((modifiers.layoutFlags() & 0x10) != 0 ? MemoryLayout.Std430 : MemoryLayout.Extended)) : null);
        Type type = variable.getType();
        assert (type.isInterfaceBlock());
        if (memoryLayout != null && !memoryLayout.isSupported(type)) {
            this.getContext().error(type.mPosition, "type '" + type + "' is not permitted here");
            return resultId;
        }
        int typeId = this.writeStruct(type, memoryLayout);
        if (modifiers.layoutBuiltin() == -1) {
            boolean legacyBufferBlock = modifiers.isBuffer() && this.mOutputVersion.isBefore(SPIRVVersion.SPIRV_1_3);
            this.writeInstruction(71, typeId, legacyBufferBlock ? 3 : 2, (Writer)this.mDecorationBuffer);
        }
        this.writeModifiers(modifiers, resultId);
        int ptrTypeId = this.getUniqueId();
        int storageClass = this.getStorageClass(variable);
        this.writeInstruction(32, ptrTypeId, storageClass, typeId, (Writer)this.mConstantBuffer);
        this.writeInstruction(59, ptrTypeId, resultId, storageClass, (Writer)this.mConstantBuffer);
        if (this.mEmitNames) {
            this.writeInstruction(5, resultId, variable.getName(), (Writer)this.mNameBuffer);
        }
        this.mVariableTable.put((Object)variable, resultId);
        return resultId;
    }

    private static boolean is_compile_time_constant(VariableDecl variableDecl) {
        return !(!variableDecl.getVariable().getModifiers().isConst() || !variableDecl.getVariable().getType().isScalar() && !variableDecl.getVariable().getType().isVector() || ConstantFolder.getConstantValueOrNullForVariable(variableDecl.getInit()) == null && !Analysis.isCompileTimeConstant(variableDecl.getInit()));
    }

    private boolean writeGlobalVariableDecl(VariableDecl variableDecl) {
        if (SPIRVCodeGenerator.is_compile_time_constant(variableDecl)) {
            return true;
        }
        int storageClass = this.getStorageClass(variableDecl.getVariable());
        int id2 = this.writeGlobalVariable(storageClass, variableDecl.getVariable());
        if (variableDecl.getInit() != null) {
            int init = this.writeExpression(variableDecl.getInit(), this.mGlobalInitBuffer);
            this.writeOpStore(storageClass, id2, init, this.mGlobalInitBuffer);
        }
        return true;
    }

    private int writeGlobalVariable(int storageClass, Variable variable) {
        Type type = variable.getType();
        int resultId = this.getUniqueId(type);
        Modifiers modifiers = variable.getModifiers();
        this.writeModifiers(modifiers, resultId);
        int ptrTypeId = this.writePointerType(type, modifiers, null, storageClass);
        this.writeInstruction(59, ptrTypeId, resultId, storageClass, (Writer)this.mConstantBuffer);
        if (this.mEmitNames) {
            this.writeInstruction(5, resultId, variable.getName(), (Writer)this.mNameBuffer);
        }
        this.mVariableTable.put((Object)variable, resultId);
        return resultId;
    }

    private void writeVariableDecl(VariableDecl variableDecl, Writer writer) {
        if (SPIRVCodeGenerator.is_compile_time_constant(variableDecl)) {
            return;
        }
        Variable variable = variableDecl.getVariable();
        int id2 = this.getUniqueId(variable.getType());
        this.mVariableTable.put((Object)variable, id2);
        int ptrTypeId = this.writePointerType(variable.getType(), 7);
        this.writeInstruction(59, ptrTypeId, id2, 7, (Writer)this.mVariableBuffer);
        if (this.mEmitNames) {
            this.writeInstruction(5, id2, variable.getName(), (Writer)this.mNameBuffer);
        }
        if (variableDecl.getInit() != null) {
            int init = this.writeExpression(variableDecl.getInit(), writer);
            this.writeOpStore(7, id2, init, writer);
        }
    }

    private int writeExpression(@Nonnull Expression expr, Writer writer) {
        return switch (expr.getKind()) {
            case Node.ExpressionKind.LITERAL -> this.writeLiteral((Literal)expr);
            case Node.ExpressionKind.PREFIX -> this.writePrefixExpression((PrefixExpression)expr, writer);
            case Node.ExpressionKind.POSTFIX -> this.writePostfixExpression((PostfixExpression)expr, writer);
            case Node.ExpressionKind.BINARY -> this.writeBinaryExpression((BinaryExpression)expr, writer);
            case Node.ExpressionKind.CONDITIONAL -> this.writeConditionalExpression((ConditionalExpression)expr, writer);
            case Node.ExpressionKind.VARIABLE_REFERENCE -> this.writeVariableReference((VariableReference)expr, writer);
            case Node.ExpressionKind.INDEX -> this.writeIndexExpression((IndexExpression)expr, writer);
            case Node.ExpressionKind.FIELD_ACCESS -> this.writeFieldAccess((FieldAccess)expr, writer);
            case Node.ExpressionKind.SWIZZLE -> this.writeSwizzle((Swizzle)expr, writer);
            case Node.ExpressionKind.FUNCTION_CALL -> this.writeFunctionCall((FunctionCall)expr, writer);
            case Node.ExpressionKind.CONSTRUCTOR_COMPOUND -> this.writeConstructorCompound((ConstructorCompound)expr, writer);
            case Node.ExpressionKind.CONSTRUCTOR_VECTOR_SPLAT -> this.writeConstructorVectorSplat((ConstructorVectorSplat)expr, writer);
            case Node.ExpressionKind.CONSTRUCTOR_DIAGONAL_MATRIX -> this.writeConstructorDiagonalMatrix((ConstructorDiagonalMatrix)expr, writer);
            case Node.ExpressionKind.CONSTRUCTOR_SCALAR_CAST -> this.writeConstructorScalarCast((ConstructorScalarCast)expr, writer);
            case Node.ExpressionKind.CONSTRUCTOR_COMPOUND_CAST -> this.writeConstructorCompoundCast((ConstructorCompoundCast)expr, writer);
            case Node.ExpressionKind.CONSTRUCTOR_ARRAY, Node.ExpressionKind.CONSTRUCTOR_STRUCT -> this.writeCompositeConstructor((ConstructorCall)expr, writer);
            case Node.ExpressionKind.CONSTRUCTOR_ARRAY_CAST -> this.writeExpression(((ConstructorArrayCast)expr).getArgument(), writer);
            default -> {
                this.getContext().error(expr.mPosition, "unsupported expression: " + expr.getKind());
                yield -1;
            }
        };
    }

    private int broadcast(@Nonnull Type type, int id2, Writer writer) {
        if (!type.isScalar()) {
            assert (type.isVector());
            int vectorSize = type.getRows();
            IntArrayList values = this.obtainIdList();
            for (int i = 0; i < vectorSize; ++i) {
                values.add(id2);
            }
            id2 = this.writeOpCompositeConstruct(type, values, writer);
            this.releaseIdList(values);
        }
        return id2;
    }

    private int vectorize(double value, Type type, int vectorSize, Writer writer) {
        assert (vectorSize >= 1 && vectorSize <= 4);
        int id2 = this.writeScalarConstant(value, type);
        if (vectorSize > 1) {
            return this.broadcast(type.toVector(this.getContext(), vectorSize), id2, writer);
        }
        return id2;
    }

    private int vectorize(Expression arg, int vectorSize, Writer writer) {
        assert (vectorSize >= 1 && vectorSize <= 4);
        Type argType = arg.getType();
        if (argType.isScalar() && vectorSize > 1) {
            int argId = this.writeExpression(arg, writer);
            return this.broadcast(argType.toVector(this.getContext(), vectorSize), argId, writer);
        }
        assert (vectorSize == argType.getRows());
        return this.writeExpression(arg, writer);
    }

    private void vectorize(Expression[] args, IntArrayList result, Writer writer) {
        int vectorSize = 1;
        for (Expression arg : args) {
            if (!arg.getType().isVector()) continue;
            if (vectorSize > 1) {
                assert (arg.getType().getRows() == vectorSize);
                continue;
            }
            vectorSize = arg.getType().getRows();
        }
        for (Expression arg : args) {
            result.add(this.vectorize(arg, vectorSize, writer));
        }
    }

    private int writePrefixExpression(@Nonnull PrefixExpression expr, Writer writer) {
        Type type = expr.getType();
        return switch (expr.getOperator()) {
            case Operator.ADD -> this.writeExpression(expr.getOperand(), writer);
            case Operator.SUB -> {
                int negateOp = SPIRVCodeGenerator.select_by_component_type(type, 127, 126, 126, 1);
                if (!$assertionsDisabled && negateOp == 1) {
                    throw new AssertionError();
                }
                int id = this.writeExpression(expr.getOperand(), writer);
                if (type.isMatrix()) {
                    yield this.writeUnaryMatrixOperation(type, id, negateOp, writer);
                }
                int resultId = this.getUniqueId(type);
                int typeId = this.writeType(type);
                this.writeInstruction(negateOp, typeId, resultId, id, writer);
                yield resultId;
            }
            case Operator.INC -> {
                LValue lv = this.writeLValue(expr.getOperand(), writer);
                int oneId = this.vectorize(1.0, type.getComponentType(), type.getRows(), writer);
                int resultId = this.writeBinaryOperation(expr.mPosition, type, type, lv.load(this, writer), oneId, true, 129, 128, 128, 1, writer);
                lv.store(this, resultId, writer);
                yield resultId;
            }
            case Operator.DEC -> {
                LValue lv = this.writeLValue(expr.getOperand(), writer);
                int oneId = this.vectorize(1.0, type.getComponentType(), type.getRows(), writer);
                int resultId = this.writeBinaryOperation(expr.mPosition, type, type, lv.load(this, writer), oneId, true, 131, 130, 130, 1, writer);
                lv.store(this, resultId, writer);
                yield resultId;
            }
            case Operator.LOGICAL_NOT -> {
                if (!$assertionsDisabled && !expr.getOperand().getType().isBoolean()) {
                    throw new AssertionError();
                }
                int id = this.writeExpression(expr.getOperand(), writer);
                int resultId = this.getUniqueId();
                int typeId = this.writeType(type);
                this.writeInstruction(168, typeId, resultId, id, writer);
                yield resultId;
            }
            case Operator.BITWISE_NOT -> {
                int id = this.writeExpression(expr.getOperand(), writer);
                int resultId = this.getUniqueId();
                int typeId = this.writeType(type);
                this.writeInstruction(200, typeId, resultId, id, writer);
                yield resultId;
            }
            default -> {
                this.getContext().error(expr.mPosition, "unsupported prefix expression");
                yield -1;
            }
        };
    }

    private int writePostfixExpression(@Nonnull PostfixExpression expr, Writer writer) {
        Type type = expr.getType();
        LValue lv = this.writeLValue(expr.getOperand(), writer);
        int oneId = this.vectorize(1.0, type.getComponentType(), type.getRows(), writer);
        int resultId = lv.load(this, writer);
        return switch (expr.getOperator()) {
            case Operator.INC -> {
                int tmp = this.writeBinaryOperation(expr.mPosition, type, type, resultId, oneId, true, 129, 128, 128, 1, writer);
                lv.store(this, tmp, writer);
                yield resultId;
            }
            case Operator.DEC -> {
                int tmp = this.writeBinaryOperation(expr.mPosition, type, type, resultId, oneId, true, 131, 130, 130, 1, writer);
                lv.store(this, tmp, writer);
                yield resultId;
            }
            default -> {
                this.getContext().error(expr.mPosition, "unsupported postfix expression");
                yield -1;
            }
        };
    }

    private int writeMatrixComparison(Type operandType, int lhs, int rhs, int floatOp, int intOp, int vectorMergeOp, int mergeOp, Writer writer) {
        int compareOp;
        int n2 = compareOp = operandType.isFloatOrCompound() ? floatOp : intOp;
        assert (operandType.isMatrix());
        Type columnType = operandType.getComponentType().toVector(this.getContext(), operandType.getRows());
        Type boolType = this.getContext().getTypes().mBool;
        Type bvecType = boolType.toVector(this.getContext(), operandType.getRows());
        int boolTypeId = this.writeType(boolType);
        int bvecTypeId = this.writeType(bvecType);
        int result = 0;
        for (int i = 0; i < operandType.getCols(); ++i) {
            int columnL = this.writeOpCompositeExtract(columnType, lhs, i, writer);
            int columnR = this.writeOpCompositeExtract(columnType, rhs, i, writer);
            int compare = this.getUniqueId(operandType);
            this.writeInstruction(compareOp, bvecTypeId, compare, columnL, columnR, writer);
            int merge = this.getUniqueId();
            this.writeInstruction(vectorMergeOp, boolTypeId, merge, compare, writer);
            if (result != 0) {
                int next = this.getUniqueId();
                this.writeInstruction(mergeOp, boolTypeId, next, result, merge, writer);
                result = next;
                continue;
            }
            result = merge;
        }
        return result;
    }

    private int writeUnaryMatrixOperation(@Nonnull Type operandType, int operand, int op, Writer writer) {
        assert (operandType.isMatrix());
        Type columnType = operandType.getComponentType().toVector(this.getContext(), operandType.getRows());
        int columnTypeId = this.writeType(columnType);
        IntArrayList columns = this.obtainIdList();
        for (int i = 0; i < operandType.getCols(); ++i) {
            int srcColumn = this.writeOpCompositeExtract(columnType, operand, i, writer);
            int dstColumn = this.getUniqueId(operandType);
            this.writeInstruction(op, columnTypeId, dstColumn, srcColumn, writer);
            columns.add(dstColumn);
        }
        int resultId = this.writeOpCompositeConstruct(operandType, columns, writer);
        this.releaseIdList(columns);
        return resultId;
    }

    private int writeBinaryExpression(@Nonnull BinaryExpression expr, Writer writer) {
        int lhs;
        LValue lvalue;
        Expression left = expr.getLeft();
        Expression right = expr.getRight();
        Operator op = expr.getOperator();
        switch (op) {
            case ASSIGN: {
                int rhs = this.writeExpression(right, writer);
                this.writeLValue(left, writer).store(this, rhs, writer);
                return rhs;
            }
            case LOGICAL_AND: {
                if (this.getContext().getOptions().mNoShortCircuit) break;
                return this.writeLogicalAndSC(left, right, writer);
            }
            case LOGICAL_OR: {
                if (this.getContext().getOptions().mNoShortCircuit) break;
                return this.writeLogicalOrSC(left, right, writer);
            }
        }
        if (op.isAssignment()) {
            lvalue = this.writeLValue(left, writer);
            lhs = lvalue.load(this, writer);
        } else {
            lvalue = null;
            lhs = this.writeExpression(left, writer);
        }
        int rhs = this.writeExpression(right, writer);
        int result = this.writeBinaryExpression(expr.mPosition, left.getType(), lhs, op.removeAssignment(), right.getType(), rhs, expr.getType(), writer);
        if (lvalue != null) {
            lvalue.store(this, result, writer);
        }
        return result;
    }

    private int writeLogicalAndSC(@Nonnull Expression left, @Nonnull Expression right, Writer writer) {
        int falseConstant = this.writeScalarConstant(0.0, this.getContext().getTypes().mBool);
        int lhs = this.writeExpression(left, writer);
        int numReachableOps = this.mReachableOps.size();
        int numStoreOps = this.mStoreOps.size();
        int rhsLabel = this.getUniqueId();
        int end = this.getUniqueId();
        int lhsBlock = this.mCurrentBlock;
        this.writeInstruction(247, end, 0, writer);
        this.writeInstruction(250, lhs, rhsLabel, end, writer);
        this.writeLabel(rhsLabel, writer);
        int rhs = this.writeExpression(right, writer);
        int rhsBlock = this.mCurrentBlock;
        this.writeInstruction(249, end, writer);
        this.writeLabel(end, 0, numReachableOps, numStoreOps, writer);
        int result = this.getUniqueId();
        int typeId = this.writeType(this.getContext().getTypes().mBool);
        this.writeInstruction(245, typeId, result, falseConstant, lhsBlock, rhs, rhsBlock, writer);
        return result;
    }

    private int writeLogicalOrSC(@Nonnull Expression left, @Nonnull Expression right, Writer writer) {
        int trueConstant = this.writeScalarConstant(1.0, this.getContext().getTypes().mBool);
        int lhs = this.writeExpression(left, writer);
        int numReachableOps = this.mReachableOps.size();
        int numStoreOps = this.mStoreOps.size();
        int rhsLabel = this.getUniqueId();
        int end = this.getUniqueId();
        int lhsBlock = this.mCurrentBlock;
        this.writeInstruction(247, end, 0, writer);
        this.writeInstruction(250, lhs, end, rhsLabel, writer);
        this.writeLabel(rhsLabel, writer);
        int rhs = this.writeExpression(right, writer);
        int rhsBlock = this.mCurrentBlock;
        this.writeInstruction(249, end, writer);
        this.writeLabel(end, 0, numReachableOps, numStoreOps, writer);
        int result = this.getUniqueId();
        int typeId = this.writeType(this.getContext().getTypes().mBool);
        this.writeInstruction(245, typeId, result, trueConstant, lhsBlock, rhs, rhsBlock, writer);
        return result;
    }

    private int writeBinaryExpression(int pos, Type leftType, int lhs, Operator op, Type rightType, int rhs, Type resultType, Writer writer) {
        Type operandType;
        if (op == Operator.COMMA) {
            return rhs;
        }
        if (leftType.matches(rightType)) {
            operandType = leftType;
        } else {
            Type leftComponentType = leftType.getComponentType();
            Type rightComponentType = rightType.getComponentType();
            if (leftType.getTypeKind() == rightType.getTypeKind() && (leftType.isScalar() || leftType.isVector() || leftType.isMatrix()) && leftType.getCols() == rightType.getCols() && leftType.getRows() == rightType.getRows() && leftComponentType.getScalarKind() == rightComponentType.getScalarKind() && leftComponentType.getWidth() == rightComponentType.getWidth()) {
                operandType = leftType;
            } else if (leftType.isVector() && rightType.isNumeric()) {
                if (resultType.getComponentType().isFloat() && op == Operator.MUL) {
                    int resultId = this.getUniqueId(resultType);
                    int typeId = this.writeType(resultType);
                    this.writeInstruction(142, typeId, resultId, lhs, rhs, writer);
                    return resultId;
                }
                rhs = this.broadcast(leftType, rhs, writer);
                operandType = leftType;
            } else if (leftType.isNumeric() && rightType.isVector()) {
                if (resultType.getComponentType().isFloat() && op == Operator.MUL) {
                    int resultId = this.getUniqueId(resultType);
                    int typeId = this.writeType(resultType);
                    this.writeInstruction(142, typeId, resultId, rhs, lhs, writer);
                    return resultId;
                }
                lhs = this.broadcast(rightType, lhs, writer);
                operandType = rightType;
            } else {
                if (leftType.isMatrix() || rightType.isMatrix()) {
                    if (op == Operator.MUL) {
                        int spvOp;
                        if (leftType.isMatrix() && rightType.isVector()) {
                            spvOp = 145;
                        } else if (leftType.isVector() && rightType.isMatrix()) {
                            spvOp = 144;
                        } else if (leftType.isScalar() || rightType.isScalar()) {
                            spvOp = 143;
                        } else {
                            this.getContext().error(pos, "unsupported mixed-type expression");
                            return -1;
                        }
                        int resultId = this.getUniqueId(resultType);
                        int typeId = this.writeType(resultType);
                        if (leftType.isScalar()) {
                            this.writeInstruction(spvOp, typeId, resultId, rhs, lhs, writer);
                        } else {
                            this.writeInstruction(spvOp, typeId, resultId, lhs, rhs, writer);
                        }
                        return resultId;
                    }
                    assert (leftType.isMatrix() && rightType.isScalar() || rightType.isMatrix() && leftType.isScalar());
                    return switch (op) {
                        case Operator.ADD -> this.writeBinaryMatrixOperation(pos, resultType, leftType, rightType, lhs, rhs, 129, 128, 128, writer);
                        case Operator.SUB -> this.writeBinaryMatrixOperation(pos, resultType, leftType, rightType, lhs, rhs, 131, 130, 130, writer);
                        case Operator.DIV -> this.writeBinaryMatrixOperation(pos, resultType, leftType, rightType, lhs, rhs, 136, 135, 134, writer);
                        default -> {
                            this.getContext().error(pos, "unsupported mixed-type expression");
                            yield -1;
                        }
                    };
                }
                this.getContext().error(pos, "unsupported mixed-type expression");
                return -1;
            }
        }
        switch (op) {
            case EQ: {
                if (operandType.isMatrix()) {
                    return this.writeMatrixComparison(operandType, lhs, rhs, 180, 170, 155, 167, writer);
                }
                if (operandType.isArray()) {
                    return this.writeArrayComparison(operandType, lhs, op, rhs, writer);
                }
                assert (resultType.isBoolean());
                Type tmpType = operandType.isVector() ? resultType.toVector(this.getContext(), operandType.getRows()) : resultType;
                int id2 = this.writeBinaryOperation(pos, tmpType, operandType, lhs, rhs, false, 180, 170, 170, 164, writer);
                if (operandType.isVector()) {
                    int resultId = this.getUniqueId();
                    int typeId = this.writeType(resultType);
                    this.writeInstruction(155, typeId, resultId, id2, writer);
                    return resultId;
                }
                return id2;
            }
            case NE: {
                if (operandType.isMatrix()) {
                    return this.writeMatrixComparison(operandType, lhs, rhs, 183, 171, 154, 166, writer);
                }
                if (operandType.isArray()) {
                    return this.writeArrayComparison(operandType, lhs, op, rhs, writer);
                }
            }
            case LOGICAL_XOR: {
                assert (resultType.isBoolean());
                Type tmpType = operandType.isVector() ? resultType.toVector(this.getContext(), operandType.getRows()) : resultType;
                int id3 = this.writeBinaryOperation(pos, tmpType, operandType, lhs, rhs, false, 183, 171, 171, 165, writer);
                if (operandType.isVector()) {
                    int resultId = this.getUniqueId();
                    int typeId = this.writeType(resultType);
                    this.writeInstruction(154, typeId, resultId, id3, writer);
                    return resultId;
                }
                return id3;
            }
            case LOGICAL_AND: {
                assert (resultType.isBoolean());
                return this.writeBinaryOperation(pos, resultType, operandType, lhs, rhs, false, 1, 1, 1, 167, writer);
            }
            case LOGICAL_OR: {
                assert (resultType.isBoolean());
                return this.writeBinaryOperation(pos, resultType, operandType, lhs, rhs, false, 1, 1, 1, 166, writer);
            }
            case LT: {
                assert (resultType.isBoolean());
                return this.writeBinaryOperation(pos, resultType, operandType, lhs, rhs, false, 184, 177, 176, 1, writer);
            }
            case GT: {
                assert (resultType.isBoolean());
                return this.writeBinaryOperation(pos, resultType, operandType, lhs, rhs, false, 186, 173, 172, 1, writer);
            }
            case LE: {
                assert (resultType.isBoolean());
                return this.writeBinaryOperation(pos, resultType, operandType, lhs, rhs, false, 188, 179, 178, 1, writer);
            }
            case GE: {
                assert (resultType.isBoolean());
                return this.writeBinaryOperation(pos, resultType, operandType, lhs, rhs, false, 190, 175, 174, 1, writer);
            }
            case ADD: {
                return this.writeBinaryOperation(pos, resultType, operandType, lhs, rhs, true, 129, 128, 128, 1, writer);
            }
            case SUB: {
                return this.writeBinaryOperation(pos, resultType, operandType, lhs, rhs, true, 131, 130, 130, 1, writer);
            }
            case MUL: {
                if (leftType.isMatrix() && rightType.isMatrix()) {
                    int resultId = this.getUniqueId(resultType);
                    int typeId = this.writeType(resultType);
                    this.writeInstruction(146, typeId, resultId, lhs, rhs, writer);
                    return resultId;
                }
                return this.writeBinaryOperation(pos, resultType, operandType, lhs, rhs, false, 133, 132, 132, 1, writer);
            }
            case DIV: {
                return this.writeBinaryOperation(pos, resultType, operandType, lhs, rhs, true, 136, 135, 134, 1, writer);
            }
            case MOD: {
                return this.writeBinaryOperation(pos, resultType, operandType, lhs, rhs, false, 141, 139, 137, 1, writer);
            }
            case SHL: {
                return this.writeBinaryOperation(pos, resultType, operandType, lhs, rhs, false, 1, 196, 196, 1, writer);
            }
            case SHR: {
                return this.writeBinaryOperation(pos, resultType, operandType, lhs, rhs, false, 1, 195, 194, 1, writer);
            }
            case BITWISE_XOR: {
                return this.writeBinaryOperation(pos, resultType, operandType, lhs, rhs, false, 1, 198, 198, 1, writer);
            }
            case BITWISE_AND: {
                return this.writeBinaryOperation(pos, resultType, operandType, lhs, rhs, false, 1, 199, 199, 1, writer);
            }
            case BITWISE_OR: {
                return this.writeBinaryOperation(pos, resultType, operandType, lhs, rhs, false, 1, 197, 197, 1, writer);
            }
        }
        this.getContext().error(pos, "unsupported expression");
        return -1;
    }

    private int writeBinaryMatrixOperation(@Nonnull Type resultType, @Nonnull Type leftType, @Nonnull Type rightType, int lhs, int rhs, int op, Writer writer) {
        assert (resultType.isMatrix());
        boolean leftMat = leftType.isMatrix();
        boolean rightMat = rightType.isMatrix();
        assert (leftMat || rightMat);
        Type columnType = resultType.getComponentType().toVector(this.getContext(), resultType.getRows());
        int columnTypeId = this.writeType(columnType);
        if (leftType.isScalar()) {
            lhs = this.broadcast(columnType, lhs, writer);
        }
        if (rightType.isScalar()) {
            rhs = this.broadcast(columnType, rhs, writer);
        }
        IntArrayList columns = this.obtainIdList();
        for (int i = 0; i < resultType.getCols(); ++i) {
            int leftColumn = leftMat ? this.writeOpCompositeExtract(columnType, lhs, i, writer) : lhs;
            int rightColumn = rightMat ? this.writeOpCompositeExtract(columnType, rhs, i, writer) : rhs;
            int resultId = this.getUniqueId(resultType);
            this.writeInstruction(op, columnTypeId, resultId, leftColumn, rightColumn, writer);
            columns.add(resultId);
        }
        int resultId = this.writeOpCompositeConstruct(resultType, columns, writer);
        this.releaseIdList(columns);
        return resultId;
    }

    private int writeBinaryMatrixOperation(int pos, Type resultType, Type leftType, Type rightType, int lhs, int rhs, int floatOp, int signedOp, int unsignedOp, Writer writer) {
        int op = SPIRVCodeGenerator.select_by_component_type(resultType, floatOp, signedOp, unsignedOp, 1);
        if (op == 1) {
            this.getContext().error(pos, "unsupported operation for binary expression");
            return -1;
        }
        return this.writeBinaryMatrixOperation(resultType, leftType, rightType, lhs, rhs, op, writer);
    }

    private int writeBinaryOperation(int pos, Type resultType, Type operandType, int lhs, int rhs, boolean matrixOpIsComponentWise, int floatOp, int signedOp, int unsignedOp, int booleanOp, Writer writer) {
        int op = SPIRVCodeGenerator.select_by_component_type(operandType, floatOp, signedOp, unsignedOp, booleanOp);
        if (op == 1) {
            this.getContext().error(pos, "unsupported operand type for binary expression: " + operandType);
            return -1;
        }
        if (matrixOpIsComponentWise && operandType.isMatrix()) {
            return this.writeBinaryMatrixOperation(resultType, operandType, operandType, lhs, rhs, op, writer);
        }
        int resultId = this.getUniqueId(resultType);
        int typeId = this.writeType(resultType);
        this.writeInstruction(op, typeId, resultId, lhs, rhs, writer);
        return resultId;
    }

    private int writeArrayComparison(Type arrayType, int lhs, Operator op, int rhs, Writer writer) {
        assert (op == Operator.EQ || op == Operator.NE);
        assert (arrayType.isArray());
        Type elementType = arrayType.getElementType();
        int arraySize = arrayType.getArraySize();
        assert (arraySize > 0);
        Type boolType = this.getContext().getTypes().mBool;
        int result = 0;
        for (int index = 0; index < arraySize; ++index) {
            int itemL = this.writeOpCompositeExtract(elementType, lhs, index, writer);
            int itemR = this.writeOpCompositeExtract(elementType, rhs, index, writer);
            int comparison = this.writeBinaryExpression(-1, elementType, itemL, op, elementType, itemR, boolType, writer);
            result = this.mergeComparisons(comparison, result, op, writer);
        }
        return result;
    }

    private int mergeComparisons(int comparison, int result, Operator op, Writer writer) {
        if (result == 0) {
            return comparison;
        }
        Type boolType = this.getContext().getTypes().mBool;
        int boolTypeId = this.writeType(boolType);
        int next = this.getUniqueId();
        switch (op) {
            case EQ: {
                this.writeInstruction(167, boolTypeId, next, comparison, result, writer);
                break;
            }
            case NE: {
                this.writeInstruction(166, boolTypeId, next, comparison, result, writer);
                break;
            }
            default: {
                assert (false) : "mergeComparisons only supports == and !=, not " + op;
                return -1;
            }
        }
        return next;
    }

    private int writeConditionalExpression(ConditionalExpression expr, Writer writer) {
        Type type = expr.getType();
        int cond = this.writeExpression(expr.getCondition(), writer);
        int trueId = this.writeExpression(expr.getWhenTrue(), writer);
        int falseId = this.writeExpression(expr.getWhenFalse(), writer);
        int resultId = this.getUniqueId();
        int typeId = this.writeType(type);
        if ((type.isScalar() || type.isVector()) && (this.getContext().getOptions().mNoShortCircuit || Analysis.isTrivialExpression(expr.getWhenTrue()) && Analysis.isTrivialExpression(expr.getWhenFalse()))) {
            if (this.mOutputVersion.isBefore(SPIRVVersion.SPIRV_1_4) && type.isVector()) {
                Type condType = expr.getCondition().getType();
                assert (condType.isBoolean());
                cond = this.broadcast(condType.toVector(this.getContext(), type.getRows()), cond, writer);
            }
            this.writeInstruction(169, typeId, resultId, cond, trueId, falseId, writer);
            return resultId;
        }
        int numReachableOps = this.mReachableOps.size();
        int numStoreOps = this.mStoreOps.size();
        int variable = this.getUniqueId();
        int ptrTypeId = this.writePointerType(type, 7);
        this.writeInstruction(59, ptrTypeId, variable, 7, (Writer)this.mVariableBuffer);
        int trueLabel = this.getUniqueId();
        int falseLabel = this.getUniqueId();
        int end = this.getUniqueId();
        this.writeInstruction(247, end, 0, writer);
        this.writeInstruction(250, cond, trueLabel, falseLabel, writer);
        this.writeLabel(trueLabel, writer);
        this.writeOpStore(7, variable, trueId, writer);
        this.writeInstruction(249, end, writer);
        this.writeLabel(falseLabel, 0, numReachableOps, numStoreOps, writer);
        this.writeOpStore(7, variable, falseId, writer);
        this.writeInstruction(249, end, writer);
        this.writeLabel(end, 0, numReachableOps, numStoreOps, writer);
        this.writeInstruction(61, typeId, resultId, variable, writer);
        return resultId;
    }

    private int writeVariableReference(VariableReference ref, Writer writer) {
        Expression constExpr = ConstantFolder.getConstantValueOrNullForVariable(ref);
        if (constExpr != null) {
            return this.writeExpression(constExpr, writer);
        }
        return this.writeLValue(ref, writer).load(this, writer);
    }

    private int writeIndexExpression(IndexExpression expr, Writer writer) {
        if (expr.getBase().getType().isVector()) {
            int base = this.writeExpression(expr.getBase(), writer);
            int index = this.writeExpression(expr.getIndex(), writer);
            int resultId = this.getUniqueId();
            int typeId = this.writeType(expr.getType());
            this.writeInstruction(77, typeId, resultId, base, index, writer);
            return resultId;
        }
        return this.writeLValue(expr, writer).load(this, writer);
    }

    private int writeFieldAccess(FieldAccess f2, Writer writer) {
        return this.writeLValue(f2, writer).load(this, writer);
    }

    private int writeRValueSwizzle(Expression baseExpr, byte[] components, Writer writer) {
        int count = components.length;
        assert (count >= 1 && count <= 4);
        Type type = baseExpr.getType().getComponentType().toVector(this.getContext(), count);
        int baseId = this.writeExpression(baseExpr, writer);
        if (count == 1) {
            return this.writeOpCompositeExtract(type, baseId, components[0], writer);
        }
        int resultId = this.getUniqueId(type);
        int typeId = this.writeType(type);
        this.writeOpcode(79, 5 + count, writer);
        writer.writeWord(typeId);
        writer.writeWord(resultId);
        writer.writeWord(baseId);
        writer.writeWord(baseId);
        for (byte component : components) {
            writer.writeWord(component);
        }
        return resultId;
    }

    private int writeSwizzle(Swizzle swizzle, Writer writer) {
        return this.writeRValueSwizzle(swizzle.getBase(), swizzle.getComponents(), writer);
    }

    private void pruneConditionalOps(int numReachableOps, int numStoreOps) {
        int id2;
        while (this.mReachableOps.size() > numReachableOps) {
            id2 = this.mReachableOps.popInt();
            Instruction inst = (Instruction)this.mSpvIdCache.remove(id2);
            if (inst != null) {
                this.mOpCache.removeInt((Object)inst);
                continue;
            }
            throw new AssertionError((Object)"reachable-op list contains unrecognized SpvId");
        }
        while (this.mStoreOps.size() > numStoreOps) {
            id2 = this.mStoreOps.popInt();
            this.mStoreCache.remove(id2);
        }
    }

    private void writeStatement(@Nonnull Statement stmt, Writer writer) {
        switch (stmt.getKind()) {
            case BLOCK: {
                this.writeBlockStatement((BlockStatement)stmt, writer);
                break;
            }
            case RETURN: {
                this.writeReturnStatement((ReturnStatement)stmt, writer);
                break;
            }
            case IF: {
                this.writeIfStatement((IfStatement)stmt, writer);
                break;
            }
            case FOR_LOOP: {
                this.writeForLoop((ForLoop)stmt, writer);
                break;
            }
            case SWITCH: {
                this.writeSwitchStatement((SwitchStatement)stmt, writer);
                break;
            }
            case VARIABLE_DECL: {
                this.writeVariableDecl((VariableDecl)stmt, writer);
                break;
            }
            case EXPRESSION: {
                this.writeExpression(((ExpressionStatement)stmt).getExpression(), writer);
                break;
            }
            case BREAK: {
                this.writeInstruction(249, this.mBreakTarget.topInt(), writer);
                break;
            }
            case CONTINUE: {
                this.writeInstruction(249, this.mContinueTarget.topInt(), writer);
                break;
            }
            case DISCARD: {
                if (this.mOutputVersion.isAtLeast(SPIRVVersion.SPIRV_1_6)) {
                    this.writeInstruction(4416, writer);
                    break;
                }
                this.writeInstruction(252, writer);
                break;
            }
            default: {
                this.getContext().error(stmt.mPosition, "unsupported statement: " + stmt.getKind());
            }
        }
    }

    private static int select_by_component_type(@Nonnull Type type, int whenFloat, int whenSigned, int whenUnsigned, int whenBoolean) {
        if (type.isFloatOrCompound()) {
            return whenFloat;
        }
        if (type.isSignedOrCompound()) {
            return whenSigned;
        }
        if (type.isUnsignedOrCompound()) {
            return whenUnsigned;
        }
        if (type.isBooleanOrCompound()) {
            return whenBoolean;
        }
        throw new AssertionError(type);
    }

    private void writeBlockStatement(BlockStatement b, Writer writer) {
        for (Statement stmt : b.getStatements()) {
            this.writeStatement(stmt, writer);
        }
    }

    private void writeReturnStatement(ReturnStatement r, Writer writer) {
        if (r.getExpression() != null) {
            int expr = this.writeExpression(r.getExpression(), writer);
            this.writeInstruction(254, expr, writer);
        } else {
            this.writeInstruction(253, writer);
        }
    }

    private void writeIfStatement(IfStatement stmt, Writer writer) {
        int cond = this.writeExpression(stmt.getCondition(), writer);
        int trueId = this.getUniqueId();
        int falseId = this.getUniqueId();
        int numReachableOps = this.mReachableOps.size();
        int numStoreOps = this.mStoreOps.size();
        if (stmt.getWhenFalse() != null) {
            int end = this.getUniqueId();
            this.writeInstruction(247, end, 0, writer);
            this.writeInstruction(250, cond, trueId, falseId, writer);
            this.writeLabel(trueId, writer);
            this.writeStatement(stmt.getWhenTrue(), writer);
            if (this.mCurrentBlock != 0) {
                this.writeInstruction(249, end, writer);
            }
            this.writeLabel(falseId, 0, numReachableOps, numStoreOps, writer);
            this.writeStatement(stmt.getWhenFalse(), writer);
            if (this.mCurrentBlock != 0) {
                this.writeInstruction(249, end, writer);
            }
            this.writeLabel(end, 0, numReachableOps, numStoreOps, writer);
        } else {
            this.writeInstruction(247, falseId, 0, writer);
            this.writeInstruction(250, cond, trueId, falseId, writer);
            this.writeLabel(trueId, writer);
            this.writeStatement(stmt.getWhenTrue(), writer);
            if (this.mCurrentBlock != 0) {
                this.writeInstruction(249, falseId, writer);
            }
            this.writeLabel(falseId, 0, numReachableOps, numStoreOps, writer);
        }
    }

    private void writeForLoop(ForLoop f2, Writer writer) {
        if (f2.getInit() != null) {
            this.writeStatement(f2.getInit(), writer);
        }
        int numReachableOps = this.mReachableOps.size();
        int numStoreOps = this.mStoreOps.size();
        int header = this.getUniqueId();
        int start = this.getUniqueId();
        int body = this.getUniqueId();
        int next = this.getUniqueId();
        this.mContinueTarget.push(next);
        int end = this.getUniqueId();
        this.mBreakTarget.push(end);
        this.writeInstruction(249, header, writer);
        this.writeLabel(header, 1, numReachableOps, numStoreOps, writer);
        this.writeInstruction(246, end, next, 0, writer);
        this.writeInstruction(249, start, writer);
        this.writeLabel(start, writer);
        if (f2.getCondition() != null) {
            int cond = this.writeExpression(f2.getCondition(), writer);
            this.writeInstruction(250, cond, body, end, writer);
        } else {
            this.writeInstruction(249, body, writer);
        }
        this.writeLabel(body, writer);
        this.writeStatement(f2.getStatement(), writer);
        if (this.mCurrentBlock != 0) {
            this.writeInstruction(249, next, writer);
        }
        this.writeLabel(next, 0, numReachableOps, numStoreOps, writer);
        if (f2.getStep() != null) {
            this.writeExpression(f2.getStep(), writer);
        }
        this.writeInstruction(249, header, writer);
        this.writeLabel(end, 0, numReachableOps, numStoreOps, writer);
        this.mBreakTarget.popInt();
        this.mContinueTarget.popInt();
    }

    private void writeSwitchStatement(SwitchStatement s, Writer writer) {
        int i;
        SwitchCase sc;
        int end;
        int init = this.writeExpression(s.getInit(), writer);
        int numReachableOps = this.mReachableOps.size();
        int numStoreOps = this.mStoreOps.size();
        IntArrayList labels = this.obtainIdList();
        int defaultLabel = end = this.getUniqueId();
        this.mBreakTarget.push(end);
        int size = 3;
        List<Statement> cases = s.getCases();
        for (Statement stmt : cases) {
            sc = (SwitchCase)stmt;
            int label = this.getUniqueId();
            labels.add(label);
            if (!sc.isDefault()) {
                size += 2;
                continue;
            }
            defaultLabel = label;
        }
        assert (labels.size() == cases.size());
        BitSet caseIsCollapsed = new BitSet(cases.size());
        for (int index = cases.size() - 2; index >= 0; --index) {
            sc = (SwitchCase)cases.get(index);
            if (!sc.getStatement().isEmpty()) continue;
            caseIsCollapsed.set(index);
            labels.set(index, labels.getInt(index + 1));
        }
        labels.add(end);
        this.writeInstruction(247, end, 0, writer);
        this.writeOpcode(251, size, writer);
        writer.writeWord(init);
        writer.writeWord(defaultLabel);
        for (i = 0; i < cases.size(); ++i) {
            sc = (SwitchCase)cases.get(i);
            if (sc.isDefault()) continue;
            writer.writeWord((int)sc.getValue());
            writer.writeWord(labels.getInt(i));
        }
        for (i = 0; i < cases.size(); ++i) {
            if (caseIsCollapsed.get(i)) continue;
            sc = (SwitchCase)cases.get(i);
            if (i == 0) {
                this.writeLabel(labels.getInt(i), writer);
            } else {
                this.writeLabel(labels.getInt(i), 0, numReachableOps, numStoreOps, writer);
            }
            this.writeStatement(sc.getStatement(), writer);
            if (this.mCurrentBlock == 0) continue;
            this.writeInstruction(249, labels.getInt(i + 1), writer);
        }
        this.writeLabel(end, 0, numReachableOps, numStoreOps, writer);
        this.mBreakTarget.popInt();
    }

    private void writeLabel(int label, Writer writer) {
        assert (this.mCurrentBlock == 0);
        this.mCurrentBlock = label;
        this.writeInstruction(248, label, writer);
    }

    private void writeLabel(int label, int type, int numReachableOps, int numStoreOps, Writer writer) {
        switch (type) {
            case 1: 
            case 2: {
                this.mStoreCache.clear();
            }
            case 0: {
                this.pruneConditionalOps(numReachableOps, numStoreOps);
            }
        }
        this.writeLabel(label, writer);
    }

    private void writeAccessChain(@Nonnull Expression expr, Writer writer, IntList chain) {
        switch (expr.getKind()) {
            case INDEX: {
                IndexExpression indexExpr = (IndexExpression)expr;
                if (indexExpr.getBase() instanceof Swizzle) {
                    this.getContext().error(indexExpr.mPosition, "indexing on swizzle is not allowed");
                }
                this.writeAccessChain(indexExpr.getBase(), writer, chain);
                int id2 = this.writeExpression(indexExpr.getIndex(), writer);
                chain.add(id2);
                break;
            }
            case FIELD_ACCESS: {
                FieldAccess fieldAccess = (FieldAccess)expr;
                this.writeAccessChain(fieldAccess.getBase(), writer, chain);
                int id3 = this.writeScalarConstant(fieldAccess.getFieldIndex(), this.getContext().getTypes().mInt);
                chain.add(id3);
                break;
            }
            default: {
                int id4 = this.writeLValue(expr, writer).getPointer();
                assert (id4 != -1);
                chain.add(id4);
            }
        }
    }

    @Nonnull
    private LValue writeLValue(@Nonnull Expression expr, Writer writer) {
        Type type = expr.getType();
        boolean relaxedPrecision = type.isRelaxedPrecision();
        switch (expr.getKind()) {
            case INDEX: 
            case FIELD_ACCESS: {
                IntArrayList chain = this.mAccessChain;
                chain.clear();
                this.writeAccessChain(expr, writer, (IntList)chain);
                int member = this.getUniqueId();
                int storageClass = this.getStorageClass(expr);
                this.writeOpcode(65, 3 + chain.size(), writer);
                writer.writeWord(this.writePointerType(type, storageClass));
                writer.writeWord(member);
                writer.writeWords(chain.elements(), chain.size());
                int typeId = this.writeType(type, null, null);
                return new PointerLValue(member, false, typeId, relaxedPrecision, storageClass);
            }
            case VARIABLE_REFERENCE: {
                Variable variable = ((VariableReference)expr).getVariable();
                int entry = this.mVariableTable.getInt((Object)variable);
                assert (entry != 0) : variable;
                int typeId = this.writeType(type, variable.getModifiers(), null);
                return new PointerLValue(entry, true, typeId, relaxedPrecision, this.getStorageClass(expr));
            }
            case SWIZZLE: {
                Swizzle swizzle = (Swizzle)expr;
                LValue lvalue = this.writeLValue(swizzle.getBase(), writer);
                if (lvalue.applySwizzle(swizzle.getComponents(), type)) {
                    return lvalue;
                }
                int base = lvalue.getPointer();
                if (base == -1) {
                    this.getContext().error(swizzle.mPosition, "unable to retrieve lvalue from swizzle");
                }
                int storageClass = this.getStorageClass(swizzle.getBase());
                if (swizzle.getComponents().length == 1) {
                    int member = this.getUniqueId();
                    int typeId = this.writePointerType(type, storageClass);
                    int indexId = this.writeScalarConstant(swizzle.getComponents()[0], this.getContext().getTypes().mInt);
                    this.writeInstruction(65, typeId, member, base, indexId, writer);
                    return new PointerLValue(member, false, this.writeType(type), relaxedPrecision, storageClass);
                }
                return new SwizzleLValue(base, swizzle.getComponents(), swizzle.getBase().getType(), type, storageClass);
            }
        }
        assert (false) : expr;
        throw new UnsupportedOperationException();
    }

    private void writeFunctionCallArgument(IntArrayList argList, FunctionCall call, int argIndex, ArrayList<OutVar> tmpOutVars, Writer writer) {
        int tmpVar;
        FunctionDecl funcDecl = call.getFunction();
        Expression arg = call.getArguments()[argIndex];
        Variable param = funcDecl.getParameters().get(argIndex);
        Modifiers paramModifiers = param.getModifiers();
        if (arg instanceof VariableReference && arg.getType().isOpaque()) {
            Variable variable = ((VariableReference)arg).getVariable();
            int entry = this.mVariableTable.getInt((Object)variable);
            assert (entry != 0);
            argList.add(entry);
            return;
        }
        int tmpValueId = -1;
        if ((paramModifiers.flags() & 0x40) != 0) {
            LValue lValue = this.writeLValue(arg, writer);
            if ((paramModifiers.flags() & 0x20) != 0) {
                tmpValueId = lValue.load(this, writer);
            }
            tmpVar = this.getUniqueId(arg.getType());
            tmpOutVars.add(new OutVar(tmpVar, arg.getType(), lValue));
        } else {
            if (funcDecl.isIntrinsic()) {
                tmpValueId = this.writeExpression(arg, writer);
                argList.add(tmpValueId);
                return;
            }
            tmpValueId = this.writeExpression(arg, writer);
            tmpVar = this.getUniqueId();
        }
        int ptrTypeId = this.writePointerType(arg.getType(), 7);
        this.writeInstruction(59, ptrTypeId, tmpVar, 7, (Writer)this.mVariableBuffer);
        if (tmpValueId != -1) {
            this.writeOpStore(7, tmpVar, tmpValueId, writer);
        }
        argList.add(tmpVar);
    }

    private void copyBackOutArguments(ArrayList<OutVar> tmpOutVars, Writer writer) {
        for (OutVar outVar : tmpOutVars) {
            int loadId = this.getUniqueId(outVar.mType);
            int typeId = this.writeType(outVar.mType);
            this.writeInstruction(61, typeId, loadId, outVar.mId, writer);
            outVar.mLValue.store(this, loadId, writer);
        }
    }

    private void writeGLSLExtendedInstruction(Type type, int id2, int floatInst, int signedInst, int unsignedInst, IntArrayList args, Writer writer) {
        this.writeOpcode(12, 5 + args.size(), writer);
        int typeId = this.writeType(type);
        writer.writeWord(typeId);
        writer.writeWord(id2);
        writer.writeWord(this.mGLSLExtendedInstructions);
        writer.writeWord(SPIRVCodeGenerator.select_by_component_type(type, floatInst, signedInst, unsignedInst, 0));
        writer.writeWords(args.elements(), args.size());
    }

    private int writeSpecialIntrinsic(FunctionCall call, int kind, Writer writer) {
        Expression[] arguments = call.getArguments();
        IntArrayList argumentIds = this.obtainIdList();
        int resultId = this.getUniqueId();
        Type callType = call.getType();
        switch (kind) {
            case 0: {
                for (Expression arg : arguments) {
                    argumentIds.add(this.writeExpression(arg, writer));
                }
                if (argumentIds.size() == 2) {
                    this.writeGLSLExtendedInstruction(callType, resultId, 25, 0, 0, argumentIds, writer);
                    break;
                }
                assert (argumentIds.size() == 1);
                this.writeGLSLExtendedInstruction(callType, resultId, 18, 0, 0, argumentIds, writer);
                break;
            }
            case 6: {
                this.vectorize(arguments, argumentIds, writer);
                assert (argumentIds.size() == 2);
                Type operandType = arguments[0].getType();
                int op = SPIRVCodeGenerator.select_by_component_type(operandType, 141, 139, 137, 1);
                assert (op != 1);
                int typeId = this.writeType(operandType);
                this.writeInstruction(op, typeId, resultId, argumentIds.getInt(0), argumentIds.getInt(1), writer);
                break;
            }
            case 4: {
                this.vectorize(arguments, argumentIds, writer);
                assert (argumentIds.size() == 2);
                this.writeGLSLExtendedInstruction(callType, resultId, 37, 39, 38, argumentIds, writer);
                break;
            }
            case 3: {
                this.vectorize(arguments, argumentIds, writer);
                assert (argumentIds.size() == 2);
                this.writeGLSLExtendedInstruction(callType, resultId, 40, 42, 41, argumentIds, writer);
                break;
            }
            case 1: {
                this.vectorize(arguments, argumentIds, writer);
                assert (argumentIds.size() == 3);
                this.writeGLSLExtendedInstruction(callType, resultId, 43, 45, 44, argumentIds, writer);
                break;
            }
            case 7: {
                assert (arguments.length == 1);
                int vectorSize = arguments[0].getType().getRows();
                argumentIds.add(this.vectorize(arguments[0], vectorSize, writer));
                argumentIds.add(this.vectorize(0.0, this.getContext().getTypes().mFloat, vectorSize, writer));
                argumentIds.add(this.vectorize(1.0, this.getContext().getTypes().mFloat, vectorSize, writer));
                this.writeGLSLExtendedInstruction(callType, resultId, 43, 45, 44, argumentIds, writer);
                break;
            }
            case 5: {
                this.vectorize(arguments, argumentIds, writer);
                assert (argumentIds.size() == 3);
                if (arguments[2].getType().isBooleanOrCompound()) {
                    int typeId = this.writeType(arguments[0].getType());
                    this.writeInstruction(169, typeId, resultId, argumentIds.getInt(2), argumentIds.getInt(1), argumentIds.getInt(0), writer);
                    break;
                }
                this.writeGLSLExtendedInstruction(callType, resultId, 46, 1, 1, argumentIds, writer);
                break;
            }
            case 10: {
                this.vectorize(arguments, argumentIds, writer);
                assert (argumentIds.size() == 2);
                this.writeGLSLExtendedInstruction(callType, resultId, 48, 1, 1, argumentIds, writer);
                break;
            }
            case 9: {
                this.vectorize(arguments, argumentIds, writer);
                assert (argumentIds.size() == 3);
                this.writeGLSLExtendedInstruction(callType, resultId, 49, 0, 0, argumentIds, writer);
                break;
            }
            case 12: {
                for (Expression arg : arguments) {
                    argumentIds.add(this.writeExpression(arg, writer));
                }
                int typeId = this.writeType(callType);
                if (argumentIds.size() == 3) {
                    this.writeInstruction(87, typeId, resultId, argumentIds.getInt(0), argumentIds.getInt(1), 1, argumentIds.getInt(2), writer);
                    break;
                }
                assert (argumentIds.size() == 2);
                this.writeInstruction(87, typeId, resultId, argumentIds.getInt(0), argumentIds.getInt(1), writer);
                break;
            }
            case 15: {
                for (Expression arg : arguments) {
                    argumentIds.add(this.writeExpression(arg, writer));
                }
                assert (argumentIds.size() == 3);
                if (arguments[0].getType().isCombinedSampler()) {
                    int samplerId = argumentIds.getInt(0);
                    int imageId = this.getUniqueId();
                    int samplerTypeId = this.writeType(arguments[0].getType());
                    int imageTypeId = ((Instruction)this.mSpvIdCache.get((int)samplerTypeId)).mWords[1];
                    this.writeInstruction(100, imageTypeId, imageId, samplerId, writer);
                    argumentIds.set(0, imageId);
                }
                int typeId = this.writeType(callType);
                this.writeInstruction(95, typeId, resultId, argumentIds.getInt(0), argumentIds.getInt(1), 2, argumentIds.getInt(2), writer);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.releaseIdList(argumentIds);
        return resultId;
    }

    private int writeIntrinsicCall(FunctionCall call, Writer writer) {
        FunctionDecl funcDecl = call.getFunction();
        assert (funcDecl.isIntrinsic());
        int dataIndex = funcDecl.getIntrinsicKind() * 5;
        if (sIntrinsicData[dataIndex] == 0) {
            this.getContext().error(call.mPosition, "unsupported intrinsic '" + funcDecl + "'");
            return -1;
        }
        Expression[] arguments = call.getArguments();
        int intrinsicId = sIntrinsicData[dataIndex + 1];
        if (arguments.length > 0) {
            Type type = arguments[0].getType();
            if (sIntrinsicData[dataIndex] != 3) {
                intrinsicId = SPIRVCodeGenerator.select_by_component_type(type, sIntrinsicData[dataIndex + 1], sIntrinsicData[dataIndex + 2], sIntrinsicData[dataIndex + 3], sIntrinsicData[dataIndex + 4]);
            }
        }
        switch (sIntrinsicData[dataIndex]) {
            case 1: {
                int resultId = this.getUniqueId(call.getType());
                int typeId = this.writeType(call.getType());
                IntArrayList argumentIds = this.obtainIdList();
                ArrayList<OutVar> tmpOutVars = new ArrayList<OutVar>();
                for (int i = 0; i < arguments.length; ++i) {
                    this.writeFunctionCallArgument(argumentIds, call, i, tmpOutVars, writer);
                }
                this.writeOpcode(12, 5 + argumentIds.size(), writer);
                writer.writeWord(typeId);
                writer.writeWord(resultId);
                writer.writeWord(this.mGLSLExtendedInstructions);
                writer.writeWord(intrinsicId);
                writer.writeWords(argumentIds.elements(), argumentIds.size());
                this.copyBackOutArguments(tmpOutVars, writer);
                this.releaseIdList(argumentIds);
                return resultId;
            }
            case 2: {
                if (intrinsicId == 148 && arguments[0].getType().isScalar()) {
                    intrinsicId = 133;
                }
                int resultId = this.getUniqueId(call.getType());
                IntArrayList argumentIds = this.obtainIdList();
                ArrayList<OutVar> tmpOutVars = new ArrayList<OutVar>();
                for (int i = 0; i < arguments.length; ++i) {
                    this.writeFunctionCallArgument(argumentIds, call, i, tmpOutVars, writer);
                }
                if (!call.getType().isVoid()) {
                    int typeId = this.writeType(call.getType());
                    this.writeOpcode(intrinsicId, 3 + arguments.length, writer);
                    writer.writeWord(typeId);
                    writer.writeWord(resultId);
                } else {
                    this.writeOpcode(intrinsicId, 1 + arguments.length, writer);
                }
                writer.writeWords(argumentIds.elements(), argumentIds.size());
                this.copyBackOutArguments(tmpOutVars, writer);
                this.releaseIdList(argumentIds);
                return resultId;
            }
            case 3: {
                return this.writeSpecialIntrinsic(call, intrinsicId, writer);
            }
        }
        this.getContext().error(call.mPosition, "unsupported intrinsic '" + funcDecl + "'");
        return -1;
    }

    private int writeFunctionCall(FunctionCall call, Writer writer) {
        FunctionDecl funcDecl = call.getFunction();
        if (funcDecl.isIntrinsic() && funcDecl.getDefinition() == null) {
            return this.writeIntrinsicCall(call, writer);
        }
        int entry = this.mFunctionTable.getInt((Object)funcDecl);
        if (entry == 0) {
            this.getContext().error(call.mPosition, "function '" + funcDecl + "' is not defined");
            return -1;
        }
        Expression[] arguments = call.getArguments();
        IntArrayList argumentIds = this.obtainIdList();
        ArrayList<OutVar> tmpOutVars = new ArrayList<OutVar>();
        for (int i = 0; i < arguments.length; ++i) {
            this.writeFunctionCallArgument(argumentIds, call, i, tmpOutVars, writer);
        }
        int resultId = this.getUniqueId();
        int typeId = this.writeType(call.getType());
        this.writeOpcode(57, 4 + argumentIds.size(), writer);
        writer.writeWord(typeId);
        writer.writeWord(resultId);
        writer.writeWord(entry);
        writer.writeWords(argumentIds.elements(), argumentIds.size());
        this.copyBackOutArguments(tmpOutVars, writer);
        this.releaseIdList(argumentIds);
        return resultId;
    }

    private int writeConversion(int inputId, Type inputType, Type outputType, Writer writer) {
        assert (inputType.isScalar() || inputType.isVector());
        assert (inputType.getTypeKind() == outputType.getTypeKind());
        assert (inputType.getRows() == outputType.getRows());
        int vectorSize = inputType.getRows();
        if (outputType.isFloatOrCompound()) {
            if (inputType.isFloatOrCompound()) {
                assert (inputType.getComponentType().getWidth() == outputType.getComponentType().getWidth());
                return inputId;
            }
            int resultId = this.getUniqueId(outputType);
            int typeId = this.writeType(outputType);
            if (inputType.isBooleanOrCompound()) {
                int oneId = this.vectorize(1.0, this.getContext().getTypes().mFloat, vectorSize, writer);
                int zeroId = this.vectorize(0.0, this.getContext().getTypes().mFloat, vectorSize, writer);
                this.writeInstruction(169, typeId, resultId, inputId, oneId, zeroId, writer);
            } else if (inputType.isSignedOrCompound()) {
                this.writeInstruction(111, typeId, resultId, inputId, writer);
            } else if (inputType.isUnsignedOrCompound()) {
                this.writeInstruction(112, typeId, resultId, inputId, writer);
            } else {
                assert (false) : "unsupported type for float typecast: " + inputType;
                return -1;
            }
            return resultId;
        }
        if (outputType.isSignedOrCompound()) {
            if (inputType.isSignedOrCompound()) {
                assert (inputType.getComponentType().getWidth() == outputType.getComponentType().getWidth());
                return inputId;
            }
            int resultId = this.getUniqueId(outputType);
            int typeId = this.writeType(outputType);
            if (inputType.isBooleanOrCompound()) {
                int oneId = this.vectorize(1.0, this.getContext().getTypes().mInt, vectorSize, writer);
                int zeroId = this.vectorize(0.0, this.getContext().getTypes().mInt, vectorSize, writer);
                this.writeInstruction(169, typeId, resultId, inputId, oneId, zeroId, writer);
            } else if (inputType.isFloatOrCompound()) {
                this.writeInstruction(110, typeId, resultId, inputId, writer);
            } else if (inputType.isUnsignedOrCompound()) {
                this.writeInstruction(124, typeId, resultId, inputId, writer);
            } else {
                assert (false) : "unsupported type for signed int typecast: " + inputType;
                return -1;
            }
            return resultId;
        }
        if (outputType.isUnsignedOrCompound()) {
            if (inputType.isUnsignedOrCompound()) {
                assert (inputType.getComponentType().getWidth() == outputType.getComponentType().getWidth());
                return inputId;
            }
            int resultId = this.getUniqueId(outputType);
            int typeId = this.writeType(outputType);
            if (inputType.isBooleanOrCompound()) {
                int oneId = this.vectorize(1.0, this.getContext().getTypes().mUInt, vectorSize, writer);
                int zeroId = this.vectorize(0.0, this.getContext().getTypes().mUInt, vectorSize, writer);
                this.writeInstruction(169, typeId, resultId, inputId, oneId, zeroId, writer);
            } else if (inputType.isFloatOrCompound()) {
                this.writeInstruction(109, typeId, resultId, inputId, writer);
            } else if (inputType.isSignedOrCompound()) {
                this.writeInstruction(124, typeId, resultId, inputId, writer);
            } else {
                assert (false) : "unsupported type for unsigned int typecast: " + inputType;
                return -1;
            }
            return resultId;
        }
        if (outputType.isBooleanOrCompound()) {
            if (inputType.isBooleanOrCompound()) {
                return inputId;
            }
            int resultId = this.getUniqueId();
            int typeId = this.writeType(outputType);
            if (inputType.isSignedOrCompound()) {
                int zeroId = this.vectorize(0.0, this.getContext().getTypes().mInt, vectorSize, writer);
                this.writeInstruction(171, typeId, resultId, inputId, zeroId, writer);
            } else if (inputType.isUnsignedOrCompound()) {
                int zeroId = this.vectorize(0.0, this.getContext().getTypes().mUInt, vectorSize, writer);
                this.writeInstruction(171, typeId, resultId, inputId, zeroId, writer);
            } else if (inputType.isFloatOrCompound()) {
                int zeroId = this.vectorize(0.0, this.getContext().getTypes().mFloat, vectorSize, writer);
                this.writeInstruction(183, typeId, resultId, inputId, zeroId, writer);
            } else {
                assert (false) : "unsupported type for boolean typecast: " + inputType;
                return -1;
            }
            return resultId;
        }
        this.getContext().error(-1, "unsupported cast: " + inputType + " to " + outputType);
        return inputId;
    }

    private int writeConstructorScalarCast(ConstructorScalarCast ctor, Writer writer) {
        Expression argument = ctor.getArgument();
        int argumentId = this.writeExpression(argument, writer);
        return this.writeConversion(argumentId, argument.getType(), ctor.getType(), writer);
    }

    private int writeConstructorCompoundCast(ConstructorCompoundCast ctor, Writer writer) {
        Type ctorType = ctor.getType();
        Type argType = ctor.getArgument().getType();
        assert (ctorType.isVector() || ctorType.isMatrix());
        int compositeId = this.writeExpression(ctor.getArgument(), writer);
        if (ctorType.isMatrix()) {
            assert (ctorType.getComponentType().getWidth() == argType.getComponentType().getWidth());
            assert (ctorType.getComponentType().getScalarKind() == argType.getComponentType().getScalarKind());
            return compositeId;
        }
        return this.writeConversion(compositeId, argType, ctorType, writer);
    }

    private int writeConstructorVectorSplat(ConstructorVectorSplat ctor, Writer writer) {
        int argument = this.writeExpression(ctor.getArgument(), writer);
        return this.broadcast(ctor.getType(), argument, writer);
    }

    private int writeConstructorDiagonalMatrix(ConstructorDiagonalMatrix ctor, Writer writer) {
        Type type = ctor.getType();
        assert (type.isMatrix());
        assert (ctor.getArgument().getType().isScalar());
        int diagonal = this.writeExpression(ctor.getArgument(), writer);
        int zeroId = this.writeScalarConstant(0.0, this.getContext().getTypes().mFloat);
        Type columnType = type.getComponentType().toVector(this.getContext(), type.getRows());
        IntArrayList columnIds = this.obtainIdList();
        IntArrayList arguments = this.obtainIdList();
        for (int column = 0; column < type.getCols(); ++column) {
            for (int row = 0; row < type.getRows(); ++row) {
                arguments.add(row == column ? diagonal : zeroId);
            }
            columnIds.add(this.writeOpCompositeConstruct(columnType, arguments, writer));
            arguments.clear();
        }
        int resultId = this.writeOpCompositeConstruct(type, columnIds, writer);
        this.releaseIdList(columnIds);
        this.releaseIdList(arguments);
        return resultId;
    }

    private int writeVectorConstructor(ConstructorCompound ctor, Writer writer) {
        Type type = ctor.getType();
        Type componentType = type.getComponentType();
        assert (type.isVector());
        IntArrayList argumentIds = this.obtainIdList();
        for (Expression arg : ctor.getArguments()) {
            int j;
            Type argType = arg.getType();
            assert (componentType.getScalarKind() == argType.getComponentType().getScalarKind());
            int argId = this.writeExpression(arg, writer);
            if (argType.isMatrix()) {
                assert (argType.getRows() == 2);
                assert (argType.getCols() == 2);
                for (j = 0; j < 4; ++j) {
                    argumentIds.add(this.writeOpCompositeExtract(componentType, argId, j / 2, j % 2, writer));
                }
                continue;
            }
            if (argType.isVector()) {
                for (j = 0; j < argType.getRows(); ++j) {
                    argumentIds.add(this.writeOpCompositeExtract(componentType, argId, j, writer));
                }
                continue;
            }
            argumentIds.add(argId);
        }
        int resultId = this.writeOpCompositeConstruct(type, argumentIds, writer);
        this.releaseIdList(argumentIds);
        return resultId;
    }

    private void addColumnEntry(Type columnType, IntArrayList currentColumn, IntArrayList columnIds, int rows, int entry, Writer writer) {
        assert (currentColumn.size() < rows);
        currentColumn.add(entry);
        if (currentColumn.size() == rows) {
            int columnId = this.writeOpCompositeConstruct(columnType, currentColumn, writer);
            columnIds.add(columnId);
            currentColumn.clear();
        }
    }

    private int writeMatrixConstructor(ConstructorCompound ctor, Writer writer) {
        Type type = ctor.getType();
        Type componentType = type.getComponentType();
        assert (type.isMatrix());
        Type arg0Type = ctor.getArguments()[0].getType();
        IntArrayList arguments = this.obtainIdList();
        for (Expression arg : ctor.getArguments()) {
            arguments.add(this.writeExpression(arg, writer));
        }
        int rows = type.getRows();
        Type columnType = componentType.toVector(this.getContext(), rows);
        if (arguments.size() == 1 && arg0Type.isVector()) {
            assert (type.getRows() == 2 && type.getCols() == 2);
            assert (arg0Type.getRows() == 4);
            int argId = arguments.getInt(0);
            arguments.clear();
            for (int i = 0; i < 2; ++i) {
                arguments.add(this.writeOpCompositeExtract(componentType, argId, i, writer));
            }
            int v0v1 = this.writeOpCompositeConstruct(columnType, arguments, writer);
            arguments.clear();
            for (int i = 2; i < 4; ++i) {
                arguments.add(this.writeOpCompositeExtract(componentType, argId, i, writer));
            }
            int v2v3 = this.writeOpCompositeConstruct(columnType, arguments, writer);
            arguments.clear();
            arguments.add(v0v1);
            arguments.add(v2v3);
            int resultId = this.writeOpCompositeConstruct(type, arguments, writer);
            this.releaseIdList(arguments);
            return resultId;
        }
        IntArrayList columnIds = this.obtainIdList();
        IntArrayList currentColumn = this.obtainIdList();
        for (int i = 0; i < arguments.size(); ++i) {
            Type argType = ctor.getArguments()[i].getType();
            if (currentColumn.isEmpty() && argType.isVector() && argType.getRows() == rows) {
                columnIds.add(arguments.getInt(i));
                continue;
            }
            if (argType.getRows() == 1) {
                this.addColumnEntry(columnType, currentColumn, columnIds, rows, arguments.getInt(i), writer);
                continue;
            }
            for (int j = 0; j < argType.getRows(); ++j) {
                int swizzle = this.writeOpCompositeExtract(argType.getComponentType(), arguments.getInt(i), j, writer);
                this.addColumnEntry(columnType, currentColumn, columnIds, rows, swizzle, writer);
            }
        }
        assert (columnIds.size() == type.getCols());
        int resultId = this.writeOpCompositeConstruct(type, columnIds, writer);
        this.releaseIdList(columnIds);
        this.releaseIdList(currentColumn);
        return resultId;
    }

    private int writeConstructorCompound(ConstructorCompound ctor, Writer writer) {
        return ctor.getType().isMatrix() ? this.writeMatrixConstructor(ctor, writer) : this.writeVectorConstructor(ctor, writer);
    }

    private int writeCompositeConstructor(ConstructorCall ctor, Writer writer) {
        assert (ctor.getType().isArray() || ctor.getType().isStruct());
        IntArrayList argumentIds = this.obtainIdList();
        for (Expression arg : ctor.getArguments()) {
            argumentIds.add(this.writeExpression(arg, writer));
        }
        int resultId = this.writeOpCompositeConstruct(ctor.getType(), argumentIds, writer);
        this.releaseIdList(argumentIds);
        return resultId;
    }

    private void buildInstructions(@Nonnull TranslationUnit translationUnit) {
        this.mGLSLExtendedInstructions = this.getUniqueId();
        this.mCapabilities.add(1);
        for (TopLevelElement e : translationUnit) {
            if (!(e instanceof FunctionDefinition)) continue;
            FunctionDefinition funcDef = (FunctionDefinition)e;
            FunctionDecl function = funcDef.getFunctionDecl();
            this.mFunctionTable.put((Object)function, this.getUniqueId());
            if (!function.isEntryPoint()) continue;
            this.mEntryPointFunction = function;
        }
        if (this.mEntryPointFunction == null) {
            this.getContext().error(-1, "translation unit does not contain an entry point");
            return;
        }
        for (TopLevelElement e : translationUnit) {
            if (!(e instanceof InterfaceBlock)) continue;
            InterfaceBlock block = (InterfaceBlock)e;
            this.writeInterfaceBlock(block);
        }
        for (TopLevelElement e : translationUnit) {
            GlobalVariableDecl globalVariableDecl;
            VariableDecl variableDecl;
            if (!(e instanceof GlobalVariableDecl) || this.writeGlobalVariableDecl(variableDecl = (globalVariableDecl = (GlobalVariableDecl)e).getVariableDecl())) continue;
            return;
        }
        for (TopLevelElement e : translationUnit) {
            if (!(e instanceof FunctionDefinition)) continue;
            FunctionDefinition functionDef = (FunctionDefinition)e;
            this.writeFunction(functionDef, this.mFunctionBuffer);
        }
        ObjectIterator it = this.mVariableTable.reference2IntEntrySet().fastIterator();
        while (it.hasNext()) {
            TopLevelElement e;
            e = (Reference2IntMap.Entry)it.next();
            Variable variable = (Variable)e.getKey();
            if (variable.getStorage() != 1 || !this.mOutputVersion.isAtLeast(SPIRVVersion.SPIRV_1_4) && (variable.getModifiers().flags() & 0x60) == 0) continue;
            this.mInterfaceVariables.add(e.getIntValue());
        }
    }

    int writeOpLoad(int type, boolean relaxedPrecision, int pointer, Writer writer) {
        int resultId = this.getUniqueId(relaxedPrecision);
        this.writeInstruction(61, type, resultId, pointer, writer);
        return resultId;
    }

    void writeOpStore(int storageClass, int pointer, int rvalue, Writer writer) {
        this.writeInstruction(62, pointer, rvalue, writer);
        if (storageClass == 7) {
            this.mStoreCache.put(pointer, rvalue);
            this.mStoreOps.add(pointer);
        }
    }

    void writeOpcode(int opcode, int count, Writer writer) {
        if ((count & 0xFFFF0000) != 0) {
            this.getContext().error(-1, "too many words");
        }
        assert (opcode != 61 || writer != this.mConstantBuffer);
        assert (opcode != 1);
        boolean foundDeadCode = false;
        switch (opcode) {
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: {
                foundDeadCode = this.mCurrentBlock == 0;
                this.mCurrentBlock = 0;
                break;
            }
        }
        if (foundDeadCode) {
            this.writeLabel(this.getUniqueId(), writer);
        }
        writer.writeWord(count << 16 | opcode);
    }

    void writeInstruction(int opcode, Writer writer) {
        this.writeOpcode(opcode, 1, writer);
    }

    void writeInstruction(int opcode, int word1, Writer writer) {
        this.writeOpcode(opcode, 2, writer);
        writer.writeWord(word1);
    }

    void writeInstruction(int opcode, int word1, int word2, Writer writer) {
        this.writeOpcode(opcode, 3, writer);
        writer.writeWord(word1);
        writer.writeWord(word2);
    }

    private void writeInstruction(int opcode, int word1, String string, Writer writer) {
        this.writeOpcode(opcode, 2 + (string.length() + 4 >> 2), writer);
        writer.writeWord(word1);
        writer.writeString8(this.getContext(), string);
    }

    void writeInstruction(int opcode, int word1, int word2, int word3, Writer writer) {
        this.writeOpcode(opcode, 4, writer);
        writer.writeWord(word1);
        writer.writeWord(word2);
        writer.writeWord(word3);
    }

    private void writeInstruction(int opcode, int word1, int word2, String string, Writer writer) {
        this.writeOpcode(opcode, 3 + (string.length() + 4 >> 2), writer);
        writer.writeWord(word1);
        writer.writeWord(word2);
        writer.writeString8(this.getContext(), string);
    }

    void writeInstruction(int opcode, int word1, int word2, int word3, int word4, Writer writer) {
        this.writeOpcode(opcode, 5, writer);
        writer.writeWord(word1);
        writer.writeWord(word2);
        writer.writeWord(word3);
        writer.writeWord(word4);
    }

    void writeInstruction(int opcode, int word1, int word2, int word3, int word4, int word5, Writer writer) {
        this.writeOpcode(opcode, 6, writer);
        writer.writeWord(word1);
        writer.writeWord(word2);
        writer.writeWord(word3);
        writer.writeWord(word4);
        writer.writeWord(word5);
    }

    void writeInstruction(int opcode, int word1, int word2, int word3, int word4, int word5, int word6, Writer writer) {
        this.writeOpcode(opcode, 7, writer);
        writer.writeWord(word1);
        writer.writeWord(word2);
        writer.writeWord(word3);
        writer.writeWord(word4);
        writer.writeWord(word5);
        writer.writeWord(word6);
    }

    void writeInstruction(int opcode, int word1, int word2, int word3, int word4, int word5, int word6, int word7, Writer writer) {
        this.writeOpcode(opcode, 8, writer);
        writer.writeWord(word1);
        writer.writeWord(word2);
        writer.writeWord(word3);
        writer.writeWord(word4);
        writer.writeWord(word5);
        writer.writeWord(word6);
        writer.writeWord(word7);
    }

    void writeInstruction(int opcode, int word1, int word2, int word3, int word4, int word5, int word6, int word7, int word8, Writer writer) {
        this.writeOpcode(opcode, 9, writer);
        writer.writeWord(word1);
        writer.writeWord(word2);
        writer.writeWord(word3);
        writer.writeWord(word4);
        writer.writeWord(word5);
        writer.writeWord(word6);
        writer.writeWord(word7);
        writer.writeWord(word8);
    }

    private int writeInstructionWithCache(@Nonnull InstructionBuilder key, @Nonnull Writer writer) {
        assert (key.mOpcode != 61);
        assert (key.mOpcode != 62);
        int cachedId = this.mOpCache.getInt((Object)key);
        if (cachedId != 0) {
            this.releaseInstBuilder(key);
            return cachedId;
        }
        Instruction instruction = key.copy();
        int resultId = -1;
        boolean relaxedPrecision = false;
        switch (key.mResultKind) {
            case 4: {
                resultId = this.getUniqueId();
                this.mSpvIdCache.put(resultId, (Object)instruction);
                break;
            }
            case 1: {
                this.mOpCache.put((Object)instruction, resultId);
                break;
            }
            case 3: {
                relaxedPrecision = true;
            }
            case 2: 
            case 5: {
                resultId = this.getUniqueId(relaxedPrecision);
                this.mOpCache.put((Object)instruction, resultId);
                this.mSpvIdCache.put(resultId, (Object)instruction);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        int[] values = key.mValues.elements();
        int[] kinds = key.mKinds.elements();
        int s = key.mValues.size();
        this.writeOpcode(key.mOpcode, s + 1, writer);
        for (int i = 0; i < s; ++i) {
            if (Instruction.isResult(kinds[i])) {
                assert (resultId != -1);
                writer.writeWord(resultId);
                continue;
            }
            writer.writeWord(values[i]);
        }
        this.releaseInstBuilder(key);
        return resultId;
    }

    private void releaseInstBuilder(@Nonnull InstructionBuilder key) {
        if (this.mInstBuilderPoolSize == this.mInstBuilderPool.length) {
            return;
        }
        this.mInstBuilderPool[this.mInstBuilderPoolSize++] = key;
    }

    @Nonnull
    private IntArrayList obtainIdList() {
        if (this.mIdListPoolSize == 0) {
            return new IntArrayList();
        }
        IntArrayList r = this.mIdListPool[--this.mIdListPoolSize];
        r.clear();
        return r;
    }

    private void releaseIdList(@Nonnull IntArrayList idList) {
        if (this.mIdListPoolSize == this.mIdListPool.length) {
            return;
        }
        this.mIdListPool[this.mIdListPoolSize++] = idList;
    }

    static {
        SPIRVCodeGenerator.setIntrinsic(0, 1, 1, 1, 1, 1);
        SPIRVCodeGenerator.setIntrinsic(1, 1, 2, 2, 2, 2);
        SPIRVCodeGenerator.setIntrinsic(2, 1, 3, 3, 3, 3);
        SPIRVCodeGenerator.setIntrinsic(3, 1, 4, 5, 5, 0);
        SPIRVCodeGenerator.setIntrinsic(4, 1, 6, 7, 7, 0);
        SPIRVCodeGenerator.setIntrinsic(5, 1, 8, 8, 8, 8);
        SPIRVCodeGenerator.setIntrinsic(6, 1, 9, 9, 9, 9);
        SPIRVCodeGenerator.setIntrinsic(7, 1, 10, 10, 10, 10);
        SPIRVCodeGenerator.setIntrinsic(8, 1, 11, 11, 11, 11);
        SPIRVCodeGenerator.setIntrinsic(9, 1, 12, 12, 12, 12);
        SPIRVCodeGenerator.setIntrinsic(10, 1, 13, 13, 13, 13);
        SPIRVCodeGenerator.setIntrinsic(11, 1, 14, 14, 14, 14);
        SPIRVCodeGenerator.setIntrinsic(12, 1, 15, 15, 15, 15);
        SPIRVCodeGenerator.setIntrinsic(13, 1, 16, 16, 16, 16);
        SPIRVCodeGenerator.setIntrinsic(14, 1, 17, 17, 17, 17);
        SPIRVCodeGenerator.setIntrinsic(15, 3, 0, 0, 0, 0);
        SPIRVCodeGenerator.setIntrinsic(22, 1, 26, 26, 26, 26);
        SPIRVCodeGenerator.setIntrinsic(23, 1, 27, 27, 27, 27);
        SPIRVCodeGenerator.setIntrinsic(24, 1, 28, 28, 28, 28);
        SPIRVCodeGenerator.setIntrinsic(25, 1, 29, 29, 29, 29);
        SPIRVCodeGenerator.setIntrinsic(26, 1, 30, 30, 30, 30);
        SPIRVCodeGenerator.setIntrinsic(27, 1, 31, 31, 31, 31);
        SPIRVCodeGenerator.setIntrinsic(29, 3, 6, 6, 6, 6);
        SPIRVCodeGenerator.setIntrinsic(30, 1, 35, 35, 35, 35);
        SPIRVCodeGenerator.setIntrinsic(31, 3, 4, 4, 4, 4);
        SPIRVCodeGenerator.setIntrinsic(32, 3, 3, 3, 3, 3);
        SPIRVCodeGenerator.setIntrinsic(33, 3, 1, 1, 1, 1);
        SPIRVCodeGenerator.setIntrinsic(34, 3, 7, 7, 7, 7);
        SPIRVCodeGenerator.setIntrinsic(61, 2, 148, 1, 1, 1);
        SPIRVCodeGenerator.setIntrinsic(35, 3, 5, 5, 5, 5);
        SPIRVCodeGenerator.setIntrinsic(36, 3, 10, 10, 10, 10);
        SPIRVCodeGenerator.setIntrinsic(37, 3, 9, 9, 9, 9);
        SPIRVCodeGenerator.setIntrinsic(59, 1, 66, 66, 66, 66);
        SPIRVCodeGenerator.setIntrinsic(60, 1, 67, 67, 67, 67);
        SPIRVCodeGenerator.setIntrinsic(62, 1, 68, 68, 68, 68);
        SPIRVCodeGenerator.setIntrinsic(63, 1, 69, 69, 69, 69);
        SPIRVCodeGenerator.setIntrinsic(64, 1, 70, 70, 70, 70);
        SPIRVCodeGenerator.setIntrinsic(65, 1, 71, 71, 71, 71);
        SPIRVCodeGenerator.setIntrinsic(66, 1, 72, 72, 72, 72);
        SPIRVCodeGenerator.setIntrinsic(81, 2, 207, 1, 1, 1);
        SPIRVCodeGenerator.setIntrinsic(82, 2, 208, 1, 1, 1);
        SPIRVCodeGenerator.setIntrinsic(83, 2, 209, 1, 1, 1);
        SPIRVCodeGenerator.setIntrinsic(124, 3, 12, 12, 12, 12);
        SPIRVCodeGenerator.setIntrinsic(128, 3, 15, 15, 15, 15);
        SPIRVCodeGenerator.setIntrinsic(67, 2, 1, 1, 1, 154);
        SPIRVCodeGenerator.setIntrinsic(68, 2, 1, 1, 1, 155);
        SPIRVCodeGenerator.setIntrinsic(69, 2, 1, 1, 1, 168);
        SPIRVCodeGenerator.setIntrinsic(70, 2, 180, 170, 170, 164);
        SPIRVCodeGenerator.setIntrinsic(71, 2, 183, 171, 171, 165);
        SPIRVCodeGenerator.setIntrinsic(72, 2, 184, 177, 176, 1);
        SPIRVCodeGenerator.setIntrinsic(74, 2, 188, 179, 178, 1);
        SPIRVCodeGenerator.setIntrinsic(73, 2, 186, 173, 172, 1);
        SPIRVCodeGenerator.setIntrinsic(75, 2, 190, 175, 174, 1);
    }
}

