/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.tree;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.compiler.ConstantFolder;
import yslelf.cloudpick.render.compiler.Context;
import yslelf.cloudpick.render.compiler.Operator;
import yslelf.cloudpick.render.compiler.tree.Expression;
import yslelf.cloudpick.render.compiler.tree.Node;
import yslelf.cloudpick.render.compiler.tree.TreeVisitor;
import yslelf.cloudpick.render.compiler.tree.Type;

public final class BinaryExpression
extends Expression {
    private Expression mLeft;
    private final Operator mOperator;
    private Expression mRight;

    private BinaryExpression(int position, Expression left, Operator op, Expression right, Type type) {
        super(position, type);
        this.mLeft = left;
        this.mOperator = op;
        this.mRight = right;
    }

    @Nullable
    public static Expression convert(@Nonnull Context context, int position, Expression left, Operator op, Expression right) {
        Type rawLeftType = left.isIntLiteral() && right.getType().isInteger() ? right.getType() : left.getType();
        Type rawRightType = right.isIntLiteral() && left.getType().isInteger() ? left.getType() : right.getType();
        boolean isAssignment = op.isAssignment();
        Type[] types = new Type[3];
        if (!op.determineBinaryType(context, rawLeftType, rawRightType, types)) {
            context.error(position, "type mismatch: '" + op + "' cannot operate on '" + left.getType().getName() + "', '" + right.getType().getName() + "'");
            return null;
        }
        Type leftType = types[0];
        Type rightType = types[1];
        Type resultType = types[2];
        if (isAssignment && leftType.getComponentType().isOpaque()) {
            context.error(position, "assignments to opaque type '" + left.getType().getName() + "' are not permitted");
            return null;
        }
        if ((left = leftType.coerceExpression(context, left)) == null) {
            return null;
        }
        if ((right = rightType.coerceExpression(context, right)) == null) {
            return null;
        }
        return BinaryExpression.make(context, position, left, op, right, resultType);
    }

    @Nonnull
    public static Expression make(@Nonnull Context context, int pos, Expression left, Operator op, Expression right, Type resultType) {
        Expression folded = ConstantFolder.fold(context, pos, left, op, right, resultType);
        if (folded != null) {
            return folded;
        }
        return new BinaryExpression(pos, left, op, right, resultType);
    }

    @Override
    public Node.ExpressionKind getKind() {
        return Node.ExpressionKind.BINARY;
    }

    @Override
    public boolean accept(@Nonnull TreeVisitor visitor) {
        if (visitor.visitBinary(this)) {
            return true;
        }
        return this.mLeft != null && this.mLeft.accept(visitor) || this.mRight != null && this.mRight.accept(visitor);
    }

    public Expression getLeft() {
        return this.mLeft;
    }

    public Operator getOperator() {
        return this.mOperator;
    }

    public Expression getRight() {
        return this.mRight;
    }

    public void setLeft(Expression left) {
        this.mLeft = left;
    }

    public void setRight(Expression right) {
        this.mRight = right;
    }

    @Override
    @Nonnull
    public Expression clone(int position) {
        return new BinaryExpression(position, this.mLeft.clone(), this.mOperator, this.mRight.clone(), this.getType());
    }

    @Override
    @Nonnull
    public String toString(int parentPrecedence) {
        int operatorPrecedence = this.mOperator.getBinaryPrecedence();
        boolean needsParens = operatorPrecedence >= parentPrecedence;
        return (needsParens ? "(" : "") + this.mLeft.toString(operatorPrecedence) + this.mOperator.getPrettyName() + this.mRight.toString(operatorPrecedence) + (needsParens ? ")" : "");
    }
}

