/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.tree;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import yslelf.cloudpick.render.compiler.Position;
import yslelf.cloudpick.render.compiler.tree.EmptyStatement;
import yslelf.cloudpick.render.compiler.tree.Node;
import yslelf.cloudpick.render.compiler.tree.Statement;
import yslelf.cloudpick.render.compiler.tree.TreeVisitor;

public final class BlockStatement
extends Statement {
    private List<Statement> mStatements;
    private boolean mScoped;

    public BlockStatement(int position, List<Statement> statements, boolean scoped) {
        super(position);
        this.mStatements = statements;
        this.mScoped = scoped;
    }

    public static Statement make(int pos, List<Statement> statements, boolean scoped) {
        if (scoped) {
            return new BlockStatement(pos, statements, true);
        }
        if (statements.isEmpty()) {
            return new EmptyStatement(pos);
        }
        if (statements.size() > 1) {
            Statement foundStatement = null;
            for (Statement stmt : statements) {
                if (stmt.isEmpty()) continue;
                if (foundStatement == null) {
                    foundStatement = stmt;
                    continue;
                }
                return new BlockStatement(pos, statements, scoped);
            }
            if (foundStatement != null) {
                return foundStatement;
            }
        }
        return statements.get(0);
    }

    public static BlockStatement makeBlock(int pos, List<Statement> statements) {
        return new BlockStatement(pos, statements, true);
    }

    public static Statement makeCompound(Statement before, Statement after) {
        BlockStatement block;
        if (before == null || before.isEmpty()) {
            return after;
        }
        if (after == null || after.isEmpty()) {
            return before;
        }
        if (before instanceof BlockStatement && !(block = (BlockStatement)before).isScoped()) {
            block.getStatements().add(after);
            return before;
        }
        int pos = Position.range(before.getStartOffset(), after.getEndOffset());
        ArrayList<Statement> statements = new ArrayList<Statement>(2);
        statements.add(before);
        statements.add(after);
        return BlockStatement.make(pos, statements, false);
    }

    @Override
    public Node.StatementKind getKind() {
        return Node.StatementKind.BLOCK;
    }

    @Override
    public boolean accept(@Nonnull TreeVisitor visitor) {
        if (visitor.visitBlock(this)) {
            return true;
        }
        for (Statement stmt : this.mStatements) {
            if (!stmt.accept(visitor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        for (Statement stmt : this.mStatements) {
            if (stmt.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public List<Statement> getStatements() {
        return this.mStatements;
    }

    public void setStatements(List<Statement> statements) {
        this.mStatements = statements;
    }

    public boolean isScoped() {
        return this.mScoped;
    }

    public void setScoped(boolean scoped) {
        this.mScoped = scoped;
    }

    @Override
    @Nonnull
    public String toString() {
        boolean isScoped;
        StringBuilder result = new StringBuilder();
        boolean bl = isScoped = this.isScoped() || this.isEmpty();
        if (isScoped) {
            result.append("{");
        }
        for (Statement stmt : this.mStatements) {
            result.append("\n");
            result.append(stmt.toString());
        }
        result.append(isScoped ? "\n}\n" : "\n");
        return result.toString();
    }
}

