/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.tree;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.compiler.Context;
import yslelf.cloudpick.render.compiler.Operator;
import yslelf.cloudpick.render.compiler.Position;
import yslelf.cloudpick.render.compiler.tree.Expression;
import yslelf.cloudpick.render.compiler.tree.Node;
import yslelf.cloudpick.render.compiler.tree.TreeVisitor;
import yslelf.cloudpick.render.compiler.tree.Type;

public final class ConditionalExpression
extends Expression {
    private Expression mCondition;
    private Expression mWhenTrue;
    private Expression mWhenFalse;

    private ConditionalExpression(int position, Expression condition, Expression whenTrue, Expression whenFalse) {
        super(position, whenTrue.getType());
        this.mCondition = condition;
        this.mWhenTrue = whenTrue;
        this.mWhenFalse = whenFalse;
        assert (whenTrue.getType().matches(whenFalse.getType()));
    }

    @Nullable
    public static Expression convert(@Nonnull Context context, int position, Expression condition, Expression whenTrue, Expression whenFalse) {
        if ((condition = context.getTypes().mBool.coerceExpression(context, condition)) == null || whenTrue == null || whenFalse == null) {
            return null;
        }
        if (whenTrue.getType().getComponentType().isOpaque()) {
            context.error(position, "ternary expression of opaque type '" + whenTrue.getType().getName() + "' not allowed");
            return null;
        }
        Type[] types = new Type[3];
        if (!Operator.EQ.determineBinaryType(context, whenTrue.getType(), whenFalse.getType(), types) || !types[0].matches(types[1])) {
            context.error(Position.range(whenTrue.getStartOffset(), whenFalse.getEndOffset()), "conditional operator result mismatch: '" + whenTrue.getType().getName() + "', '" + whenFalse.getType().getName() + "'");
            return null;
        }
        if ((whenTrue = types[0].coerceExpression(context, whenTrue)) == null) {
            return null;
        }
        if ((whenFalse = types[1].coerceExpression(context, whenFalse)) == null) {
            return null;
        }
        return new ConditionalExpression(position, condition, whenTrue, whenFalse);
    }

    @Override
    public Node.ExpressionKind getKind() {
        return Node.ExpressionKind.CONDITIONAL;
    }

    @Override
    public boolean accept(@Nonnull TreeVisitor visitor) {
        if (visitor.visitConditional(this)) {
            return true;
        }
        return this.mCondition.accept(visitor) || this.mWhenTrue != null && this.mWhenTrue.accept(visitor) || this.mWhenFalse != null && this.mWhenFalse.accept(visitor);
    }

    public Expression getCondition() {
        return this.mCondition;
    }

    public void setCondition(Expression condition) {
        this.mCondition = condition;
    }

    public Expression getWhenTrue() {
        return this.mWhenTrue;
    }

    public void setWhenTrue(Expression whenTrue) {
        this.mWhenTrue = whenTrue;
    }

    public Expression getWhenFalse() {
        return this.mWhenFalse;
    }

    public void setWhenFalse(Expression whenFalse) {
        this.mWhenFalse = whenFalse;
    }

    @Override
    @Nonnull
    public Expression clone(int position) {
        return new ConditionalExpression(position, this.mCondition.clone(), this.mWhenTrue.clone(), this.mWhenFalse.clone());
    }

    @Override
    @Nonnull
    public String toString(int parentPrecedence) {
        boolean needsParens = 15 >= parentPrecedence;
        return (needsParens ? "(" : "") + this.mCondition.toString(15) + " ? " + this.mWhenTrue.toString(15) + " : " + this.mWhenFalse.toString(15) + (needsParens ? ")" : "");
    }
}

