/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.tree;

import javax.annotation.Nonnull;
import yslelf.cloudpick.render.compiler.ConstantFolder;
import yslelf.cloudpick.render.compiler.Context;
import yslelf.cloudpick.render.compiler.analysis.Analysis;
import yslelf.cloudpick.render.compiler.tree.ConstructorArray;
import yslelf.cloudpick.render.compiler.tree.ConstructorCall;
import yslelf.cloudpick.render.compiler.tree.ConstructorCompoundCast;
import yslelf.cloudpick.render.compiler.tree.ConstructorScalarCast;
import yslelf.cloudpick.render.compiler.tree.Expression;
import yslelf.cloudpick.render.compiler.tree.Node;
import yslelf.cloudpick.render.compiler.tree.Type;

public final class ConstructorArrayCast
extends ConstructorCall {
    private ConstructorArrayCast(int position, Type type, Expression ... arguments) {
        super(position, type, arguments);
        assert (arguments.length == 1);
    }

    @Nonnull
    public static Expression make(@Nonnull Context context, int position, @Nonnull Type type, @Nonnull Expression arg) {
        assert (type.isArray());
        assert (arg.getType().isArray());
        assert (type.getArraySize() == arg.getType().getArraySize());
        if (type.matches(arg.getType())) {
            arg.mPosition = position;
            return arg;
        }
        if (Analysis.isCompileTimeConstant(arg = ConstantFolder.makeConstantValueForVariable(position, arg))) {
            Type scalarType = type.getComponentType();
            Expression[] inputArgs = ((ConstructorArray)arg).getArguments();
            Expression[] typecastArgs = new Expression[inputArgs.length];
            for (int i = 0; i < inputArgs.length; ++i) {
                Expression inputArg = inputArgs[i];
                typecastArgs[i] = inputArg.getType().isScalar() ? ConstructorScalarCast.make(context, inputArg.mPosition, scalarType, inputArg) : ConstructorCompoundCast.make(inputArg.mPosition, scalarType, inputArg);
            }
            return ConstructorArray.make(position, type, typecastArgs);
        }
        return new ConstructorArrayCast(position, type, arg);
    }

    @Override
    public Node.ExpressionKind getKind() {
        return Node.ExpressionKind.CONSTRUCTOR_ARRAY_CAST;
    }

    @Override
    @Nonnull
    public Expression clone(int position) {
        return new ConstructorArrayCast(position, this.getType(), this.cloneArguments());
    }
}

