/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.tree;

import java.util.OptionalDouble;
import javax.annotation.Nonnull;
import yslelf.cloudpick.render.compiler.ConstantFolder;
import yslelf.cloudpick.render.compiler.tree.ConstructorCall;
import yslelf.cloudpick.render.compiler.tree.Expression;
import yslelf.cloudpick.render.compiler.tree.Node;
import yslelf.cloudpick.render.compiler.tree.Type;

public final class ConstructorDiagonalMatrix
extends ConstructorCall {
    private ConstructorDiagonalMatrix(int position, Type type, Expression ... arguments) {
        super(position, type, arguments);
        assert (arguments.length == 1);
    }

    @Nonnull
    public static Expression make(int position, @Nonnull Type type, @Nonnull Expression arg) {
        assert (type.isMatrix());
        assert (arg.getType().isScalar());
        assert (arg.getType().matches(type.getComponentType()));
        arg = ConstantFolder.makeConstantValueForVariable(position, arg);
        return new ConstructorDiagonalMatrix(position, type, arg);
    }

    @Override
    public Node.ExpressionKind getKind() {
        return Node.ExpressionKind.CONSTRUCTOR_DIAGONAL_MATRIX;
    }

    @Override
    public OptionalDouble getConstantValue(int i) {
        int rows = this.getType().getRows();
        int row = i % rows;
        int col = i / rows;
        assert (col >= 0);
        assert (row >= 0);
        assert (col < this.getType().getCols());
        assert (row < this.getType().getRows());
        return col == row ? this.getArgument().getConstantValue(0) : OptionalDouble.of(0.0);
    }

    @Override
    @Nonnull
    public Expression clone(int position) {
        return new ConstructorDiagonalMatrix(position, this.getType(), this.cloneArguments());
    }
}

