/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.tree;

import javax.annotation.Nonnull;
import yslelf.cloudpick.render.compiler.ConstantFolder;
import yslelf.cloudpick.render.compiler.tree.ConstructorCall;
import yslelf.cloudpick.render.compiler.tree.Expression;
import yslelf.cloudpick.render.compiler.tree.Node;
import yslelf.cloudpick.render.compiler.tree.Type;

public final class ConstructorVectorSplat
extends ConstructorCall {
    private ConstructorVectorSplat(int position, Type type, Expression ... arguments) {
        super(position, type, arguments);
        assert (arguments.length == 1);
    }

    @Nonnull
    public static Expression make(int position, @Nonnull Type type, @Nonnull Expression arg) {
        assert (type.isScalar() || type.isVector());
        assert (arg.getType().matches(type.getComponentType()));
        assert (arg.getType().isScalar());
        if (type.isScalar()) {
            arg.mPosition = position;
            return arg;
        }
        arg = ConstantFolder.makeConstantValueForVariable(position, arg);
        assert (type.isVector());
        return new ConstructorVectorSplat(position, type, arg);
    }

    @Override
    public Node.ExpressionKind getKind() {
        return Node.ExpressionKind.CONSTRUCTOR_VECTOR_SPLAT;
    }

    @Override
    @Nonnull
    public Expression clone(int position) {
        return new ConstructorVectorSplat(position, this.getType(), this.cloneArguments());
    }
}

