/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.tree;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.compiler.Context;
import yslelf.cloudpick.render.compiler.tree.Expression;
import yslelf.cloudpick.render.compiler.tree.Node;
import yslelf.cloudpick.render.compiler.tree.Statement;
import yslelf.cloudpick.render.compiler.tree.TreeVisitor;

public final class ForLoop
extends Statement {
    private Statement mInit;
    private Expression mCondition;
    private Expression mStep;
    private Statement mStatement;

    public ForLoop(int position, Statement init, Expression condition, Expression step, Statement statement) {
        super(position);
        this.mInit = init;
        this.mCondition = condition;
        this.mStep = step;
        this.mStatement = statement;
    }

    @Nullable
    public static Statement convert(@Nonnull Context context, int pos, Statement init, Expression cond, Expression step, Statement statement) {
        if (cond != null && (cond = context.getTypes().mBool.coerceExpression(context, cond)) == null) {
            return null;
        }
        if (step != null && step.isIncomplete(context)) {
            return null;
        }
        return ForLoop.make(pos, init, cond, step, statement);
    }

    public static Statement make(int pos, Statement init, Expression cond, Expression step, Statement statement) {
        return new ForLoop(pos, init, cond, step, statement);
    }

    @Override
    public Node.StatementKind getKind() {
        return Node.StatementKind.FOR_LOOP;
    }

    @Override
    public boolean accept(@Nonnull TreeVisitor visitor) {
        if (visitor.visitForLoop(this)) {
            return true;
        }
        return this.mInit != null && this.mInit.accept(visitor) || this.mCondition != null && this.mCondition.accept(visitor) || this.mStep != null && this.mStep.accept(visitor) || this.mStatement.accept(visitor);
    }

    public Statement getInit() {
        return this.mInit;
    }

    public void setInit(Statement init) {
        this.mInit = init;
    }

    public Expression getCondition() {
        return this.mCondition;
    }

    public void setCondition(Expression condition) {
        this.mCondition = condition;
    }

    public Expression getStep() {
        return this.mStep;
    }

    public void setStep(Expression step) {
        this.mStep = step;
    }

    public Statement getStatement() {
        return this.mStatement;
    }

    public void setStatement(Statement statement) {
        this.mStatement = statement;
    }

    @Override
    @Nonnull
    public String toString() {
        Object result = "for (";
        result = this.mInit != null ? (String)result + this.mInit.toString() : (String)result + ";";
        result = (String)result + " ";
        if (this.mCondition != null) {
            result = (String)result + this.mCondition.toString();
        }
        result = (String)result + "; ";
        if (this.mStep != null) {
            result = (String)result + this.mStep.toString();
        }
        result = (String)result + ") " + this.mStatement.toString();
        return result;
    }
}

