/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import yslelf.cloudpick.render.compiler.Context;
import yslelf.cloudpick.render.compiler.analysis.Analysis;
import yslelf.cloudpick.render.compiler.tree.ConstructorCall;
import yslelf.cloudpick.render.compiler.tree.Expression;
import yslelf.cloudpick.render.compiler.tree.FunctionDecl;
import yslelf.cloudpick.render.compiler.tree.FunctionReference;
import yslelf.cloudpick.render.compiler.tree.Modifiers;
import yslelf.cloudpick.render.compiler.tree.Node;
import yslelf.cloudpick.render.compiler.tree.TreeVisitor;
import yslelf.cloudpick.render.compiler.tree.Type;
import yslelf.cloudpick.render.compiler.tree.TypeReference;

public final class FunctionCall
extends Expression {
    private final FunctionDecl mFunction;
    private final Expression[] mArguments;

    private FunctionCall(int position, Type type, FunctionDecl function, Expression ... arguments) {
        super(position, type);
        this.mFunction = function;
        this.mArguments = arguments;
    }

    private static String buildArgumentTypeList(List<Expression> arguments) {
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        for (Expression arg : arguments) {
            joiner.add(arg.getType().toString());
        }
        return joiner.toString();
    }

    @Nullable
    private static FunctionDecl findBestCandidate(@Nonnull FunctionDecl chain, @Nonnull List<Expression> arguments) {
        if (chain.getNextOverload() == null) {
            return chain;
        }
        long bestCost = Type.CoercionCost.saturate();
        FunctionDecl best = null;
        for (FunctionDecl f2 = chain; f2 != null; f2 = f2.getNextOverload()) {
            long cost;
            if (f2.getParameters().size() != arguments.size()) {
                cost = Type.CoercionCost.saturate();
            } else {
                ArrayList<Type> paramTypes = new ArrayList<Type>();
                if (f2.resolveParameterTypes(arguments, paramTypes) == null) {
                    cost = Type.CoercionCost.saturate();
                } else {
                    long total = Type.CoercionCost.free();
                    for (int i = 0; i < arguments.size(); ++i) {
                        total = Type.CoercionCost.plus(total, arguments.get(i).getCoercionCost((Type)paramTypes.get(i)));
                    }
                    cost = total;
                }
            }
            if (Type.CoercionCost.compare(cost, bestCost) > 0) continue;
            bestCost = cost;
            best = f2;
        }
        return Type.CoercionCost.accept(bestCost, false) ? best : null;
    }

    @Nullable
    public static Expression convert(@Nonnull Context context, int pos, @Nonnull Expression identifier, @Nonnull List<Expression> arguments) {
        return switch (identifier.getKind()) {
            case Node.ExpressionKind.TYPE_REFERENCE -> {
                TypeReference ref = (TypeReference)identifier;
                yield ConstructorCall.convert(context, pos, ref.getValue(), arguments);
            }
            case Node.ExpressionKind.FUNCTION_REFERENCE -> {
                FunctionReference ref = (FunctionReference)identifier;
                FunctionDecl best = FunctionCall.findBestCandidate(ref.getOverloadChain(), arguments);
                if (best != null) {
                    yield FunctionCall.convert(context, pos, best, arguments);
                }
                String msg = "no candidate found for function call " + ref.getOverloadChain().getName() + FunctionCall.buildArgumentTypeList(arguments);
                context.error(pos, msg);
                yield null;
            }
            case Node.ExpressionKind.POISON -> {
                identifier.mPosition = pos;
                yield identifier;
            }
            default -> {
                context.error(pos, "not an invocation");
                yield null;
            }
        };
    }

    @Nullable
    public static Expression convert(@Nonnull Context context, int pos, @Nonnull FunctionDecl function, @Nonnull List<Expression> arguments) {
        if (function.getParameters().size() != arguments.size()) {
            String msg = "call to '" + function.getName() + "' expected " + function.getParameters().size() + " argument";
            if (function.getParameters().size() != 1) {
                msg = msg + "s";
            }
            msg = msg + ", but found " + arguments.size();
            context.error(pos, msg);
            return null;
        }
        ArrayList<Type> paramTypes = new ArrayList<Type>();
        Type returnType = function.resolveParameterTypes(arguments, paramTypes);
        if (returnType == null) {
            String msg = "no match for " + function.getName() + FunctionCall.buildArgumentTypeList(arguments);
            context.error(pos, msg);
            return null;
        }
        for (int i = 0; i < arguments.size(); ++i) {
            int refKind;
            arguments.set(i, ((Type)paramTypes.get(i)).coerceExpression(context, arguments.get(i)));
            if (arguments.get(i) == null) {
                return null;
            }
            Modifiers paramFlags = function.getParameters().get(i).getModifiers();
            if ((paramFlags.flags() & 0x40) == 0) continue;
            int n2 = refKind = (paramFlags.flags() & 0x20) != 0 ? 2 : 3;
            if (Analysis.updateVariableRefKind(arguments.get(i), refKind)) continue;
            return null;
        }
        if (function.isEntryPoint()) {
            context.error(pos, "call to entry point is not allowed");
            return null;
        }
        return FunctionCall.make(pos, returnType, function, arguments);
    }

    public static Expression make(int pos, Type returnType, FunctionDecl function, List<Expression> arguments) {
        assert (function.getParameters().size() == arguments.size());
        return new FunctionCall(pos, returnType, function, arguments.toArray(new Expression[0]));
    }

    @Override
    public Node.ExpressionKind getKind() {
        return Node.ExpressionKind.FUNCTION_CALL;
    }

    @Override
    public boolean accept(@Nonnull TreeVisitor visitor) {
        if (visitor.visitFunctionCall(this)) {
            return true;
        }
        for (Expression arg : this.mArguments) {
            if (!arg.accept(visitor)) continue;
            return true;
        }
        return false;
    }

    public FunctionDecl getFunction() {
        return this.mFunction;
    }

    public @Unmodifiable Expression[] getArguments() {
        return this.mArguments;
    }

    @Override
    @Nonnull
    public Expression clone(int position) {
        Expression[] arguments = (Expression[])this.mArguments.clone();
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = arguments[i].clone();
        }
        return new FunctionCall(position, this.getType(), this.mFunction, arguments);
    }

    @Override
    @Nonnull
    public String toString(int parentPrecedence) {
        StringJoiner joiner = new StringJoiner(", ");
        for (Expression arg : this.mArguments) {
            joiner.add(arg.toString(17));
        }
        return this.mFunction.getName() + "(" + joiner + ")";
    }
}

