/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.tree;

import javax.annotation.Nonnull;
import yslelf.cloudpick.render.compiler.Context;
import yslelf.cloudpick.render.compiler.tree.BlockStatement;
import yslelf.cloudpick.render.compiler.tree.FunctionDecl;
import yslelf.cloudpick.render.compiler.tree.Node;
import yslelf.cloudpick.render.compiler.tree.Statement;
import yslelf.cloudpick.render.compiler.tree.TopLevelElement;
import yslelf.cloudpick.render.compiler.tree.TreeVisitor;

public final class FunctionDefinition
extends TopLevelElement {
    private final FunctionDecl mFunctionDecl;
    private final boolean mBuiltin;
    private BlockStatement mBody;

    private FunctionDefinition(int position, FunctionDecl functionDecl, boolean builtin, BlockStatement body) {
        super(position);
        this.mFunctionDecl = functionDecl;
        this.mBuiltin = builtin;
        this.mBody = body;
    }

    public static FunctionDefinition convert(@Nonnull Context context, int pos, FunctionDecl functionDecl, boolean builtin, Statement body) {
        BlockStatement block;
        if (functionDecl.isIntrinsic()) {
            context.error(pos, "Intrinsic function '" + functionDecl.getName() + "' should not have a definition");
            return null;
        }
        if (body == null || !(body instanceof BlockStatement) || !(block = (BlockStatement)body).isScoped()) {
            context.error(pos, "function body '" + functionDecl + "' must be a braced block");
            return null;
        }
        if (functionDecl.getDefinition() != null) {
            context.error(pos, "function '" + functionDecl + "' was already defined");
            return null;
        }
        return FunctionDefinition.make(pos, functionDecl, builtin, block);
    }

    public static FunctionDefinition make(int pos, FunctionDecl functionDecl, boolean builtin, BlockStatement body) {
        return new FunctionDefinition(pos, functionDecl, builtin, body);
    }

    public FunctionDecl getFunctionDecl() {
        return this.mFunctionDecl;
    }

    public boolean isBuiltin() {
        return this.mBuiltin;
    }

    public BlockStatement getBody() {
        return this.mBody;
    }

    public void setBody(BlockStatement body) {
        this.mBody = body;
    }

    @Override
    public Node.ElementKind getKind() {
        return Node.ElementKind.FUNCTION_DEFINITION;
    }

    @Override
    public boolean accept(@Nonnull TreeVisitor visitor) {
        if (visitor.visitFunctionDefinition(this)) {
            return true;
        }
        return this.mBody.accept(visitor);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.mFunctionDecl.toString() + " " + this.mBody.toString();
    }
}

