/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.tree;

import javax.annotation.Nonnull;
import yslelf.cloudpick.render.compiler.Context;
import yslelf.cloudpick.render.compiler.tree.Expression;
import yslelf.cloudpick.render.compiler.tree.FunctionDecl;
import yslelf.cloudpick.render.compiler.tree.Node;
import yslelf.cloudpick.render.compiler.tree.TreeVisitor;
import yslelf.cloudpick.render.compiler.tree.Type;

public final class FunctionReference
extends Expression {
    private final FunctionDecl mOverloadChain;

    private FunctionReference(int position, FunctionDecl overloadChain, Type type) {
        super(position, type);
        this.mOverloadChain = overloadChain;
    }

    @Nonnull
    public static Expression make(@Nonnull Context context, int position, FunctionDecl overloadChain) {
        return new FunctionReference(position, overloadChain, context.getTypes().mInvalid);
    }

    @Override
    public Node.ExpressionKind getKind() {
        return Node.ExpressionKind.FUNCTION_REFERENCE;
    }

    @Override
    public boolean accept(@Nonnull TreeVisitor visitor) {
        return visitor.visitFunctionReference(this);
    }

    public FunctionDecl getOverloadChain() {
        return this.mOverloadChain;
    }

    @Override
    @Nonnull
    public Expression clone(int position) {
        return new FunctionReference(position, this.mOverloadChain, this.getType());
    }

    @Override
    @Nonnull
    public String toString(int parentPrecedence) {
        return "<function>";
    }
}

