/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.tree;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.compiler.Context;
import yslelf.cloudpick.render.compiler.tree.Expression;
import yslelf.cloudpick.render.compiler.tree.Node;
import yslelf.cloudpick.render.compiler.tree.Statement;
import yslelf.cloudpick.render.compiler.tree.TreeVisitor;

public final class IfStatement
extends Statement {
    private Expression mCondition;
    private Statement mWhenTrue;
    private Statement mWhenFalse;

    public IfStatement(int position, Expression condition, Statement whenTrue, Statement whenFalse) {
        super(position);
        this.mCondition = condition;
        this.mWhenTrue = whenTrue;
        this.mWhenFalse = whenFalse;
    }

    @Nullable
    public static Statement convert(@Nonnull Context context, int position, Expression condition, Statement whenTrue, Statement whenFalse) {
        if ((condition = context.getTypes().mBool.coerceExpression(context, condition)) == null) {
            return null;
        }
        return IfStatement.make(position, condition, whenTrue, whenFalse);
    }

    public static Statement make(int position, Expression condition, Statement whenTrue, Statement whenFalse) {
        return new IfStatement(position, condition, whenTrue, whenFalse);
    }

    @Override
    public Node.StatementKind getKind() {
        return Node.StatementKind.IF;
    }

    @Override
    public boolean accept(@Nonnull TreeVisitor visitor) {
        if (visitor.visitIf(this)) {
            return true;
        }
        return this.mCondition != null && this.mCondition.accept(visitor) || this.mWhenTrue != null && this.mWhenTrue.accept(visitor) || this.mWhenFalse != null && this.mWhenFalse.accept(visitor);
    }

    public Expression getCondition() {
        return this.mCondition;
    }

    public void setCondition(Expression condition) {
        this.mCondition = condition;
    }

    public Statement getWhenTrue() {
        return this.mWhenTrue;
    }

    public void setWhenTrue(Statement whenTrue) {
        this.mWhenTrue = whenTrue;
    }

    public Statement getWhenFalse() {
        return this.mWhenFalse;
    }

    public void setWhenFalse(Statement whenFalse) {
        this.mWhenFalse = whenFalse;
    }

    @Override
    @Nonnull
    public String toString() {
        String result = "if (" + this.mCondition.toString() + ") " + this.mWhenTrue.toString();
        if (this.mWhenFalse != null) {
            result = result + " else " + this.mWhenFalse;
        }
        return result;
    }
}

