/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.tree;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.compiler.ConstantFolder;
import yslelf.cloudpick.render.compiler.Context;
import yslelf.cloudpick.render.compiler.tree.Expression;
import yslelf.cloudpick.render.compiler.tree.Literal;
import yslelf.cloudpick.render.compiler.tree.Node;
import yslelf.cloudpick.render.compiler.tree.TreeVisitor;
import yslelf.cloudpick.render.compiler.tree.Type;
import yslelf.cloudpick.render.compiler.tree.TypeReference;

public final class IndexExpression
extends Expression {
    private Expression mBase;
    private Expression mIndex;

    private IndexExpression(int position, Expression base, Expression index) {
        super(position, base.getType().getElementType());
        this.mBase = base;
        this.mIndex = index;
    }

    private IndexExpression(int position, Type type, Expression base, Expression index) {
        super(position, type);
        this.mBase = base;
        this.mIndex = index;
    }

    private static boolean index_out_of_bounds(@Nonnull Context context, int pos, long index, @Nonnull Expression base) {
        Type baseType = base.getType();
        if (index >= 0L) {
            if (baseType.isArray()) {
                if (baseType.isUnsizedArray()) {
                    return false;
                }
                if (index < (long)baseType.getArraySize()) {
                    return false;
                }
            } else if (baseType.isMatrix()) {
                if (index < (long)baseType.getCols()) {
                    return false;
                }
            } else {
                assert (baseType.isVector());
                if (index < (long)baseType.getRows()) {
                    return false;
                }
            }
        }
        context.error(pos, "index " + index + " out of range for '" + baseType + "'");
        return true;
    }

    @Nullable
    public static Expression convert(@Nonnull Context context, int pos, @Nonnull Expression base, @Nullable Expression index) {
        if (base instanceof TypeReference) {
            Type baseType = ((TypeReference)base).getValue();
            int arraySize = index != null ? baseType.convertArraySize(context, pos, index) : -1;
            if (arraySize == 0) {
                return null;
            }
            return TypeReference.make(context, pos, context.getSymbolTable().getArrayType(baseType, arraySize));
        }
        if (index == null) {
            context.error(pos, "missing index in '[]'");
            return null;
        }
        Type baseType = base.getType();
        if (!(baseType.isArray() || baseType.isMatrix() || baseType.isVector())) {
            context.error(base.mPosition, "expected array, matrix or vector, but found '" + baseType + "'");
            return null;
        }
        if (!index.getType().isInteger() && (index = context.getTypes().mInt.coerceExpression(context, index)) == null) {
            return null;
        }
        Expression indexExpr = ConstantFolder.getConstantValueForVariable(index);
        if (indexExpr.isIntLiteral()) {
            long indexValue = ((Literal)indexExpr).getIntegerValue();
            if (IndexExpression.index_out_of_bounds(context, index.mPosition, indexValue, base)) {
                return null;
            }
            Expression baseExpr = ConstantFolder.getConstantValueOrNullForVariable(base);
            if (baseExpr != null) {
                // empty if block
            }
        }
        return IndexExpression.make(context, pos, base, index);
    }

    public static Expression make(@Nonnull Context context, int pos, @Nonnull Expression base, @Nonnull Expression index) {
        return new IndexExpression(pos, base, index);
    }

    public Expression getBase() {
        return this.mBase;
    }

    public void setBase(Expression base) {
        this.mBase = base;
    }

    public Expression getIndex() {
        return this.mIndex;
    }

    public void setIndex(Expression index) {
        this.mIndex = index;
    }

    @Override
    public Node.ExpressionKind getKind() {
        return Node.ExpressionKind.INDEX;
    }

    @Override
    public boolean accept(@Nonnull TreeVisitor visitor) {
        if (visitor.visitIndex(this)) {
            return true;
        }
        return this.mBase.accept(visitor) || this.mIndex.accept(visitor);
    }

    @Override
    @Nonnull
    public Expression clone(int position) {
        return new IndexExpression(position, this.getType(), this.mBase.clone(), this.mIndex.clone());
    }

    @Override
    @Nonnull
    public String toString(int parentPrecedence) {
        return this.mBase.toString(2) + "[" + this.mIndex.toString(17) + "]";
    }
}

