/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.tree;

import javax.annotation.Nonnull;
import yslelf.cloudpick.render.compiler.Position;
import yslelf.cloudpick.render.compiler.tree.AnonymousField;
import yslelf.cloudpick.render.compiler.tree.BinaryExpression;
import yslelf.cloudpick.render.compiler.tree.BlockStatement;
import yslelf.cloudpick.render.compiler.tree.BreakStatement;
import yslelf.cloudpick.render.compiler.tree.ConditionalExpression;
import yslelf.cloudpick.render.compiler.tree.ConstructorArray;
import yslelf.cloudpick.render.compiler.tree.ConstructorArrayCast;
import yslelf.cloudpick.render.compiler.tree.ConstructorCompound;
import yslelf.cloudpick.render.compiler.tree.ConstructorCompoundCast;
import yslelf.cloudpick.render.compiler.tree.ConstructorDiagonalMatrix;
import yslelf.cloudpick.render.compiler.tree.ConstructorMatrixResize;
import yslelf.cloudpick.render.compiler.tree.ConstructorScalarCast;
import yslelf.cloudpick.render.compiler.tree.ConstructorStruct;
import yslelf.cloudpick.render.compiler.tree.ConstructorVectorSplat;
import yslelf.cloudpick.render.compiler.tree.ContinueStatement;
import yslelf.cloudpick.render.compiler.tree.DiscardStatement;
import yslelf.cloudpick.render.compiler.tree.EmptyStatement;
import yslelf.cloudpick.render.compiler.tree.Expression;
import yslelf.cloudpick.render.compiler.tree.ExpressionStatement;
import yslelf.cloudpick.render.compiler.tree.FieldAccess;
import yslelf.cloudpick.render.compiler.tree.ForLoop;
import yslelf.cloudpick.render.compiler.tree.FunctionCall;
import yslelf.cloudpick.render.compiler.tree.FunctionDecl;
import yslelf.cloudpick.render.compiler.tree.FunctionDefinition;
import yslelf.cloudpick.render.compiler.tree.FunctionPrototype;
import yslelf.cloudpick.render.compiler.tree.FunctionReference;
import yslelf.cloudpick.render.compiler.tree.GlobalVariableDecl;
import yslelf.cloudpick.render.compiler.tree.IfStatement;
import yslelf.cloudpick.render.compiler.tree.IndexExpression;
import yslelf.cloudpick.render.compiler.tree.InterfaceBlock;
import yslelf.cloudpick.render.compiler.tree.Literal;
import yslelf.cloudpick.render.compiler.tree.Poison;
import yslelf.cloudpick.render.compiler.tree.PostfixExpression;
import yslelf.cloudpick.render.compiler.tree.PrefixExpression;
import yslelf.cloudpick.render.compiler.tree.ReturnStatement;
import yslelf.cloudpick.render.compiler.tree.Statement;
import yslelf.cloudpick.render.compiler.tree.StructDefinition;
import yslelf.cloudpick.render.compiler.tree.SwitchCase;
import yslelf.cloudpick.render.compiler.tree.SwitchStatement;
import yslelf.cloudpick.render.compiler.tree.Swizzle;
import yslelf.cloudpick.render.compiler.tree.Symbol;
import yslelf.cloudpick.render.compiler.tree.TopLevelElement;
import yslelf.cloudpick.render.compiler.tree.TreeVisitor;
import yslelf.cloudpick.render.compiler.tree.Type;
import yslelf.cloudpick.render.compiler.tree.TypeReference;
import yslelf.cloudpick.render.compiler.tree.Variable;
import yslelf.cloudpick.render.compiler.tree.VariableDecl;
import yslelf.cloudpick.render.compiler.tree.VariableReference;

public abstract class Node {
    public int mPosition;

    protected Node(int position) {
        this.mPosition = position;
    }

    public final int getStartOffset() {
        assert (this.mPosition != -1);
        return Position.getStartOffset(this.mPosition);
    }

    public final int getEndOffset() {
        assert (this.mPosition != -1);
        return Position.getEndOffset(this.mPosition);
    }

    public abstract boolean accept(@Nonnull TreeVisitor var1);

    @Nonnull
    public abstract String toString();

    public static enum ExpressionKind {
        BINARY(BinaryExpression.class),
        CONDITIONAL(ConditionalExpression.class),
        CONSTRUCTOR_ARRAY(ConstructorArray.class),
        CONSTRUCTOR_ARRAY_CAST(ConstructorArrayCast.class),
        CONSTRUCTOR_COMPOUND(ConstructorCompound.class),
        CONSTRUCTOR_COMPOUND_CAST(ConstructorCompoundCast.class),
        CONSTRUCTOR_DIAGONAL_MATRIX(ConstructorDiagonalMatrix.class),
        CONSTRUCTOR_MATRIX_RESIZE(ConstructorMatrixResize.class),
        CONSTRUCTOR_SCALAR_CAST(ConstructorScalarCast.class),
        CONSTRUCTOR_STRUCT(ConstructorStruct.class),
        CONSTRUCTOR_VECTOR_SPLAT(ConstructorVectorSplat.class),
        FIELD_ACCESS(FieldAccess.class),
        FUNCTION_CALL(FunctionCall.class),
        FUNCTION_REFERENCE(FunctionReference.class),
        INDEX(IndexExpression.class),
        LITERAL(Literal.class),
        POISON(Poison.class),
        POSTFIX(PostfixExpression.class),
        PREFIX(PrefixExpression.class),
        SWIZZLE(Swizzle.class),
        TYPE_REFERENCE(TypeReference.class),
        VARIABLE_REFERENCE(VariableReference.class);

        private final Class<? extends Expression> mType;

        private ExpressionKind(Class<? extends Expression> type) {
            this.mType = type;
        }

        public Class<? extends Expression> getType() {
            return this.mType;
        }
    }

    public static enum StatementKind {
        BLOCK(BlockStatement.class),
        BREAK(BreakStatement.class),
        CONTINUE(ContinueStatement.class),
        DISCARD(DiscardStatement.class),
        DO_LOOP(Statement.class),
        EMPTY(EmptyStatement.class),
        EXPRESSION(ExpressionStatement.class),
        FOR_LOOP(ForLoop.class),
        IF(IfStatement.class),
        RETURN(ReturnStatement.class),
        SWITCH(SwitchStatement.class),
        SWITCH_CASE(SwitchCase.class),
        VARIABLE_DECL(VariableDecl.class);

        private final Class<? extends Statement> mType;

        private StatementKind(Class<? extends Statement> type) {
            this.mType = type;
        }

        public Class<? extends Statement> getType() {
            return this.mType;
        }
    }

    public static enum SymbolKind {
        ANONYMOUS_FIELD(AnonymousField.class),
        FUNCTION_DECL(FunctionDecl.class),
        TYPE(Type.class),
        VARIABLE(Variable.class);

        private final Class<? extends Symbol> mType;

        private SymbolKind(Class<? extends Symbol> type) {
            this.mType = type;
        }

        public Class<? extends Symbol> getType() {
            return this.mType;
        }
    }

    public static enum ElementKind {
        EXTENSION(TopLevelElement.class),
        FUNCTION_DEFINITION(FunctionDefinition.class),
        FUNCTION_PROTOTYPE(FunctionPrototype.class),
        GLOBAL_VARIABLE(GlobalVariableDecl.class),
        INTERFACE_BLOCK(InterfaceBlock.class),
        MODIFIERS(TopLevelElement.class),
        STRUCT_DEFINITION(StructDefinition.class);

        private final Class<? extends TopLevelElement> mType;

        private ElementKind(Class<? extends TopLevelElement> type) {
            this.mType = type;
        }

        public Class<? extends TopLevelElement> getType() {
            return this.mType;
        }
    }
}

