/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.tree;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.compiler.tree.Expression;
import yslelf.cloudpick.render.compiler.tree.Node;
import yslelf.cloudpick.render.compiler.tree.Statement;
import yslelf.cloudpick.render.compiler.tree.TreeVisitor;

public final class ReturnStatement
extends Statement {
    @Nullable
    private Expression mExpression;

    private ReturnStatement(int position, @Nullable Expression expression) {
        super(position);
        this.mExpression = expression;
    }

    public static Statement make(int pos, @Nullable Expression expression) {
        return new ReturnStatement(pos, expression);
    }

    @Nullable
    public Expression getExpression() {
        return this.mExpression;
    }

    public void setExpression(@Nullable Expression expression) {
        this.mExpression = expression;
    }

    @Override
    public Node.StatementKind getKind() {
        return Node.StatementKind.RETURN;
    }

    @Override
    public boolean accept(@Nonnull TreeVisitor visitor) {
        if (visitor.visitReturn(this)) {
            return true;
        }
        return this.mExpression != null && this.mExpression.accept(visitor);
    }

    @Override
    @Nonnull
    public String toString() {
        if (this.mExpression != null) {
            return "return " + this.mExpression + ";";
        }
        return "return;";
    }
}

