/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.tree;

import javax.annotation.Nonnull;
import yslelf.cloudpick.render.compiler.tree.Node;
import yslelf.cloudpick.render.compiler.tree.Statement;
import yslelf.cloudpick.render.compiler.tree.TreeVisitor;

public final class SwitchCase
extends Statement {
    private final boolean mIsDefault;
    private final long mValue;
    private Statement mStatement;

    private SwitchCase(int position, boolean isDefault, long value, Statement statement) {
        super(position);
        this.mIsDefault = isDefault;
        this.mValue = value;
        this.mStatement = statement;
    }

    @Nonnull
    public static SwitchCase make(int position, long value, Statement statement) {
        return new SwitchCase(position, false, value, statement);
    }

    @Nonnull
    public static SwitchCase makeDefault(int position, Statement statement) {
        return new SwitchCase(position, true, -1L, statement);
    }

    public boolean isDefault() {
        return this.mIsDefault;
    }

    public long getValue() {
        return this.mValue;
    }

    public Statement getStatement() {
        return this.mStatement;
    }

    public void setStatement(Statement statement) {
        this.mStatement = statement;
    }

    @Override
    public Node.StatementKind getKind() {
        return Node.StatementKind.SWITCH_CASE;
    }

    @Override
    public boolean accept(@Nonnull TreeVisitor visitor) {
        if (visitor.visitSwitchCase(this)) {
            return true;
        }
        return this.mStatement.accept(visitor);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.mIsDefault ? "default: \n" + this.mStatement : "case " + this.mValue + ": \n" + this.mStatement;
    }
}

