/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.compiler.tree;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalLong;
import javax.annotation.Nonnull;
import yslelf.cloudpick.render.compiler.ConstantFolder;
import yslelf.cloudpick.render.compiler.Context;
import yslelf.cloudpick.render.compiler.tree.BlockStatement;
import yslelf.cloudpick.render.compiler.tree.Expression;
import yslelf.cloudpick.render.compiler.tree.Node;
import yslelf.cloudpick.render.compiler.tree.Statement;
import yslelf.cloudpick.render.compiler.tree.SwitchCase;
import yslelf.cloudpick.render.compiler.tree.TreeVisitor;

public final class SwitchStatement
extends Statement {
    private Expression mInit;
    private Statement mCaseBlock;

    public SwitchStatement(int position, Expression init, Statement caseBlock) {
        super(position);
        this.mInit = init;
        this.mCaseBlock = caseBlock;
    }

    public static Statement convert(Context context, int position, Expression init, List<Expression> caseValues, List<Statement> caseStatements) {
        assert (caseValues.size() == caseStatements.size());
        if ((init = context.getTypes().mInt.coerceExpression(context, init)) == null) {
            return null;
        }
        ArrayList<Statement> cases = new ArrayList<Statement>();
        for (int i = 0; i < caseValues.size(); ++i) {
            if (caseValues.get(i) != null) {
                int casePos = caseValues.get((int)i).mPosition;
                Expression caseValue = init.getType().coerceExpression(context, caseValues.get(i));
                if (caseValue == null) {
                    return null;
                }
                OptionalLong intValue = ConstantFolder.getConstantInt(caseValue);
                if (intValue.isEmpty()) {
                    context.error(casePos, "case value must be a constant integer");
                    return null;
                }
                cases.add(SwitchCase.make(casePos, intValue.getAsLong(), caseStatements.get(i)));
                continue;
            }
            cases.add(SwitchCase.makeDefault(position, caseStatements.get(i)));
        }
        List<SwitchCase> duplicateCases = SwitchStatement.find_duplicate_cases(cases);
        if (!duplicateCases.isEmpty()) {
            for (SwitchCase sc : duplicateCases) {
                if (sc.isDefault()) {
                    context.error(sc.mPosition, "duplicate default case");
                    continue;
                }
                context.error(sc.mPosition, "duplicate case value '" + sc.getValue() + "'");
            }
            return null;
        }
        Statement switchStmt = SwitchStatement.make(context, position, init, BlockStatement.makeBlock(position, cases));
        return switchStmt;
    }

    public static Statement make(Context context, int position, Expression init, Statement caseBlock) {
        return new SwitchStatement(position, init, caseBlock);
    }

    private static List<SwitchCase> find_duplicate_cases(List<Statement> cases) {
        ArrayList<SwitchCase> duplicateCases = new ArrayList<SwitchCase>();
        LongOpenHashSet intValues = new LongOpenHashSet();
        boolean foundDefault = false;
        for (Statement stmt : cases) {
            SwitchCase sc = (SwitchCase)stmt;
            if (sc.isDefault()) {
                if (foundDefault) {
                    duplicateCases.add(sc);
                    continue;
                }
                foundDefault = true;
                continue;
            }
            if (intValues.add(sc.getValue())) continue;
            duplicateCases.add(sc);
        }
        return duplicateCases;
    }

    public Expression getInit() {
        return this.mInit;
    }

    public void setInit(Expression init) {
        this.mInit = init;
    }

    public Statement getCaseBlock() {
        return this.mCaseBlock;
    }

    public void setCaseBlock(Statement caseBlock) {
        this.mCaseBlock = caseBlock;
    }

    public List<Statement> getCases() {
        return ((BlockStatement)this.mCaseBlock).getStatements();
    }

    @Override
    public Node.StatementKind getKind() {
        return Node.StatementKind.SWITCH;
    }

    @Override
    public boolean accept(@Nonnull TreeVisitor visitor) {
        if (visitor.visitSwitch(this)) {
            return true;
        }
        return this.mInit.accept(visitor) || this.mCaseBlock.accept(visitor);
    }

    @Override
    @Nonnull
    public String toString() {
        return "switch (" + this.mInit + ") " + this.mCaseBlock;
    }
}

