/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.render.core.BlendMode;
import yslelf.cloudpick.render.core.Blender;
import yslelf.cloudpick.render.core.ColorInt;
import yslelf.cloudpick.render.core.Device;
import yslelf.cloudpick.render.core.Font;
import yslelf.cloudpick.render.core.GlyphRunBuilder;
import yslelf.cloudpick.render.core.GlyphRunList;
import yslelf.cloudpick.render.core.Image;
import yslelf.cloudpick.render.core.ImageFilter;
import yslelf.cloudpick.render.core.ImageInfo;
import yslelf.cloudpick.render.core.MathUtil;
import yslelf.cloudpick.render.core.Matrix;
import yslelf.cloudpick.render.core.Matrix4;
import yslelf.cloudpick.render.core.Matrix4c;
import yslelf.cloudpick.render.core.Matrixc;
import yslelf.cloudpick.render.core.NoPixelsDevice;
import yslelf.cloudpick.render.core.Paint;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.Rect2f;
import yslelf.cloudpick.render.core.Rect2fc;
import yslelf.cloudpick.render.core.Rect2i;
import yslelf.cloudpick.render.core.Rect2ic;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.RoundRect;
import yslelf.cloudpick.render.core.SamplingOptions;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.core.Surface;
import yslelf.cloudpick.render.core.TextBlob;
import yslelf.cloudpick.render.core.Vertices;
import yslelf.cloudpick.render.engine.RecordingContext;

public class Canvas
implements AutoCloseable {
    public static final int INIT_WITH_PREVIOUS_SAVE_LAYER_FLAG = 4;
    public static final int F16_COLOR_TYPE_SAVE_LAYER_FLAG = 16;
    protected static final int FULL_LAYER_SAVE_LAYER_STRATEGY = 0;
    protected static final int NO_LAYER_SAVE_LAYER_STRATEGY = 1;
    private static final int MAX_MC_POOL_SIZE = 32;
    @SharedPtr
    private Device mRootDevice;
    private final Rect2f mQuickRejectBounds = new Rect2f();
    Surface mSurface;
    private MCRec[] mMCStack = new MCRec[32];
    private int mMCIndex = 0;
    private int mSaveCount;
    private final Rect2f mTmpRect = new Rect2f();
    private final Rect2f mTmpRect2 = new Rect2f();
    private final RoundRect mTmpRoundRect = new RoundRect();
    private final Rect2f mTmpQuickBounds = new Rect2f();
    private final Rect2f mTmpQuickBounds2 = new Rect2f();
    private final Matrix mTmpMatrix = new Matrix();
    private final Matrix4 mTmpMatrix44 = new Matrix4();
    private final Paint mTmpPaint = new Paint();
    private final GlyphRunBuilder mScratchGlyphRunBuilder = new GlyphRunBuilder();
    public static final int POINT_MODE_POINTS = 0;
    public static final int POINT_MODE_LINES = 1;
    public static final int POINT_MODE_POLYGON = 2;
    public static final int SRC_RECT_CONSTRAINT_FAST = 0;
    public static final int SRC_RECT_CONSTRAINT_STRICT = 1;

    public Canvas() {
        this((Device)null);
    }

    public Canvas(int width, int height) {
        this(new NoPixelsDevice(0, 0, Math.max(width, 0), Math.max(height, 0)));
    }

    protected Canvas(@Nonnull Rect2ic bounds) {
        this(new NoPixelsDevice(bounds.isEmpty() ? Rect2i.empty() : bounds));
    }

    @ApiStatus.Internal
    public Canvas(@SharedPtr Device device) {
        if (device == null) {
            device = new NoPixelsDevice(Rect2i.empty());
        }
        this.mSaveCount = 1;
        this.mMCStack[0] = new MCRec(device);
        this.mRootDevice = device;
        this.computeQuickRejectBounds();
    }

    @Nonnull
    public final ImageInfo getImageInfo() {
        return this.onGetImageInfo();
    }

    public int getBaseLayerWidth() {
        return this.mRootDevice.getWidth();
    }

    public int getBaseLayerHeight() {
        return this.mRootDevice.getHeight();
    }

    @Nullable
    @SharedPtr
    public final Surface makeSurface(ImageInfo info) {
        return this.onNewSurface(info);
    }

    @Nullable
    @RawPtr
    public RecordingContext getRecordingContext() {
        return this.topDevice().getRecordingContext();
    }

    @Nullable
    @RawPtr
    public final Surface getSurface() {
        return this.mSurface;
    }

    public final int save() {
        int i = this.mSaveCount++;
        ++this.top().mDeferredSaveCount;
        return i;
    }

    public final int saveLayer(@Nullable Rect2f bounds, @Nullable Paint paint) {
        return this.saveLayer(bounds, paint, null, 0);
    }

    public final int saveLayer(float left, float top, float right, float bottom, @Nullable Paint paint) {
        this.mTmpRect.set(left, top, right, bottom);
        return this.saveLayer(this.mTmpRect, paint, null, 0);
    }

    public final int saveLayerAlpha(@Nullable Rect2f bounds, int alpha) {
        if ((alpha = MathUtil.clamp(alpha, 0, 255)) == 255) {
            return this.saveLayer(bounds, null, null, 0);
        }
        this.mTmpPaint.setAlpha(alpha);
        int i = this.saveLayer(bounds, this.mTmpPaint, null, 0);
        this.mTmpPaint.reset();
        return i;
    }

    public final int saveLayerAlpha(float left, float top, float right, float bottom, int alpha) {
        this.mTmpRect.set(left, top, right, bottom);
        return this.saveLayerAlpha(this.mTmpRect, alpha);
    }

    public final int saveLayer(@Nullable Rect2f bounds, @Nullable Paint paint, @Nullable ImageFilter backdrop, int saveLayerFlags) {
        if (paint != null && paint.nothingToDraw()) {
            int i = this.save();
            this.clipRect(0.0f, 0.0f, 0.0f, 0.0f);
            return i;
        }
        int strategy = this.getSaveLayerStrategy(bounds, paint, backdrop, saveLayerFlags);
        int i = this.mSaveCount++;
        this.internalSaveLayer(bounds, paint, backdrop, saveLayerFlags, strategy);
        return i;
    }

    public final int saveLayer(float left, float top, float right, float bottom, @Nullable Paint paint, @Nullable ImageFilter backdrop, int saveLayerFlags) {
        this.mTmpRect.set(left, top, right, bottom);
        return this.saveLayer(this.mTmpRect, paint, backdrop, saveLayerFlags);
    }

    public final void restore() {
        if (this.top().mDeferredSaveCount > 0) {
            assert (this.mSaveCount > 1);
            --this.mSaveCount;
            --this.top().mDeferredSaveCount;
        } else if (this.mMCIndex > 0) {
            this.willRestore();
            assert (this.mSaveCount > 1);
            --this.mSaveCount;
            this.internalRestore();
            this.didRestore();
        } else {
            throw new IllegalStateException("Stack underflow");
        }
    }

    public final int getSaveCount() {
        return this.mSaveCount;
    }

    public final void restoreToCount(int saveCount) {
        if (saveCount < 1) {
            throw new IllegalStateException("Stack underflow");
        }
        int n2 = this.mSaveCount - saveCount;
        for (int i = 0; i < n2; ++i) {
            this.restore();
        }
    }

    public final void translate(float dx, float dy) {
        if (dx != 0.0f || dy != 0.0f) {
            this.checkForDeferredSave();
            Matrix4 transform = this.top().mMatrix;
            transform.preTranslate(dx, dy);
            this.topDevice().setGlobalCTM(transform);
            this.didTranslate(dx, dy, 0.0f);
        }
    }

    public final void translate(float dx, float dy, float dz) {
        if (dx != 0.0f || dy != 0.0f || dz != 0.0f) {
            this.checkForDeferredSave();
            Matrix4 transform = this.top().mMatrix;
            transform.preTranslate(dx, dy, dz);
            this.topDevice().setGlobalCTM(transform);
            this.didTranslate(dx, dy, dz);
        }
    }

    public final void scale(float sx, float sy) {
        if (sx != 1.0f || sy != 1.0f) {
            this.checkForDeferredSave();
            Matrix4 transform = this.top().mMatrix;
            transform.preScale(sx, sy);
            this.topDevice().setGlobalCTM(transform);
            this.didScale(sx, sy, 1.0f);
        }
    }

    public final void scale(float sx, float sy, float sz) {
        if (sx != 1.0f || sy != 1.0f || sz != 1.0f) {
            this.checkForDeferredSave();
            Matrix4 transform = this.top().mMatrix;
            transform.preScale(sx, sy, sz);
            this.topDevice().setGlobalCTM(transform);
            this.didScale(sx, sy, sz);
        }
    }

    public final void scale(float sx, float sy, float px, float py) {
        if (sx != 1.0f || sy != 1.0f) {
            this.mTmpMatrix.setScale(sx, sy, px, py);
            this.concat(this.mTmpMatrix);
        }
    }

    public final void rotate(float degrees) {
        if (degrees != 0.0f) {
            this.mTmpMatrix.setRotate(degrees * ((float)Math.PI / 180));
            this.concat(this.mTmpMatrix);
        }
    }

    public final void rotate(float degrees, float px, float py) {
        if (degrees != 0.0f) {
            this.mTmpMatrix.setRotate(degrees * ((float)Math.PI / 180), px, py);
            this.concat(this.mTmpMatrix);
        }
    }

    public final void shear(float sx, float sy) {
        this.mTmpMatrix.setShear(sx, sy);
        this.concat(this.mTmpMatrix);
    }

    public final void shear(float sx, float sy, float px, float py) {
        this.mTmpMatrix.setShear(sx, sy, px, py);
        this.concat(this.mTmpMatrix);
    }

    public final void concat(@Nonnull Matrixc matrix) {
        if (matrix.isIdentity()) {
            return;
        }
        matrix.toMatrix4(this.mTmpMatrix44);
        this.concat(this.mTmpMatrix44);
    }

    public final void concat(@Nonnull Matrix4c matrix) {
        this.checkForDeferredSave();
        Matrix4 transform = this.top().mMatrix;
        transform.preConcat(matrix);
        this.topDevice().setGlobalCTM(transform);
        this.didConcat(matrix);
    }

    public final void setMatrix(@Nonnull Matrix4c matrix) {
        this.checkForDeferredSave();
        Matrix4 transform = this.top().mMatrix;
        transform.set(matrix);
        this.topDevice().setGlobalCTM(transform);
        this.didSetMatrix(matrix);
    }

    public final void resetMatrix() {
        this.mTmpMatrix44.setIdentity();
        this.setMatrix(this.mTmpMatrix44);
    }

    public final void clipRect(Rect2ic rect) {
        this.mTmpRect.set(rect);
        this.clipRect(this.mTmpRect, 1, false);
    }

    public final void clipRect(Rect2fc rect) {
        this.clipRect(rect, 1, false);
    }

    public final void clipRect(float left, float top, float right, float bottom) {
        this.mTmpRect.set(left, top, right, bottom);
        this.clipRect(this.mTmpRect, 1, false);
    }

    public final void clipRect(Rect2fc rect, boolean doAA) {
        this.clipRect(rect, 1, doAA);
    }

    public final void clipRect(float left, float top, float right, float bottom, boolean doAA) {
        this.mTmpRect.set(left, top, right, bottom);
        this.clipRect(this.mTmpRect, 1, doAA);
    }

    public final void clipRect(Rect2ic rect, int clipOp) {
        this.mTmpRect.set(rect);
        this.clipRect(this.mTmpRect, clipOp, false);
    }

    public final void clipRect(Rect2fc rect, int clipOp) {
        this.clipRect(rect, clipOp, false);
    }

    public final void clipRect(float left, float top, float right, float bottom, int clipOp) {
        this.mTmpRect.set(left, top, right, bottom);
        this.clipRect(this.mTmpRect, clipOp, false);
    }

    public final void clipRect(Rect2fc rect, int clipOp, boolean doAA) {
        if (!rect.isFinite()) {
            return;
        }
        this.checkForDeferredSave();
        this.mTmpRect2.set(rect);
        this.mTmpRect2.sort();
        this.onClipRect(this.mTmpRect2, clipOp, doAA);
    }

    public final boolean quickReject(Rect2fc rect) {
        Rect2f devRect = this.mTmpQuickBounds2;
        this.top().mMatrix.mapRect(rect, devRect);
        return !devRect.isFinite() || !devRect.intersects(this.mQuickRejectBounds);
    }

    public final boolean quickReject(float left, float top, float right, float bottom) {
        Rect2f devRect = this.mTmpQuickBounds2;
        this.top().mMatrix.mapRect(left, top, right, bottom, devRect);
        return !devRect.isFinite() || !devRect.intersects(this.mQuickRejectBounds);
    }

    public final boolean getLocalClipBounds(Rect2f bounds) {
        Device device = this.topDevice();
        if (device.isClipEmpty()) {
            bounds.setEmpty();
            return false;
        }
        Matrix inverse = new Matrix();
        this.top().mMatrix.toMatrix(inverse);
        if (!inverse.invert()) {
            bounds.setEmpty();
            return false;
        }
        bounds.set(device.getClipBounds());
        device.getDeviceToGlobal().mapRect(bounds);
        bounds.roundOut(bounds);
        bounds.outset(1.0f, 1.0f);
        inverse.mapRect(bounds);
        return !bounds.isEmpty();
    }

    public final boolean getDeviceClipBounds(Rect2i bounds) {
        Device device = this.topDevice();
        if (device.isClipEmpty()) {
            bounds.setEmpty();
            return false;
        }
        device.getClipBounds(bounds);
        device.getDeviceToGlobal().mapRectOut(bounds, bounds);
        return !bounds.isEmpty();
    }

    public final void clear(@ColorInt int color) {
        this.drawColor(color, BlendMode.SRC);
    }

    public final void clear(float r, float g, float b, float a) {
        this.drawColor(r, g, b, a, BlendMode.SRC);
    }

    public final void discard() {
        this.onDiscard();
    }

    public final void drawColor(@ColorInt int color) {
        this.drawColor(color, BlendMode.SRC_OVER);
    }

    public final void drawColor(float r, float g, float b, float a) {
        this.drawColor(r, g, b, a, BlendMode.SRC_OVER);
    }

    public final void drawColor(@ColorInt int color, BlendMode mode) {
        Paint paint = this.mTmpPaint;
        paint.setColor(color);
        paint.setBlendMode(mode);
        this.drawPaint(paint);
        paint.reset();
    }

    public final void drawColor(float r, float g, float b, float a, BlendMode mode) {
        Paint paint = this.mTmpPaint;
        paint.setColor4f(r, g, b, a);
        paint.setBlendMode(mode);
        this.drawPaint(paint);
        paint.reset();
    }

    public final void drawPaint(Paint paint) {
        this.onDrawPaint(paint);
    }

    public final void drawPoints(int mode, float[] pts, int offset, int count, Paint paint) {
        if (count <= 0) {
            return;
        }
        assert (pts.length >= offset + count * 2);
        int oldStyle = paint.getStyle();
        int oldCap = paint.getStrokeCap();
        paint.setStyle(1);
        if (mode == 0 && oldCap == 0) {
            paint.setStrokeCap(2);
        }
        this.onDrawPoints(mode, pts, offset, count, paint);
        paint.setStyle(oldStyle);
        paint.setStrokeCap(oldCap);
    }

    public final void drawPoint(float x, float y, Paint paint) {
        int oldStyle = paint.getStyle();
        paint.setStyle(0);
        this.drawPoint(x, y, paint.getStrokeCap(), paint.getStrokeWidth(), paint);
        paint.setStyle(oldStyle);
    }

    public final void drawPoint(float x, float y, int cap, float size, Paint paint) {
        if (size >= 0.0f) {
            float radius = size * 0.5f;
            if (cap == 1) {
                this.drawCircle(x, y, radius, paint);
            } else {
                this.drawRect(x - radius, y - radius, x + radius, y + radius, paint);
            }
        }
    }

    public final void drawLine(float x0, float y0, float x1, float y1, Paint paint) {
        int oldStyle = paint.getStyle();
        paint.setStyle(0);
        this.drawLine(x0, y0, x1, y1, paint.getStrokeCap(), paint.getStrokeWidth(), paint);
        paint.setStyle(oldStyle);
    }

    public final void drawLine(float x0, float y0, float x1, float y1, int cap, float width, Paint paint) {
        if (width >= 0.0f) {
            this.onDrawLine(x0, y0, x1, y1, cap, width, paint);
        }
    }

    public final void drawRect(Rect2fc r, Paint paint) {
        this.mTmpRect.set(r);
        this.mTmpRect.sort();
        this.onDrawRect(this.mTmpRect, paint);
    }

    public final void drawRect(Rect2ic r, Paint paint) {
        this.mTmpRect.set(r);
        this.mTmpRect.sort();
        this.onDrawRect(this.mTmpRect, paint);
    }

    public void drawRect(float left, float top, float right, float bottom, Paint paint) {
        this.mTmpRect.set(left, top, right, bottom);
        this.mTmpRect.sort();
        this.onDrawRect(this.mTmpRect, paint);
    }

    public final void drawRoundRect(Rect2fc rect, float radius, Paint paint) {
        this.mTmpRoundRect.setRectXY(rect, radius, radius);
        this.onDrawRoundRect(this.mTmpRoundRect, paint);
    }

    public final void drawRoundRect(float left, float top, float right, float bottom, float radius, Paint paint) {
        this.mTmpRoundRect.setRectXY(left, top, right, bottom, radius, radius);
        this.onDrawRoundRect(this.mTmpRoundRect, paint);
    }

    public final void drawRoundRect(Rect2f rect, float rUL, float rUR, float rLR, float rLL, Paint paint) {
        this.drawRoundRect(rect.mLeft, rect.mTop, rect.mRight, rect.mBottom, rUL, rUR, rLR, rLL, paint);
    }

    public void drawRoundRect(float left, float top, float right, float bottom, float rUL, float rUR, float rLR, float rLL, Paint paint) {
    }

    public void drawRoundRect(RoundRect roundRect, Paint paint) {
        this.onDrawRoundRect(roundRect, paint);
    }

    public final void drawCircle(float cx, float cy, float radius, Paint paint) {
        this.onDrawCircle(cx, cy, Math.max(radius, 0.0f), paint);
    }

    public final void drawArc(float cx, float cy, float radius, float startAngle, float sweepAngle, Paint paint) {
        if (radius > 0.0f && sweepAngle != 0.0f) {
            int oldStyle = paint.getStyle();
            paint.setStyle(0);
            this.drawArc(cx, cy, radius, startAngle, sweepAngle, paint.getStrokeCap(), paint.getStrokeWidth(), paint);
            paint.setStyle(oldStyle);
        }
    }

    public final void drawArc(float cx, float cy, float radius, float startAngle, float sweepAngle, int cap, float width, Paint paint) {
        this.onDrawArc(cx, cy, radius, startAngle, sweepAngle, cap, width, paint);
    }

    public final void drawPie(float cx, float cy, float radius, float startAngle, float sweepAngle, Paint paint) {
        if (radius > 0.0f && sweepAngle != 0.0f) {
            this.onDrawPie(cx, cy, radius, startAngle, sweepAngle, paint);
        }
    }

    public final void drawChord(float cx, float cy, float radius, float startAngle, float sweepAngle, Paint paint) {
        if (radius > 0.0f && sweepAngle != 0.0f) {
            this.onDrawChord(cx, cy, radius, startAngle, sweepAngle, paint);
        }
    }

    public void drawTriangle(float x0, float y0, float x1, float y1, float x2, float y2, Paint paint) {
    }

    public final void drawImage(@RawPtr Image image, float x, float y, SamplingOptions sampling, @Nullable Paint paint) {
        if (image == null) {
            return;
        }
        Rect2f src = new Rect2f(0.0f, 0.0f, image.getWidth(), image.getHeight());
        Rect2f dst = new Rect2f(src);
        dst.offset(x, y);
        this.drawImageRect(image, src, dst, sampling, paint, 0);
    }

    public final void drawImageRect(@RawPtr Image image, Rect2fc dst, SamplingOptions sampling, @Nullable Paint paint) {
        if (image == null) {
            return;
        }
        Rect2f src = new Rect2f(0.0f, 0.0f, image.getWidth(), image.getHeight());
        this.drawImageRect(image, src, dst, sampling, paint, 0);
    }

    public final void drawImageRect(@RawPtr Image image, Rect2fc src, Rect2fc dst, SamplingOptions sampling, @Nullable Paint paint, int constraint) {
        if (image == null) {
            return;
        }
        if (!src.isFinite() || src.isEmpty() || !dst.isFinite() || dst.isEmpty()) {
            return;
        }
        Paint cleanedPaint = this.mTmpPaint;
        if (paint != null) {
            cleanedPaint.set(paint);
            cleanedPaint.setStyle(0);
            cleanedPaint.setPathEffect(null);
        }
        if (constraint == 1) {
            if (sampling.mMipmapMode != 0) {
                int filter = sampling.mMinFilter | sampling.mMagFilter;
                sampling = filter == 1 ? SamplingOptions.LINEAR : SamplingOptions.POINT;
            } else if (sampling.isAnisotropy()) {
                sampling = SamplingOptions.LINEAR;
            }
        }
        this.onDrawImageRect(image, src, dst, sampling, cleanedPaint, constraint);
        cleanedPaint.reset();
    }

    public final void drawGlyphs(@Nonnull int[] glyphs, int glyphOffset, @Nonnull float[] positions, int positionOffset, int glyphCount, float originX, float originY, @Nonnull Font font, @Nonnull Paint paint) {
        if (glyphCount <= 0) {
            return;
        }
        GlyphRunList glyphRunList = this.mScratchGlyphRunBuilder.setGlyphRunList(glyphs, glyphOffset, positions, positionOffset, glyphCount, font, paint, originX, originY);
        this.onDrawGlyphRunList(glyphRunList, paint);
        this.mScratchGlyphRunBuilder.clear();
    }

    public final void drawTextBlob(TextBlob blob, float originX, float originY, @Nonnull Paint paint) {
        if (blob == null) {
            return;
        }
        blob.getBounds(this.mTmpRect2);
        this.mTmpRect2.offset(originX, originY);
        if (!this.mTmpRect2.isFinite()) {
            return;
        }
        this.onDrawTextBlob(blob, originX, originY, paint);
    }

    public final void drawVertices(Vertices vertices, @SharedPtr Blender blender, Paint paint) {
        if (vertices == null) {
            RefCnt.move(blender);
            return;
        }
        Paint cleanedPaint = this.mTmpPaint;
        cleanedPaint.set(paint);
        cleanedPaint.setStyle(0);
        cleanedPaint.setPathEffect(null);
        this.onDrawVertices(vertices, blender, cleanedPaint);
        cleanedPaint.reset();
    }

    public boolean isClipEmpty() {
        return this.topDevice().isClipEmpty();
    }

    public boolean isClipRect() {
        return this.topDevice().isClipRect();
    }

    public final void getLocalToDevice(@Nonnull Matrix4 storage) {
        this.top().mMatrix.store(storage);
    }

    public final void getLocalToDevice(@Nonnull Matrix storage) {
        this.top().mMatrix.toMatrix(storage);
    }

    @Override
    public void close() {
        this.restoreToCount(1);
        this.internalRestore();
        this.mRootDevice = RefCnt.move(this.mRootDevice);
        if (this.mSurface != null) {
            throw new IllegalStateException("Surface-created canvas is owned by Surface, use Surface#close instead");
        }
    }

    @Nonnull
    protected ImageInfo onGetImageInfo() {
        return this.mRootDevice.getImageInfo();
    }

    @Nullable
    @SharedPtr
    protected Surface onNewSurface(ImageInfo info) {
        return this.mRootDevice.makeSurface(info);
    }

    @RawPtr
    protected Device getRootDevice() {
        return this.mRootDevice;
    }

    protected void willSave() {
    }

    protected int getSaveLayerStrategy(@Nullable Rect2f bounds, @Nullable Paint paint, @Nullable ImageFilter backdrop, int saveLayerFlags) {
        return 0;
    }

    protected void willRestore() {
    }

    protected void didRestore() {
    }

    protected void didTranslate(float dx, float dy, float dz) {
    }

    protected void didScale(float sx, float sy, float sz) {
    }

    protected void didConcat(Matrix4c matrix) {
    }

    protected void didSetMatrix(Matrix4c matrix) {
    }

    @Nonnull
    private MCRec push() {
        MCRec rec;
        int i;
        MCRec[] stack = this.mMCStack;
        if ((i = ++this.mMCIndex) == stack.length) {
            this.mMCStack = new MCRec[i + (i >> 1)];
            System.arraycopy(stack, 0, this.mMCStack, 0, i);
            stack = this.mMCStack;
        }
        if ((rec = stack[i]) == null) {
            stack[i] = rec = new MCRec();
        }
        return rec;
    }

    private void pop() {
        int i;
        if ((i = this.mMCIndex--) >= 32) {
            this.mMCStack[i] = null;
        }
    }

    @Nonnull
    private MCRec top() {
        return this.mMCStack[this.mMCIndex];
    }

    @Nonnull
    private Device topDevice() {
        return this.top().mDevice;
    }

    private void checkForDeferredSave() {
        if (this.top().mDeferredSaveCount > 0) {
            this.doSave();
        }
    }

    private void doSave() {
        this.willSave();
        assert (this.top().mDeferredSaveCount > 0);
        --this.top().mDeferredSaveCount;
        this.internalSave();
    }

    private void internalSave() {
        MCRec rec = this.top();
        this.push().set(rec);
        this.topDevice().pushClipStack();
    }

    private void internalRestore() {
        assert (this.mMCIndex >= 0);
        this.pop();
        if (this.mMCIndex == -1) {
            return;
        }
        MCRec top = this.top();
        top.mDevice.popClipStack();
        top.mDevice.setGlobalCTM(top.mMatrix);
        this.computeQuickRejectBounds();
    }

    private void internalSaveLayer(@Nullable Rect2f bounds, @Nullable Paint paint, @Nullable ImageFilter backdrop, int saveLayerFlags, int saveLayerStrategy) {
        if (backdrop != null) {
            bounds = null;
        }
        Object imageFilter = null;
        Matrix4 stashedMatrix = this.top().mMatrix;
        if (imageFilter != null) {
            // empty if block
        }
        this.internalSave();
    }

    private void internalDrawPaint(Paint paint) {
        if (paint.nothingToDraw() || this.isClipEmpty()) {
            return;
        }
        if (this.aboutToDraw(paint)) {
            this.topDevice().drawPaint(paint);
        }
    }

    private void computeQuickRejectBounds() {
        Device device = this.topDevice();
        if (device.isClipEmpty()) {
            this.mQuickRejectBounds.setEmpty();
        } else {
            this.mQuickRejectBounds.set(device.getClipBounds());
            device.getDeviceToGlobal().mapRect(this.mQuickRejectBounds);
            this.mQuickRejectBounds.outset(1.0f, 1.0f);
        }
    }

    private boolean aboutToDraw(Paint paint) {
        return this.predrawNotify(false);
    }

    private boolean predrawNotify(boolean willOverwritesEntireSurface) {
        if (this.mSurface != null) {
            return this.mSurface.aboutToDraw(willOverwritesEntireSurface ? 1 : 0);
        }
        return true;
    }

    private boolean internalQuickReject(Rect2fc bounds, Paint paint) {
        return this.internalQuickReject(bounds, paint, null);
    }

    private boolean internalQuickReject(Rect2fc bounds, Paint paint, @Nullable Matrixc matrix) {
        if (!bounds.isFinite() || paint.nothingToDraw()) {
            return true;
        }
        if (paint.canComputeFastBounds(null)) {
            Rect2f tmp = this.mTmpQuickBounds;
            if (matrix != null) {
                matrix.mapRect(bounds, tmp);
            } else {
                tmp.set(bounds);
            }
            paint.computeFastBounds(null, tmp, tmp);
            return this.quickReject(tmp);
        }
        return false;
    }

    protected void onDiscard() {
        if (this.mSurface != null) {
            this.mSurface.aboutToDraw(1);
        }
    }

    protected void onDrawPaint(Paint paint) {
        this.internalDrawPaint(paint);
    }

    protected void onDrawPoints(int mode, float[] pts, int offset, int count, Paint paint) {
        if (count <= 0 || paint.nothingToDraw()) {
            return;
        }
        Rect2f bounds = this.mTmpRect2;
        bounds.setBounds(pts, offset, count);
        if (this.internalQuickReject(bounds, paint)) {
            return;
        }
        if (this.aboutToDraw(paint)) {
            this.topDevice().drawPoints(mode, pts, offset, count, paint);
        }
    }

    protected void onDrawLine(float x0, float y0, float x1, float y1, int cap, float width, Paint paint) {
        Rect2f bounds = this.mTmpRect2;
        bounds.set(x0, y0, x1, y1);
        bounds.sort();
        float outset = cap == 2 ? 1.4142135f * width * 0.5f : width * 0.5f;
        bounds.outset(outset, outset);
        if (this.internalQuickReject(bounds, paint)) {
            return;
        }
        if (this.aboutToDraw(paint)) {
            this.topDevice().drawLine(x0, y0, x1, y1, cap, width, paint);
        }
    }

    protected void onDrawRect(Rect2fc r, Paint paint) {
        if (this.internalQuickReject(r, paint)) {
            return;
        }
        if (this.aboutToDraw(paint)) {
            this.topDevice().drawRect(r, paint);
        }
    }

    protected void onDrawRoundRect(RoundRect rr, Paint paint) {
        Rect2f bounds = this.mTmpRect2;
        rr.getBounds(bounds);
        if (rr.isRect()) {
            bounds.sort();
            this.onDrawRect(bounds, paint);
            return;
        }
        if (this.internalQuickReject(bounds, paint)) {
            return;
        }
        if (this.aboutToDraw(paint)) {
            this.topDevice().drawRoundRect(rr, paint);
        }
    }

    protected void onDrawCircle(float cx, float cy, float radius, Paint paint) {
        Rect2f bounds = this.mTmpRect2;
        bounds.set(cx - radius, cy - radius, cx + radius, cy + radius);
        if (this.internalQuickReject(bounds, paint)) {
            return;
        }
        if (this.aboutToDraw(paint)) {
            this.topDevice().drawCircle(cx, cy, radius, paint);
        }
    }

    protected void onDrawArc(float cx, float cy, float radius, float startAngle, float sweepAngle, int cap, float width, Paint paint) {
        Rect2f bounds = this.mTmpRect2;
        bounds.set(cx - radius, cy - radius, cx + radius, cy + radius);
        float outset = cap == 2 ? 1.4142135f * width * 0.5f : width * 0.5f;
        bounds.outset(outset, outset);
        if (this.internalQuickReject(bounds, paint)) {
            return;
        }
        if (this.aboutToDraw(paint)) {
            this.topDevice().drawArc(cx, cy, radius, startAngle, sweepAngle, cap, width, paint);
        }
    }

    protected void onDrawPie(float cx, float cy, float radius, float startAngle, float sweepAngle, Paint paint) {
        Rect2f bounds = this.mTmpRect2;
        bounds.set(cx - radius, cy - radius, cx + radius, cy + radius);
        if (this.internalQuickReject(bounds, paint)) {
            return;
        }
        if (this.aboutToDraw(paint)) {
            this.topDevice().drawPie(cx, cy, radius, startAngle, sweepAngle, paint);
        }
    }

    protected void onDrawChord(float cx, float cy, float radius, float startAngle, float sweepAngle, Paint paint) {
        Rect2f bounds = this.mTmpRect2;
        bounds.set(cx - radius, cy - radius, cx + radius, cy + radius);
        if (this.internalQuickReject(bounds, paint)) {
            return;
        }
        if (this.aboutToDraw(paint)) {
            this.topDevice().drawChord(cx, cy, radius, startAngle, sweepAngle, paint);
        }
    }

    protected void onDrawImageRect(@RawPtr Image image, Rect2fc src, Rect2fc dst, SamplingOptions sampling, Paint paint, int constraint) {
        if (this.internalQuickReject(dst, paint)) {
            return;
        }
        if (this.aboutToDraw(paint)) {
            this.topDevice().drawImageRect(image, src, dst, sampling, paint, constraint);
        }
    }

    protected void onDrawTextBlob(TextBlob blob, float originX, float originY, Paint paint) {
        GlyphRunList glyphRunList = this.mScratchGlyphRunBuilder.blobToGlyphRunList(blob, originX, originY);
        this.onDrawGlyphRunList(glyphRunList, paint);
        this.mScratchGlyphRunBuilder.clear();
    }

    protected void onDrawGlyphRunList(GlyphRunList glyphRunList, Paint paint) {
        Rect2f bounds = this.mTmpRect2;
        glyphRunList.getSourceBoundsWithOrigin(bounds);
        if (this.internalQuickReject(bounds, paint)) {
            return;
        }
        if (this.aboutToDraw(paint)) {
            this.topDevice().drawGlyphRunList(this, glyphRunList, paint);
        }
    }

    protected void onDrawVertices(Vertices vertices, @SharedPtr Blender blender, Paint paint) {
        if (this.internalQuickReject(vertices.getBounds(), paint)) {
            RefCnt.move(blender);
            return;
        }
        if (this.aboutToDraw(paint)) {
            this.topDevice().drawVertices(vertices, blender, paint);
        } else {
            RefCnt.move(blender);
        }
    }

    protected void onClipRect(Rect2fc rect, int clipOp, boolean doAA) {
        this.topDevice().clipRect(rect, clipOp, doAA);
        this.computeQuickRejectBounds();
    }

    private static final class MCRec {
        Device mDevice;
        final Matrix4 mMatrix = new Matrix4();
        int mDeferredSaveCount;

        MCRec() {
            this.mMatrix.setIdentity();
            this.mDeferredSaveCount = 0;
        }

        MCRec(Device device) {
            this.mDevice = device;
            this.mMatrix.setIdentity();
            this.mDeferredSaveCount = 0;
        }

        void set(MCRec prev) {
            this.mDevice = prev.mDevice;
            this.mMatrix.set(prev.mMatrix);
            this.mDeferredSaveCount = 0;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SrcRectConstraint {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PointMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SaveLayerFlag {
    }
}

