/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core;

import javax.annotation.Nonnull;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.render.core.BlendMode;
import yslelf.cloudpick.render.core.ColorInt;
import yslelf.cloudpick.render.core.MathUtil;

public final class Color {
    @ColorInt
    public static final int TRANSPARENT = 0;
    @ColorInt
    public static final int BLACK = -16777216;
    @ColorInt
    public static final int DKGRAY = -12303292;
    @ColorInt
    public static final int GRAY = -7829368;
    @ColorInt
    public static final int LTGRAY = -3355444;
    @ColorInt
    public static final int WHITE = -1;
    @ColorInt
    public static final int RED = -65536;
    @ColorInt
    public static final int GREEN = -16711936;
    @ColorInt
    public static final int BLUE = -16776961;
    @ColorInt
    public static final int YELLOW = -256;
    @ColorInt
    public static final int CYAN = -16711681;
    @ColorInt
    public static final int MAGENTA = -65281;
    public static final int COLOR_CHANNEL_R = 0;
    public static final int COLOR_CHANNEL_G = 1;
    public static final int COLOR_CHANNEL_B = 2;
    public static final int COLOR_CHANNEL_A = 3;
    public static final int COLOR_CHANNEL_FLAG_RED = 1;
    public static final int COLOR_CHANNEL_FLAG_GREEN = 2;
    public static final int COLOR_CHANNEL_FLAG_BLUE = 4;
    public static final int COLOR_CHANNEL_FLAG_ALPHA = 8;
    public static final int COLOR_CHANNEL_FLAG_GRAY = 16;
    public static final int COLOR_CHANNEL_FLAGS_RG = 3;
    public static final int COLOR_CHANNEL_FLAGS_RGB = 7;
    public static final int COLOR_CHANNEL_FLAGS_RGBA = 15;
    @ApiStatus.Internal
    public float mR;
    @ApiStatus.Internal
    public float mG;
    @ApiStatus.Internal
    public float mB;
    @ApiStatus.Internal
    public float mA;

    public static int alpha(@ColorInt int color) {
        return color >>> 24;
    }

    public static int red(@ColorInt int color) {
        return color >> 16 & 0xFF;
    }

    public static int green(@ColorInt int color) {
        return color >> 8 & 0xFF;
    }

    public static int blue(@ColorInt int color) {
        return color & 0xFF;
    }

    @ColorInt
    public static int alpha(@ColorInt int color, int alpha) {
        return color & 0xFFFFFF | alpha << 24;
    }

    @ColorInt
    public static int rgb(int red, int green, int blue) {
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    @ColorInt
    public static int rgb(float red, float green, float blue) {
        return 0xFF000000 | (int)(red * 255.0f + 0.5f) << 16 | (int)(green * 255.0f + 0.5f) << 8 | (int)(blue * 255.0f + 0.5f);
    }

    @ColorInt
    public static int argb(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    @ColorInt
    public static int argb(float alpha, float red, float green, float blue) {
        return (int)(alpha * 255.0f + 0.5f) << 24 | (int)(red * 255.0f + 0.5f) << 16 | (int)(green * 255.0f + 0.5f) << 8 | (int)(blue * 255.0f + 0.5f);
    }

    public Color() {
    }

    public Color(@ColorInt int color) {
        this.mR = (float)(color >> 16 & 0xFF) / 255.0f;
        this.mG = (float)(color >> 8 & 0xFF) / 255.0f;
        this.mB = (float)(color & 0xFF) / 255.0f;
        this.mA = (float)(color >>> 24) / 255.0f;
    }

    public Color(float r, float g, float b, float a) {
        this.mR = r;
        this.mG = g;
        this.mB = b;
        this.mA = a;
    }

    public Color(Color color) {
        this.mR = color.mR;
        this.mG = color.mG;
        this.mB = color.mB;
        this.mA = color.mA;
    }

    public void set(@ColorInt int color) {
        this.mR = (float)(color >> 16 & 0xFF) / 255.0f;
        this.mG = (float)(color >> 8 & 0xFF) / 255.0f;
        this.mB = (float)(color & 0xFF) / 255.0f;
        this.mA = (float)(color >>> 24) / 255.0f;
    }

    public void set(float r, float g, float b, float a) {
        this.mR = r;
        this.mG = g;
        this.mB = b;
        this.mA = a;
    }

    public void set(Color color) {
        this.mR = color.mR;
        this.mG = color.mG;
        this.mB = color.mB;
        this.mA = color.mA;
    }

    @ColorInt
    public int toArgb() {
        return (int)(this.mA * 255.0f + 0.5f) << 24 | (int)(this.mR * 255.0f + 0.5f) << 16 | (int)(this.mG * 255.0f + 0.5f) << 8 | (int)(this.mB * 255.0f + 0.5f);
    }

    public float red() {
        return this.mR;
    }

    public float green() {
        return this.mG;
    }

    public float blue() {
        return this.mB;
    }

    public float alpha() {
        return this.mA;
    }

    public void red(float red) {
        this.mR = red;
    }

    public void green(float green) {
        this.mG = green;
    }

    public void blue(float blue) {
        this.mB = blue;
    }

    public void alpha(float alpha) {
        this.mA = alpha;
    }

    public boolean isOpaque() {
        return this.mA == 1.0f;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color = (Color)o;
        return Float.floatToIntBits(color.mR) == Float.floatToIntBits(this.mR) && Float.floatToIntBits(color.mG) == Float.floatToIntBits(this.mG) && Float.floatToIntBits(color.mB) == Float.floatToIntBits(this.mB) && Float.floatToIntBits(color.mA) == Float.floatToIntBits(this.mA);
    }

    public int hashCode() {
        int result = Float.floatToIntBits(this.mR);
        result = 31 * result + Float.floatToIntBits(this.mG);
        result = 31 * result + Float.floatToIntBits(this.mB);
        result = 31 * result + Float.floatToIntBits(this.mA);
        return result;
    }

    @Nonnull
    public String toString() {
        return "Color(" + this.mR + ", " + this.mG + ", " + this.mB + ", " + this.mA + ")";
    }

    @ColorInt
    public static int parseColor(@Nonnull String s) {
        if (s.charAt(0) == '#') {
            int color = Integer.parseUnsignedInt(s.substring(1), 16);
            if (s.length() == 7) {
                color |= 0xFF000000;
            } else if (s.length() != 9) {
                throw new IllegalArgumentException("Unknown color: " + s);
            }
            return color;
        }
        if (s.startsWith("0x")) {
            int color = Integer.parseUnsignedInt(s.substring(2), 16);
            if (s.length() == 8) {
                color |= 0xFF000000;
            } else if (s.length() != 10) {
                throw new IllegalArgumentException("Unknown color: " + s);
            }
            return color;
        }
        throw new IllegalArgumentException("Unknown color prefix: " + s);
    }

    public static void RGBToHSV(int r, int g, int b, float[] hsv) {
        int min;
        int max = Math.max(r, Math.max(g, b));
        int delta = max - (min = Math.min(r, Math.min(g, b)));
        if (delta == 0) {
            hsv[0] = 0.0f;
            hsv[1] = 0.0f;
            hsv[2] = (float)max / 255.0f;
            return;
        }
        float h2 = max == r ? (float)(g - b) / (float)delta : (max == g ? 2.0f + (float)(b - r) / (float)delta : 4.0f + (float)(r - g) / (float)delta);
        if ((h2 *= 60.0f) < 0.0f) {
            h2 += 360.0f;
        }
        hsv[0] = h2;
        hsv[1] = (float)delta / (float)max;
        hsv[2] = (float)max / 255.0f;
    }

    public static void RGBToHSV(int color, float[] hsv) {
        Color.RGBToHSV(Color.red(color), Color.green(color), Color.blue(color), hsv);
    }

    public static int HSVToColor(float h2, float s, float v) {
        float g;
        float r;
        s = MathUtil.clamp(s, 0.0f, 1.0f);
        v = MathUtil.clamp(v, 0.0f, 1.0f);
        if (s <= 9.765625E-4f) {
            int i = (int)(v * 255.0f + 0.5f);
            return i << 16 | i << 8 | i;
        }
        float hx = h2 < 0.0f || h2 >= 360.0f ? 0.0f : h2 / 60.0f;
        int w = (int)hx;
        float f2 = hx - (float)w;
        float p2 = v * (1.0f - s);
        float q = v * (1.0f - s * f2);
        float t2 = v * (1.0f - s * (1.0f - f2));
        return (int)(r * 255.0f + 0.5f) << 16 | (int)(g * 255.0f + 0.5f) << 8 | (int)((switch (w) {
            case 0 -> {
                r = v;
                g = t2;
                yield p2;
            }
            case 1 -> {
                r = q;
                g = v;
                yield p2;
            }
            case 2 -> {
                r = p2;
                g = v;
                yield t2;
            }
            case 3 -> {
                r = p2;
                g = q;
                yield v;
            }
            case 4 -> {
                r = t2;
                g = p2;
                yield v;
            }
            default -> {
                r = v;
                g = p2;
                yield q;
            }
        }) * 255.0f + 0.5f);
    }

    public static int HSVToColor(float[] hsv) {
        return Color.HSVToColor(hsv[0], hsv[1], hsv[2]);
    }

    public static float GammaToLinear(float x) {
        return (double)x < 0.04045 ? x / 12.92f : (float)Math.pow(((double)x + 0.055) / 1.055, 2.4);
    }

    public static float LinearToGamma(float x) {
        return (double)x < 0.0031308049535603713 ? x * 12.92f : (float)Math.pow(x, 0.4166666666666667) * 1.055f - 0.055f;
    }

    public static void GammaToLinear(float[] col) {
        col[0] = Color.GammaToLinear(col[0]);
        col[1] = Color.GammaToLinear(col[1]);
        col[2] = Color.GammaToLinear(col[2]);
    }

    public static void LinearToGamma(float[] col) {
        col[0] = Color.LinearToGamma(col[0]);
        col[1] = Color.LinearToGamma(col[1]);
        col[2] = Color.LinearToGamma(col[2]);
    }

    public static float luminance(float r, float g, float b) {
        return 0.2126f * r + 0.7152f * g + 0.0722f * b;
    }

    public static float luminance(float[] col) {
        return Color.luminance(col[0], col[1], col[2]);
    }

    public static float lightness(float lum) {
        return (double)lum <= 0.008856451679035631 ? lum * 24389.0f / 27.0f : (float)Math.pow(lum, 0.3333333333333333) * 116.0f - 16.0f;
    }

    @ColorInt
    public static int blend(@Nonnull BlendMode mode, @ColorInt int src, @ColorInt int dst) {
        switch (mode) {
            case CLEAR: {
                return 0;
            }
            case SRC: {
                return src;
            }
            case DST: {
                return dst;
            }
        }
        float[] src4 = Color.load_and_premul(src);
        float[] dst4 = Color.load_and_premul(dst);
        mode.apply(src4, dst4, dst4);
        float a = MathUtil.clamp(dst4[3], 0.0f, 1.0f);
        int result = (int)(a * 255.0f + 0.5f) << 24;
        if (result == 0) {
            return 0;
        }
        a = 255.0f / a;
        for (int i = 0; i < 3; ++i) {
            result |= (int)MathUtil.clamp(dst4[2 - i] * a + 0.5f, 0.0f, 255.0f) << (i << 3);
        }
        return result;
    }

    @Nonnull
    public static float[] load_and_premul(int col) {
        float[] col4 = new float[4];
        col4[3] = (float)(col >>> 24) * 0.003921569f;
        float a = col4[3] * 0.003921569f;
        col4[0] = (float)(col >> 16 & 0xFF) * a;
        col4[1] = (float)(col >> 8 & 0xFF) * a;
        col4[2] = (float)(col & 0xFF) * a;
        return col4;
    }
}

