/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.Blender;
import yslelf.cloudpick.render.core.Canvas;
import yslelf.cloudpick.render.core.GlyphRunList;
import yslelf.cloudpick.render.core.Image;
import yslelf.cloudpick.render.core.ImageInfo;
import yslelf.cloudpick.render.core.Matrix;
import yslelf.cloudpick.render.core.Matrix4;
import yslelf.cloudpick.render.core.Matrix4c;
import yslelf.cloudpick.render.core.Matrixc;
import yslelf.cloudpick.render.core.Paint;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.Rect2fc;
import yslelf.cloudpick.render.core.Rect2i;
import yslelf.cloudpick.render.core.Rect2ic;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.RoundRect;
import yslelf.cloudpick.render.core.SamplingOptions;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.core.Surface;
import yslelf.cloudpick.render.core.Vertices;
import yslelf.cloudpick.render.engine.RecordingContext;

public abstract class Device
extends RefCnt {
    private final ImageInfo mInfo;
    private final Rect2i mBounds = new Rect2i();
    final Matrix4 mLocalToDevice = new Matrix4();
    final Matrix mLocalToDevice33 = new Matrix();
    final Matrix4 mDeviceToGlobal = new Matrix4();
    final Matrix4 mGlobalToDevice = new Matrix4();

    public Device(ImageInfo info) {
        this.mInfo = info;
        this.mBounds.set(0, 0, info.width(), info.height());
    }

    void resize(int width, int height) {
        this.mInfo.resize(width, height);
        this.mBounds.set(0, 0, width, height);
    }

    @Override
    protected void deallocate() {
    }

    @Nonnull
    public final ImageInfo getImageInfo() {
        return this.mInfo;
    }

    public final int getWidth() {
        return this.mInfo.width();
    }

    public final int getHeight() {
        return this.mInfo.height();
    }

    public final Rect2ic getBounds() {
        return this.mBounds;
    }

    public final void getBounds(@Nonnull Rect2i bounds) {
        bounds.set(this.mBounds);
    }

    public final void getGlobalBounds(@Nonnull Rect2i bounds) {
        this.mDeviceToGlobal.mapRectOut(this.mBounds, bounds);
    }

    @Nonnull
    public final Matrix4c getLocalToDevice() {
        return this.mLocalToDevice;
    }

    @Nonnull
    public final Matrixc getLocalToDevice33() {
        return this.mLocalToDevice33;
    }

    @Nonnull
    public final Matrix4c getDeviceToGlobal() {
        return this.mDeviceToGlobal;
    }

    @Nonnull
    public final Matrix4c getGlobalToDevice() {
        return this.mGlobalToDevice;
    }

    public final boolean isPixelAlignedToGlobal() {
        Matrix4 mat = this.mDeviceToGlobal;
        return mat.m11 == 1.0f && mat.m12 == 0.0f && mat.m13 == 0.0f && mat.m14 == 0.0f && mat.m21 == 0.0f && mat.m22 == 1.0f && mat.m23 == 0.0f && mat.m24 == 0.0f && mat.m31 == 0.0f && mat.m32 == 0.0f && mat.m33 == 1.0f && mat.m34 == 0.0f && (double)mat.m41 == Math.floor(mat.m41) && (double)mat.m42 == Math.floor(mat.m42) && mat.m43 == 0.0f && mat.m44 == 1.0f;
    }

    public final void getRelativeTransform(@Nonnull Device device, @Nonnull Matrix4 dest) {
        dest.set(this.mDeviceToGlobal);
        dest.postConcat(device.mGlobalToDevice);
    }

    public final void setGlobalCTM(@Nonnull Matrix4c ctm) {
        this.mLocalToDevice.set(ctm);
        this.mLocalToDevice.normalizePerspective();
        this.mLocalToDevice.postConcat(this.mGlobalToDevice);
        this.mLocalToDevice.toMatrix(this.mLocalToDevice33);
    }

    public final void setLocalToDevice(@Nonnull Matrix4c localToDevice) {
        this.mLocalToDevice.set(localToDevice);
        this.mLocalToDevice.toMatrix(this.mLocalToDevice33);
    }

    @Nullable
    public RecordingContext getRecordingContext() {
        return null;
    }

    protected final void setDeviceCoordinateSystem(@Nullable Matrix4c deviceToGlobal, @Nullable Matrix4c globalToDevice, @Nullable Matrix4c localToDevice, int bufferOriginX, int bufferOriginY) {
        if (deviceToGlobal == null) {
            this.mDeviceToGlobal.setIdentity();
            this.mGlobalToDevice.setIdentity();
        } else {
            assert (globalToDevice != null);
            this.mDeviceToGlobal.set(deviceToGlobal);
            this.mDeviceToGlobal.normalizePerspective();
            this.mGlobalToDevice.set(globalToDevice);
            this.mGlobalToDevice.normalizePerspective();
        }
        if (localToDevice == null) {
            this.mLocalToDevice.setIdentity();
        } else {
            this.mLocalToDevice.set(localToDevice);
            this.mLocalToDevice.normalizePerspective();
        }
        if ((bufferOriginX | bufferOriginY) != 0) {
            this.mDeviceToGlobal.preTranslate(bufferOriginX, bufferOriginY);
            this.mGlobalToDevice.postTranslate(-bufferOriginX, -bufferOriginY);
            this.mLocalToDevice.postTranslate(-bufferOriginX, -bufferOriginY);
        }
        this.mLocalToDevice.toMatrix(this.mLocalToDevice33);
    }

    final void setOrigin(@Nullable Matrix4 globalTransform, int x, int y) {
        this.setDeviceCoordinateSystem(null, null, globalTransform, x, y);
    }

    public abstract void pushClipStack();

    public abstract void popClipStack();

    public abstract void getClipBounds(@Nonnull Rect2i var1);

    protected abstract Rect2ic getClipBounds();

    public abstract void clipRect(Rect2fc var1, int var2, boolean var3);

    public abstract boolean isClipAA();

    public abstract boolean isClipEmpty();

    public abstract boolean isClipRect();

    public abstract boolean isClipWideOpen();

    public abstract void drawPaint(Paint var1);

    public abstract void drawPoints(int var1, float[] var2, int var3, int var4, Paint var5);

    public abstract void drawLine(float var1, float var2, float var3, float var4, int var5, float var6, Paint var7);

    public abstract void drawRect(Rect2fc var1, Paint var2);

    public abstract void drawRoundRect(RoundRect var1, Paint var2);

    public abstract void drawCircle(float var1, float var2, float var3, Paint var4);

    public abstract void drawArc(float var1, float var2, float var3, float var4, float var5, int var6, float var7, Paint var8);

    public abstract void drawPie(float var1, float var2, float var3, float var4, float var5, Paint var6);

    public abstract void drawChord(float var1, float var2, float var3, float var4, float var5, Paint var6);

    public abstract void drawImageRect(@RawPtr Image var1, Rect2fc var2, Rect2fc var3, SamplingOptions var4, Paint var5, int var6);

    public final void drawGlyphRunList(Canvas canvas, GlyphRunList glyphRunList, Paint paint) {
        if (!this.getLocalToDevice33().isFinite()) {
            return;
        }
        this.onDrawGlyphRunList(canvas, glyphRunList, paint);
    }

    protected abstract void onDrawGlyphRunList(Canvas var1, GlyphRunList var2, Paint var3);

    public abstract void drawVertices(Vertices var1, @SharedPtr Blender var2, Paint var3);

    @Nullable
    protected Surface makeSurface(ImageInfo info) {
        return null;
    }

    @Nullable
    protected Device createDevice(ImageInfo info, @Nullable Paint paint) {
        return null;
    }
}

