/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.render.core.Font;
import yslelf.cloudpick.render.core.Glyph;
import yslelf.cloudpick.render.core.GlyphRun;
import yslelf.cloudpick.render.core.GlyphRunList;
import yslelf.cloudpick.render.core.Matrix;
import yslelf.cloudpick.render.core.Paint;
import yslelf.cloudpick.render.core.Rect2f;
import yslelf.cloudpick.render.core.Rect2fc;
import yslelf.cloudpick.render.core.Strike;
import yslelf.cloudpick.render.core.StrikeDesc;
import yslelf.cloudpick.render.core.TextBlob;

@ApiStatus.Internal
public class GlyphRunBuilder {
    private final GlyphRunList mGlyphRunList = new GlyphRunList();
    private GlyphRun[] mGlyphRuns = new GlyphRun[10];
    private int mGlyphRunCount;
    private final Rect2f mTmpBounds = new Rect2f();
    private final StrikeDesc mTmpStrikeDesc = new StrikeDesc();
    private Glyph[] mTmpGlyphs = new Glyph[60];

    private Glyph[] ensureGlyphs(int glyphCount) {
        if (this.mTmpGlyphs.length < glyphCount) {
            this.mTmpGlyphs = new Glyph[glyphCount];
        }
        return this.mTmpGlyphs;
    }

    public GlyphRunList setGlyphRunList(@Nonnull int[] glyphs, int glyphOffset, @Nonnull float[] positions, int positionOffset, int glyphCount, @Nonnull Font font, @Nonnull Paint paint, float originX, float originY) {
        Glyph[] glyphPtrs = this.ensureGlyphs(glyphCount);
        Strike strike = this.mTmpStrikeDesc.update(font, paint, Matrix.identity()).findOrCreateStrike();
        strike.getMetrics(glyphs, glyphOffset, glyphCount, glyphPtrs);
        Rect2f bounds = this.mTmpBounds;
        bounds.setEmpty();
        int i = 0;
        int j = positionOffset;
        while (i < glyphCount) {
            Glyph glyphPtr = glyphPtrs[i];
            if (!glyphPtr.isEmpty()) {
                float l2 = (float)glyphPtr.getLeft() + positions[j];
                float t2 = (float)glyphPtr.getTop() + positions[j + 1];
                float r = (float)(glyphPtr.getLeft() + glyphPtr.getWidth()) + positions[j];
                float b = (float)(glyphPtr.getTop() + glyphPtr.getHeight()) + positions[j + 1];
                bounds.join(l2, t2, r, b);
            }
            ++i;
            j += 2;
        }
        this.addGlyphRun(glyphs, glyphOffset, positions, positionOffset, glyphCount, font);
        return this.setGlyphRunList(null, bounds, originX, originY);
    }

    public GlyphRunList blobToGlyphRunList(@Nonnull TextBlob blob, float originX, float originY) {
        Font[] fonts = blob.getFonts();
        int[] counts = blob.getCounts();
        int[] glyphs = blob.getGlyphs();
        float[] positions = blob.getPositions();
        int runCount = blob.getRunCount();
        int glyphOffset = 0;
        int positionOffset = 0;
        for (int i = 0; i < runCount; ++i) {
            int glyphCount = counts[i];
            assert (glyphCount > 0);
            Font font = fonts[i];
            this.addGlyphRun(glyphs, glyphOffset, positions, positionOffset, glyphCount, font);
            glyphOffset += glyphCount;
            positionOffset += glyphCount * 2;
        }
        return this.setGlyphRunList(blob, blob.getBounds(), originX, originY);
    }

    public void clear() {
        this.mGlyphRunCount = 0;
        this.mGlyphRunList.clear();
    }

    private void addGlyphRun(@Nonnull int[] glyphs, int glyphOffset, @Nonnull float[] positions, int positionOffset, int glyphCount, @Nonnull Font font) {
        if (glyphCount <= 0) {
            return;
        }
        if (this.mGlyphRunCount == this.mGlyphRuns.length) {
            int cap = this.mGlyphRuns.length;
            cap += cap >> 1;
            cap = Math.min(cap, 0x3FFFFFFF);
            this.mGlyphRuns = Arrays.copyOf(this.mGlyphRuns, cap);
        }
        if (this.mGlyphRuns[this.mGlyphRunCount] == null) {
            this.mGlyphRuns[this.mGlyphRunCount] = new GlyphRun();
        }
        this.mGlyphRuns[this.mGlyphRunCount++].set(glyphs, glyphOffset, positions, positionOffset, glyphCount, font);
    }

    private GlyphRunList setGlyphRunList(@Nullable TextBlob blob, Rect2fc bounds, float originX, float originY) {
        this.mGlyphRunList.set(this.mGlyphRuns, this.mGlyphRunCount, blob, bounds, originX, originY);
        return this.mGlyphRunList;
    }
}

