/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.render.core.ColorInfo;
import yslelf.cloudpick.render.core.ColorSpace;
import yslelf.cloudpick.render.core.ImageInfo;
import yslelf.cloudpick.render.core.Rect2f;
import yslelf.cloudpick.render.core.Rect2i;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.UniqueID;
import yslelf.cloudpick.render.engine.Context;

public abstract class Image
extends RefCnt {
    protected final ImageInfo mInfo;
    protected final UniqueID mUniqueID;

    protected Image(@Nonnull ImageInfo info) {
        if (info.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.mInfo = info;
        this.mUniqueID = new UniqueID();
    }

    @Nonnull
    public final ImageInfo getInfo() {
        return this.mInfo;
    }

    public final int getWidth() {
        return this.mInfo.width();
    }

    public final int getHeight() {
        return this.mInfo.height();
    }

    public final void getBounds(@Nonnull Rect2i bounds) {
        bounds.set(0, 0, this.mInfo.width(), this.mInfo.height());
    }

    public final void getBounds(@Nonnull Rect2f bounds) {
        bounds.set(0.0f, 0.0f, this.mInfo.width(), this.mInfo.height());
    }

    @Nonnull
    public final UniqueID getUniqueID() {
        return this.mUniqueID;
    }

    public final int getColorType() {
        return this.mInfo.colorType();
    }

    public final int getAlphaType() {
        return this.mInfo.alphaType();
    }

    @Nullable
    public final ColorSpace getColorSpace() {
        return this.mInfo.colorSpace();
    }

    public final boolean isAlphaOnly() {
        return ColorInfo.colorTypeIsAlphaOnly(this.getColorType());
    }

    @Nullable
    @ApiStatus.Internal
    public Context getContext() {
        return null;
    }

    @ApiStatus.Internal
    public boolean isRasterBacked() {
        return false;
    }

    @ApiStatus.Internal
    public boolean isTextureBacked() {
        return false;
    }

    public long getTextureSize() {
        return 0L;
    }
}

