/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.render.core.ColorInfo;
import yslelf.cloudpick.render.core.ColorSpace;
import yslelf.cloudpick.render.core.Size;

public final class ImageInfo {
    @Size(min=0L)
    private int width;
    @Size(min=0L)
    private int height;
    private final short colorType;
    private final short alphaType;
    @Nullable
    private final ColorSpace colorSpace;

    @Nonnull
    public static ImageInfo make(@Size(min=0L) int width, @Size(min=0L) int height, int ct, int at, @Nullable ColorSpace cs) {
        return new ImageInfo(width, height, ct, at, cs);
    }

    @Nonnull
    public static ImageInfo makeUnknown(@Size(min=0L) int width, @Size(min=0L) int height) {
        return new ImageInfo(width, height, 0, 0, null);
    }

    public ImageInfo() {
        this(0, 0);
    }

    public ImageInfo(@Size(min=0L) int width, @Size(min=0L) int height) {
        this(width, height, 0, 0);
    }

    public ImageInfo(@Size(min=0L) int width, @Size(min=0L) int height, int colorType, int alphaType) {
        this(width, height, colorType, alphaType, null);
    }

    @ApiStatus.Internal
    public ImageInfo(@Size(min=0L) int w, @Size(min=0L) int h2, int ct, int at, @Nullable ColorSpace cs) {
        this.width = w;
        this.height = h2;
        this.colorType = (short)ct;
        this.alphaType = (short)at;
        this.colorSpace = cs;
    }

    @ApiStatus.Internal
    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int colorType() {
        return this.colorType;
    }

    public int alphaType() {
        return this.alphaType;
    }

    @Nullable
    public ColorSpace colorSpace() {
        return this.colorSpace;
    }

    public int bytesPerPixel() {
        return ColorInfo.bytesPerPixel(this.colorType());
    }

    public int minRowBytes() {
        long minRowBytes = (long)this.width * (long)this.bytesPerPixel();
        if (minRowBytes > Integer.MAX_VALUE) {
            return 0;
        }
        return (int)minRowBytes;
    }

    public boolean isEmpty() {
        return this.width <= 0 && this.height <= 0;
    }

    public boolean isOpaque() {
        return this.alphaType == 1 || (ColorInfo.colorTypeChannelFlags(this.colorType) & 8) == 0;
    }

    public boolean isValid() {
        return this.width > 0 && this.height > 0 && this.width <= 0x1FFFFFFF && this.height <= 0x1FFFFFFF && this.colorType != 0 && this.alphaType != 0;
    }

    public long computeByteSize(int rowBytes) {
        if (this.height == 0) {
            return 0L;
        }
        long minRowBytes = (long)this.width * (long)this.bytesPerPixel();
        if (minRowBytes > Integer.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        assert ((long)rowBytes >= minRowBytes);
        return (long)(this.height - 1) * (long)rowBytes + minRowBytes;
    }

    public long computeMinByteSize() {
        return this.computeByteSize(this.minRowBytes());
    }

    @Nonnull
    public ImageInfo makeWH(int newWidth, int newHeight) {
        return new ImageInfo(newWidth, newHeight, this.colorType, this.alphaType, this.colorSpace);
    }

    @Nonnull
    public ImageInfo makeAlphaType(int newAlphaType) {
        return new ImageInfo(this.width, this.height, this.colorType, newAlphaType, this.colorSpace);
    }

    @Nonnull
    public ImageInfo makeColorType(int newColorType) {
        return new ImageInfo(this.width, this.height, newColorType, this.alphaType, this.colorSpace);
    }

    @Nonnull
    public ImageInfo makeColorSpace(@Nullable ColorSpace newColorSpace) {
        return new ImageInfo(this.width, this.height, this.colorType, this.alphaType, newColorSpace);
    }

    public int hashCode() {
        int result = this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.colorType;
        result = 31 * result + this.alphaType;
        result = 31 * result + Objects.hashCode(this.colorSpace);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ImageInfo) {
            ImageInfo ii = (ImageInfo)o;
            return this.width == ii.width && this.height == ii.height && this.colorType == ii.colorType && this.alphaType == ii.alphaType && Objects.equals(this.colorSpace, ii.colorSpace);
        }
        return false;
    }

    public String toString() {
        return "{dimensions=" + this.width + "x" + this.height + ", colorType=" + ColorInfo.colorTypeToString(this.colorType) + ", alphaType=" + this.alphaType + ", colorSpace=" + this.colorSpace + "}";
    }
}

