/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.Matrix;
import yslelf.cloudpick.render.core.Matrixc;
import yslelf.cloudpick.render.core.Paint;
import yslelf.cloudpick.render.core.Path;
import yslelf.cloudpick.render.core.Rect2f;
import yslelf.cloudpick.render.core.Rect2fc;
import yslelf.cloudpick.render.core.StrokeRec;

public class PathUtils {
    public static boolean fillPathWithPaint(@Nonnull Path src, @Nonnull Paint paint, @Nonnull Path dst, @Nullable Rect2fc cullRect, float resScale) {
        return PathUtils.fillPathWithPaint(src, paint, dst, cullRect, Matrix.makeScale(resScale, resScale));
    }

    public static boolean fillPathWithPaint(@Nonnull Path src, @Nonnull Paint paint, @Nonnull Path dst, @Nullable Rect2fc cullRect, @Nonnull Matrixc ctm) {
        StrokeRec strokeRec;
        float resScale;
        if (!src.isFinite()) {
            dst.reset();
            return false;
        }
        if (ctm.hasPerspective()) {
            Rect2f transformedBounds = new Rect2f();
            ctm.mapRect(src.getBounds(), transformedBounds);
            resScale = ctm.getMaxScale(transformedBounds.centerX(), transformedBounds.centerY());
        } else {
            resScale = ctm.getMaxScale();
        }
        if (resScale <= 1.0E-5f || !Float.isFinite(resScale)) {
            resScale = 1.0f;
        }
        if (!(strokeRec = new StrokeRec(paint, resScale)).applyToPath(src, dst)) {
            dst.set(src);
        }
        if (!dst.isFinite()) {
            dst.reset();
            return false;
        }
        return !strokeRec.isHairlineStyle();
    }
}

