/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import sun.misc.Unsafe;
import yslelf.cloudpick.render.core.ColorInfo;
import yslelf.cloudpick.render.core.ColorInt;
import yslelf.cloudpick.render.core.ColorSpace;
import yslelf.cloudpick.render.core.ImageInfo;
import yslelf.cloudpick.render.core.PixelUtils;
import yslelf.cloudpick.render.core.Rect2i;
import yslelf.cloudpick.render.core.Rect2ic;
import yslelf.cloudpick.render.core.Size;

public class Pixmap {
    @Nonnull
    protected final ImageInfo mInfo;
    @Nullable
    protected final Object mBase;
    protected final long mAddress;
    protected final int mRowBytes;

    public Pixmap(@Nonnull ImageInfo info, @Nullable Object base, @NativeType(value="const void *") long address, int rowBytes) {
        this.mInfo = Objects.requireNonNull(info);
        this.mBase = base;
        this.mAddress = address;
        this.mRowBytes = rowBytes;
    }

    public Pixmap(@Nonnull ImageInfo newInfo, @Nonnull Pixmap oldPixmap) {
        this(newInfo, oldPixmap.mBase, oldPixmap.mAddress, oldPixmap.mRowBytes);
    }

    @Nonnull
    public ImageInfo getInfo() {
        return this.mInfo;
    }

    public int getWidth() {
        return this.mInfo.width();
    }

    public int getHeight() {
        return this.mInfo.height();
    }

    public int getColorType() {
        return this.mInfo.colorType();
    }

    public int getAlphaType() {
        return this.mInfo.alphaType();
    }

    @Nullable
    public ColorSpace getColorSpace() {
        return this.mInfo.colorSpace();
    }

    @Nullable
    public Object getBase() {
        return this.mBase;
    }

    public long getAddress() {
        return this.mAddress;
    }

    public int getRowBytes() {
        return this.mRowBytes;
    }

    public long getAddress(int x, int y) {
        assert (x < this.getWidth());
        assert (y < this.getHeight());
        long addr = this.mAddress;
        if (addr != 0L) {
            addr += (long)y * (long)this.mRowBytes + (long)x * (long)this.mInfo.bytesPerPixel();
        }
        return addr;
    }

    @Nullable
    public Pixmap makeSubset(@Nonnull Rect2ic subset) {
        Rect2i r = new Rect2i(0, 0, this.getWidth(), this.getHeight());
        if (!r.intersect(subset)) {
            return null;
        }
        assert (r.x() < this.getWidth());
        assert (r.y() < this.getHeight());
        return new Pixmap(this.getInfo().makeWH(r.width(), r.height()), this.getBase(), this.getAddress(r.x(), r.y()), this.getRowBytes());
    }

    public void getPixelOrigin(long pix, @Nonnull @Size(value=2L) int[] origin) {
        long addr = this.getAddress();
        long rb = this.getRowBytes();
        if (pix == 0L || rb == 0L) {
            origin[0] = 0;
            origin[1] = 0;
        } else {
            assert (addr >= pix);
            long off = addr - pix;
            origin[0] = (int)(off % rb / (long)this.getInfo().bytesPerPixel());
            origin[1] = (int)(off / rb);
        }
    }

    @ColorInt
    public int getColor(int x, int y) {
        assert (this.getAddress() != 0L);
        assert (x < this.getWidth());
        assert (y < this.getHeight());
        Object base = this.getBase();
        long addr = this.getAddress(x, y);
        int ct = this.getColorType();
        int at = this.getAlphaType();
        ColorSpace cs = this.getColorSpace();
        if (at == 2 || cs != null && !cs.isSrgb()) {
            ImageInfo srcInfo = new ImageInfo(1, 1, ct, at, cs);
            ImageInfo dstInfo = new ImageInfo(1, 1, ColorInfo.CT_BGRA_8888_NATIVE, 3, ColorSpace.get(ColorSpace.Named.SRGB));
            int[] col = new int[1];
            boolean res = PixelUtils.convertPixels(srcInfo, base, addr, this.getRowBytes(), dstInfo, col, Unsafe.ARRAY_INT_BASE_OFFSET, this.getRowBytes());
            assert (res);
            return col[0];
        }
        return PixelUtils.load(ct).load(base, addr);
    }

    public void getColor4f(int x, int y, @Nonnull @Size(value=4L) float[] dst) {
        assert (this.getAddress() != 0L);
        assert (x < this.getWidth());
        assert (y < this.getHeight());
        PixelUtils.loadOp(this.getColorType()).op(this.getBase(), this.getAddress(x, y), dst);
    }

    public void setColor4f(int x, int y, @Nonnull @Size(value=4L) float[] src) {
        assert (this.getAddress() != 0L);
        assert (x < this.getWidth());
        assert (y < this.getHeight());
        PixelUtils.storeOp(this.getColorType()).op(this.getBase(), this.getAddress(x, y), src);
    }

    public boolean readPixels(@Nonnull Pixmap dst, int srcX, int srcY) {
        ImageInfo dstInfo = dst.getInfo();
        if (!this.getInfo().isValid() || !dstInfo.isValid()) {
            return false;
        }
        if (this.getAddress() == 0L || dst.getAddress() == 0L || dst.getRowBytes() < dstInfo.minRowBytes()) {
            return false;
        }
        if (srcX < 0 || srcY < 0 || srcX + dstInfo.width() > this.getWidth() || srcY + dstInfo.height() > this.getHeight()) {
            return false;
        }
        long srcAddr = this.getAddress(srcX, srcY);
        ImageInfo srcInfo = this.getInfo().makeWH(dstInfo.width(), dstInfo.height());
        return PixelUtils.convertPixels(srcInfo, this.getBase(), srcAddr, this.getRowBytes(), dstInfo, dst.getBase(), dst.getAddress(), dst.getRowBytes());
    }

    public boolean writePixels(@Nonnull Pixmap src, int dstX, int dstY) {
        ImageInfo srcInfo = src.getInfo();
        if (!this.getInfo().isValid() || !srcInfo.isValid()) {
            return false;
        }
        if (this.getAddress() == 0L || src.getAddress() == 0L || src.getRowBytes() < srcInfo.minRowBytes()) {
            return false;
        }
        if (dstX < 0 || dstY < 0 || dstX + srcInfo.width() > this.getWidth() || dstY + srcInfo.height() > this.getHeight()) {
            return false;
        }
        long dstAddr = this.getAddress(dstX, dstY);
        ImageInfo dstInfo = this.getInfo().makeWH(srcInfo.width(), srcInfo.height());
        return PixelUtils.convertPixels(srcInfo, src.getBase(), src.getAddress(), src.getRowBytes(), dstInfo, this.getBase(), dstAddr, this.getRowBytes());
    }

    /*
     * WARNING - void declaration
     */
    public boolean clear(@Nonnull @Size(value=4L) float[] color, @Nullable Rect2ic subset) {
        int ct = this.getColorType();
        if (ct == 0) {
            return false;
        }
        Rect2i clip = new Rect2i(0, 0, this.getWidth(), this.getHeight());
        if (subset != null && !clip.intersect(subset)) {
            return false;
        }
        Object base = this.getBase();
        int bpp = ColorInfo.bytesPerPixel(ct);
        if (ct == 18) {
            assert (bpp == 16);
            if (Float.floatToRawIntBits(color[0]) == 0 && Float.floatToRawIntBits(color[1]) == 0 && Float.floatToRawIntBits(color[2]) == 0 && Float.floatToRawIntBits(color[3]) == 0) {
                long rowBytes = (long)clip.width() * 16L;
                if (base != null) {
                    for (int y = clip.mTop; y < clip.mBottom; ++y) {
                        PixelUtils.UNSAFE.setMemory(base, this.getAddress(clip.x(), y), rowBytes, (byte)0);
                    }
                } else {
                    for (int y = clip.mTop; y < clip.mBottom; ++y) {
                        MemoryUtil.memSet((long)this.getAddress(clip.x(), y), (int)0, (long)rowBytes);
                    }
                }
            } else {
                for (int y = clip.mTop; y < clip.mBottom; ++y) {
                    long addr = this.getAddress(clip.x(), y);
                    int e = clip.width();
                    for (int i = 0; i < e; ++i) {
                        PixelUtils.store_RGBA_F32(base, addr, color);
                        addr += 16L;
                    }
                }
            }
            return true;
        }
        assert (bpp >= 1 && bpp <= 8);
        try (MemoryStack stack = MemoryStack.stackPush();){
            void var12_21;
            long dst = stack.nmalloc(8, 8);
            PixelUtils.storeOp(ct).op(null, dst, color);
            boolean fast = true;
            byte v0 = PixelUtils.UNSAFE.getByte(dst);
            boolean bl = true;
            while (var12_21 < bpp) {
                byte v = PixelUtils.UNSAFE.getByte(dst + (long)var12_21);
                if (v != v0) {
                    fast = false;
                    break;
                }
                ++var12_21;
            }
            if (fast) {
                long l2 = (long)clip.width() * (long)bpp;
                if (base != null) {
                    for (int y = clip.mTop; y < clip.mBottom; ++y) {
                        PixelUtils.UNSAFE.setMemory(base, this.getAddress(clip.x(), y), l2, v0);
                    }
                } else {
                    for (int y = clip.mTop; y < clip.mBottom; ++y) {
                        MemoryUtil.memSet((long)this.getAddress(clip.x(), y), (int)(v0 & 0xFF), (long)l2);
                    }
                }
            } else if (ct == 4) {
                assert (bpp == 3);
                byte bl2 = PixelUtils.UNSAFE.getByte(dst + 1L);
                byte v2 = PixelUtils.UNSAFE.getByte(dst + 2L);
                for (int y = clip.mTop; y < clip.mBottom; ++y) {
                    long addr = this.getAddress(clip.x(), y);
                    int e = clip.width();
                    for (int i = 0; i < e; ++i) {
                        PixelUtils.UNSAFE.putByte(base, addr, v0);
                        PixelUtils.UNSAFE.putByte(base, addr + 1L, bl2);
                        PixelUtils.UNSAFE.putByte(base, addr + 2L, v2);
                        addr += 3L;
                    }
                }
            } else if (bpp == 2) {
                short s = PixelUtils.UNSAFE.getShort(dst);
                for (y = clip.mTop; y < clip.mBottom; ++y) {
                    long addr = this.getAddress(clip.x(), y);
                    PixelUtils.setPixel16(base, addr, s, clip.width());
                }
            } else if (bpp == 4) {
                int n2 = PixelUtils.UNSAFE.getInt(dst);
                for (y = clip.mTop; y < clip.mBottom; ++y) {
                    long addr = this.getAddress(clip.x(), y);
                    PixelUtils.setPixel32(base, addr, n2, clip.width());
                }
            } else if (bpp == 8) {
                long l3 = PixelUtils.UNSAFE.getLong(dst);
                for (int y = clip.mTop; y < clip.mBottom; ++y) {
                    long addr = this.getAddress(clip.x(), y);
                    PixelUtils.setPixel64(base, addr, l3, clip.width());
                }
            } else assert (false);
            boolean bl3 = true;
            return bl3;
        }
    }

    public String toString() {
        return "Pixmap{mInfo=" + this.mInfo + ", mBase=" + this.mBase + ", mAddress=0x" + Long.toHexString(this.mAddress) + ", mRowBytes=" + this.mRowBytes + "}";
    }
}

