/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.system.MemoryUtil;
import yslelf.cloudpick.render.core.MathUtil;
import yslelf.cloudpick.render.core.Rect2f;
import yslelf.cloudpick.render.core.Rect2fc;
import yslelf.cloudpick.render.core.Size;

public class RoundRect {
    @ApiStatus.Internal
    public static final int kSizeOf = 52;
    @ApiStatus.Internal
    public static final int kAlignOf = 4;
    public static final int kEmpty_Type = 0;
    public static final int kRect_Type = 1;
    public static final int kEllipse_Type = 2;
    public static final int kSimple_Type = 3;
    public static final int kNineSlice_Type = 4;
    public static final int kComplex_Type = 5;
    public static final int kLast_Type = 5;
    protected float mLeft;
    protected float mTop;
    protected float mRight;
    protected float mBottom;
    @Size(value=8L)
    protected final float[] mRadii = new float[8];
    protected int mType = 0;

    public RoundRect() {
    }

    public RoundRect(RoundRect other) {
        this.set(other);
    }

    public RoundRect(Rect2fc other) {
        this.setRect(other);
    }

    public final float x() {
        return this.mLeft;
    }

    public final float y() {
        return this.mTop;
    }

    public final float left() {
        return this.mLeft;
    }

    public final float top() {
        return this.mTop;
    }

    public final float right() {
        return this.mRight;
    }

    public final float bottom() {
        return this.mBottom;
    }

    public final float width() {
        return this.mRight - this.mLeft;
    }

    public final float height() {
        return this.mBottom - this.mTop;
    }

    public final float centerX() {
        return (float)(((double)this.mLeft + (double)this.mRight) * 0.5);
    }

    public final float centerY() {
        return (float)(((double)this.mTop + (double)this.mBottom) * 0.5);
    }

    public final float halfWidth() {
        return (float)(((double)(-this.mLeft) + (double)this.mRight) * 0.5);
    }

    public final float halfHeight() {
        return (float)(((double)(-this.mTop) + (double)this.mBottom) * 0.5);
    }

    public int getType() {
        return this.mType;
    }

    public boolean isEmpty() {
        return this.getType() == 0;
    }

    public boolean isRect() {
        return this.getType() == 1;
    }

    public boolean isEllipse() {
        return this.getType() == 2;
    }

    public boolean isSimple() {
        return this.getType() == 3;
    }

    public boolean isNineSlice() {
        return this.getType() == 4;
    }

    public boolean isComplex() {
        return this.getType() == 5;
    }

    public float getSimpleRadiusX() {
        return this.mRadii[0];
    }

    public float getSimpleRadiusY() {
        return this.mRadii[1];
    }

    @Size(value=8L)
    public float[] getRadii() {
        return this.mRadii;
    }

    @ApiStatus.Internal
    public void set(long p2) {
        assert ((p2 & 3L) == 0L);
        this.mLeft = MemoryUtil.memGetFloat((long)p2);
        this.mTop = MemoryUtil.memGetFloat((long)(p2 + 4L));
        this.mRight = MemoryUtil.memGetFloat((long)(p2 + 8L));
        this.mBottom = MemoryUtil.memGetFloat((long)(p2 + 12L));
        for (int i = 0; i < 8; ++i) {
            this.mRadii[i] = MemoryUtil.memGetFloat((long)(p2 += 4L));
        }
        this.mType = MemoryUtil.memGetInt((long)(p2 + 4L));
    }

    @ApiStatus.Internal
    public void store(long p2) {
        assert ((p2 & 3L) == 0L);
        MemoryUtil.memPutFloat((long)p2, (float)this.mLeft);
        MemoryUtil.memPutFloat((long)(p2 + 4L), (float)this.mTop);
        MemoryUtil.memPutFloat((long)(p2 + 8L), (float)this.mRight);
        MemoryUtil.memPutFloat((long)(p2 + 12L), (float)this.mBottom);
        for (int i = 0; i < 8; ++i) {
            MemoryUtil.memPutFloat((long)(p2 += 4L), (float)this.mRadii[i]);
        }
        MemoryUtil.memPutInt((long)(p2 + 4L), (int)this.mType);
    }

    public void set(@Nonnull RoundRect src) {
        this.mLeft = src.mLeft;
        this.mTop = src.mTop;
        this.mRight = src.mRight;
        this.mBottom = src.mBottom;
        System.arraycopy(src.mRadii, 0, this.mRadii, 0, 8);
        this.mType = src.mType;
    }

    public void setEmpty() {
        this.mBottom = 0.0f;
        this.mTop = 0.0f;
        this.mRight = 0.0f;
        this.mLeft = 0.0f;
        Arrays.fill(this.mRadii, 0.0f);
        this.mType = 0;
    }

    public void setRect(Rect2fc rect) {
        this.setRect(rect.left(), rect.top(), rect.right(), rect.bottom());
    }

    public void setRect(float left, float top, float right, float bottom) {
        if (!this.initRect(left, top, right, bottom)) {
            return;
        }
        Arrays.fill(this.mRadii, 0.0f);
        this.mType = 1;
        assert (this.isValid());
    }

    public void setEllipse(Rect2fc ellipse) {
        this.setEllipse(ellipse.left(), ellipse.top(), ellipse.right(), ellipse.bottom());
    }

    public void setEllipse(float left, float top, float right, float bottom) {
        if (!this.initRect(left, top, right, bottom)) {
            return;
        }
        float radiusX = (float)(((double)(-this.mLeft) + (double)this.mRight) * 0.5);
        float radiusY = (float)(((double)(-this.mTop) + (double)this.mBottom) * 0.5);
        if (radiusX == 0.0f || radiusY == 0.0f) {
            Arrays.fill(this.mRadii, 0.0f);
            this.mType = 1;
        } else {
            for (int i = 0; i < 8; i += 2) {
                this.mRadii[i] = radiusX;
                this.mRadii[i | 1] = radiusY;
            }
            this.mType = 2;
        }
        assert (this.isValid());
    }

    public void setEllipseXY(float cx, float cy, float radiusX, float radiusY) {
        if (!this.initRect(cx - radiusX, cy - radiusY, cx + radiusX, cy + radiusY)) {
            return;
        }
        if (radiusX <= 0.0f || radiusY <= 0.0f) {
            Arrays.fill(this.mRadii, 0.0f);
            this.mType = 1;
        } else {
            for (int i = 0; i < 8; i += 2) {
                this.mRadii[i] = radiusX;
                this.mRadii[i | 1] = radiusY;
            }
            this.mType = 2;
        }
        assert (this.isValid());
    }

    public void setRectXY(Rect2fc rect, float radiusX, float radiusY) {
        this.setRectXY(rect.left(), rect.top(), rect.right(), rect.bottom(), radiusX, radiusY);
    }

    public void setRectXY(float left, float top, float right, float bottom, float radiusX, float radiusY) {
        if (!this.initRect(left, top, right, bottom)) {
            return;
        }
        if (!Float.isFinite(radiusX) || !Float.isFinite(radiusY)) {
            radiusY = 0.0f;
            radiusX = 0.0f;
        }
        if (this.width() < radiusX + radiusX || this.height() < radiusY + radiusY) {
            double scale = Math.min((double)this.width() / ((double)radiusX + (double)radiusX), (double)this.height() / ((double)radiusY + (double)radiusY));
            assert (scale < 1.0) : scale;
            radiusX = (float)((double)radiusX * scale);
            radiusY = (float)((double)radiusY * scale);
        }
        if (radiusX <= 0.0f || radiusY <= 0.0f) {
            Arrays.fill(this.mRadii, 0.0f);
            this.mType = 1;
            assert (this.isValid());
            return;
        }
        for (int i = 0; i < 8; i += 2) {
            this.mRadii[i] = radiusX;
            this.mRadii[i | 1] = radiusY;
        }
        this.mType = 3;
        if (radiusX >= this.width() * 0.5f && radiusY >= this.height() * 0.5f) {
            this.mType = 2;
        }
        assert (this.isValid());
    }

    public void setNineSlice(Rect2fc rect, float leftRad, float topRad, float rightRad, float bottomRad) {
        this.setNineSlice(rect.left(), rect.top(), rect.right(), rect.bottom(), leftRad, topRad, rightRad, bottomRad);
    }

    public void setNineSlice(float left, float top, float right, float bottom, float leftRad, float topRad, float rightRad, float bottomRad) {
        if (!this.initRect(left, top, right, bottom)) {
            return;
        }
        if (!MathUtil.isFinite(leftRad, topRad, rightRad, bottomRad)) {
            Arrays.fill(this.mRadii, 0.0f);
            this.mType = 1;
            assert (this.isValid());
            return;
        }
        leftRad = Math.max(leftRad, 0.0f);
        topRad = Math.max(topRad, 0.0f);
        rightRad = Math.max(rightRad, 0.0f);
        bottomRad = Math.max(bottomRad, 0.0f);
        double scale = 1.0;
        if (leftRad + rightRad > this.width()) {
            scale = (double)this.width() / ((double)leftRad + (double)rightRad);
        }
        if (topRad + bottomRad > this.height()) {
            scale = Math.min(scale, (double)this.height() / ((double)topRad + (double)bottomRad));
        }
        if (scale < 1.0) {
            leftRad = (float)((double)leftRad * scale);
            topRad = (float)((double)topRad * scale);
            rightRad = (float)((double)rightRad * scale);
            bottomRad = (float)((double)bottomRad * scale);
        }
        if (leftRad == rightRad && topRad == bottomRad) {
            if (leftRad >= this.width() * 0.5f && topRad >= this.height() * 0.5f) {
                this.mType = 2;
            } else if (leftRad == 0.0f || topRad == 0.0f) {
                this.mType = 1;
                leftRad = 0.0f;
                topRad = 0.0f;
                rightRad = 0.0f;
                bottomRad = 0.0f;
            } else {
                this.mType = 3;
            }
        } else {
            this.mType = 4;
        }
        this.mRadii[0] = leftRad;
        this.mRadii[1] = topRad;
        this.mRadii[2] = rightRad;
        this.mRadii[3] = topRad;
        this.mRadii[4] = rightRad;
        this.mRadii[5] = bottomRad;
        this.mRadii[6] = leftRad;
        this.mRadii[7] = bottomRad;
        if (RoundRect.clamp_corner_radii(this.mRadii)) {
            this.mType = 1;
            assert (this.isValid());
            return;
        }
        if (this.mType == 4 && !RoundRect.radii_are_nine_slice(this.mRadii)) {
            this.mType = 5;
        }
    }

    private boolean initRect(float left, float top, float right, float bottom) {
        if (MathUtil.isFinite(left, top, right, bottom)) {
            this.mLeft = Math.min(left, right);
            this.mTop = Math.min(top, bottom);
            this.mRight = Math.max(left, right);
            this.mBottom = Math.max(top, bottom);
            if (this.mLeft < this.mRight && this.mTop < this.mBottom) {
                return true;
            }
            Arrays.fill(this.mRadii, 0.0f);
            this.mType = 0;
            return false;
        }
        this.setEmpty();
        return false;
    }

    public final void getRect(Rect2f dest) {
        dest.set(this.mLeft, this.mTop, this.mRight, this.mBottom);
    }

    public void getBounds(Rect2f dest) {
        dest.set(this.mLeft, this.mTop, this.mRight, this.mBottom);
    }

    public boolean isValid() {
        if (!RoundRect.are_rect_and_radii_valid(this.mLeft, this.mTop, this.mRight, this.mBottom, this.mRadii)) {
            return false;
        }
        boolean allRadiiZero = 0.0f == this.mRadii[0] && 0.0f == this.mRadii[1];
        boolean allCornersSquare = 0.0f == this.mRadii[0] || 0.0f == this.mRadii[1];
        boolean allRadiiSame = true;
        for (int i = 2; i < 8; i += 2) {
            if (0.0f != this.mRadii[i] || 0.0f != this.mRadii[i | 1]) {
                allRadiiZero = false;
            }
            if (this.mRadii[i] != this.mRadii[i - 2] || this.mRadii[i | 1] != this.mRadii[i - 1]) {
                allRadiiSame = false;
            }
            if (0.0f == this.mRadii[i] || 0.0f == this.mRadii[i | 1]) continue;
            allCornersSquare = false;
        }
        boolean isNineSlice = RoundRect.radii_are_nine_slice(this.mRadii);
        if (this.mType < 0 || this.mType > 5) {
            return false;
        }
        boolean isRectEmpty = !(this.mLeft < this.mRight) || !(this.mTop < this.mBottom);
        switch (this.mType) {
            case 0: {
                if (isRectEmpty && allRadiiZero && allRadiiSame && allCornersSquare) break;
                return false;
            }
            case 1: {
                if (!isRectEmpty && allRadiiZero && allRadiiSame && allCornersSquare) break;
                return false;
            }
            case 2: {
                if (isRectEmpty || allRadiiZero || !allRadiiSame || allCornersSquare) {
                    return false;
                }
                float halfWidth = this.halfWidth();
                float halfHeight = this.halfHeight();
                float xError = Math.max(Math.ulp(this.mLeft), Math.ulp(this.mRight)) * 0.5f;
                float yError = Math.max(Math.ulp(this.mTop), Math.ulp(this.mBottom)) * 0.5f;
                for (int i = 0; i < 8; i += 2) {
                    if (MathUtil.isApproxEqual(this.mRadii[i], halfWidth, xError) && MathUtil.isApproxEqual(this.mRadii[i | 1], halfHeight, yError)) continue;
                    return false;
                }
                break;
            }
            case 3: {
                if (!isRectEmpty && !allRadiiZero && allRadiiSame && !allCornersSquare) break;
                return false;
            }
            case 4: {
                if (!isRectEmpty && !allRadiiZero && !allRadiiSame && !allCornersSquare && isNineSlice) break;
                return false;
            }
            case 5: {
                if (!isRectEmpty && !allRadiiZero && !allRadiiSame && !allCornersSquare && !isNineSlice) break;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = this.mLeft != 0.0f ? Float.floatToIntBits(this.mLeft) : 0;
        result = 31 * result + (this.mTop != 0.0f ? Float.floatToIntBits(this.mTop) : 0);
        result = 31 * result + (this.mRight != 0.0f ? Float.floatToIntBits(this.mRight) : 0);
        result = 31 * result + (this.mBottom != 0.0f ? Float.floatToIntBits(this.mBottom) : 0);
        for (float rad : this.mRadii) {
            result = 31 * result + (rad != 0.0f ? Float.floatToIntBits(rad) : 0);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoundRect)) {
            return false;
        }
        RoundRect rr = (RoundRect)o;
        if (this.mLeft == rr.mLeft && this.mTop == rr.mTop && this.mRight == rr.mRight && this.mBottom == rr.mBottom) {
            for (int i = 0; i < 8; ++i) {
                if (this.mRadii[i] == rr.mRadii[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RoundRect{");
        sb.append("mRect=(");
        sb.append(this.mLeft);
        sb.append(", ");
        sb.append(this.mTop);
        sb.append(", ");
        sb.append(this.mRight);
        sb.append(", ");
        sb.append(this.mBottom);
        sb.append("), mRadii={");
        int i = 0;
        while (true) {
            sb.append("(");
            sb.append(this.mRadii[i]);
            sb.append(", ");
            sb.append(this.mRadii[i | 1]);
            if ((i += 2) >= 8) break;
            sb.append("), ");
        }
        sb.append(")}}");
        return sb.toString();
    }

    private static boolean clamp_corner_radii(float[] radii) {
        boolean allCornersSquare = true;
        for (int i = 0; i < 8; i += 2) {
            if (radii[i] <= 0.0f || radii[i | 1] <= 0.0f) {
                radii[i] = 0.0f;
                radii[i | 1] = 0.0f;
                continue;
            }
            allCornersSquare = false;
        }
        return allCornersSquare;
    }

    private static boolean radii_are_nine_slice(float[] radii) {
        return radii[0] == radii[6] && radii[1] == radii[3] && radii[2] == radii[4] && radii[7] == radii[5];
    }

    private static boolean is_radius_valid(float rad, float min, float max) {
        return min <= max && rad <= max - min && min + rad <= max && max - rad >= min && rad >= 0.0f;
    }

    private static boolean are_rect_and_radii_valid(float l2, float t2, float r, float b, float[] radii) {
        if (!MathUtil.isFinite(l2, t2, r, b)) {
            return false;
        }
        if (!(l2 <= r) || !(t2 <= b)) {
            return false;
        }
        for (int i = 0; i < 8; i += 2) {
            if (RoundRect.is_radius_valid(radii[i], l2, r) && RoundRect.is_radius_valid(radii[i | 1], t2, b)) continue;
            return false;
        }
        return true;
    }
}

