/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import javax.annotation.Nonnull;
import sun.misc.Unsafe;
import yslelf.cloudpick.render.core.BlendMode;
import yslelf.cloudpick.render.core.Glyph;
import yslelf.cloudpick.render.core.MathUtil;
import yslelf.cloudpick.render.core.Matrix;
import yslelf.cloudpick.render.core.Paint;
import yslelf.cloudpick.render.core.Path;
import yslelf.cloudpick.render.core.PixelUtils;
import yslelf.cloudpick.render.core.Rect2fc;
import yslelf.cloudpick.render.core.StrikeDesc;
import yslelf.cloudpick.render.core.StrokeRec;
import yslelf.cloudpick.render.core.Typeface;
import yslelf.cloudpick.render.core.j2d.DrawBase;

public abstract class ScalerContext {
    protected final StrikeDesc mDesc;
    private final Typeface mTypeface;
    private final boolean mGenerateImageFromPath;

    public ScalerContext(Typeface typeface, StrikeDesc desc) {
        this.mDesc = new StrikeDesc(desc);
        typeface.onFilterStrikeDesc(this.mDesc);
        this.mTypeface = typeface;
        this.mGenerateImageFromPath = this.mDesc.getFrameWidth() >= 0.0f;
    }

    public final Typeface getTypeface() {
        return this.mTypeface;
    }

    public final byte getMaskFormat() {
        return this.mDesc.getMaskFormat();
    }

    public final boolean isLinearMetrics() {
        return (this.mDesc.getFlags() & 2) != 0;
    }

    private static void saturate_glyph_bounds(Glyph glyph, float left, float top, float right, float bottom) {
        int l2 = (int)Math.floor(left);
        int t2 = (int)Math.floor(top);
        int r = (int)Math.ceil(right);
        int b = (int)Math.ceil(bottom);
        glyph.mLeft = (short)MathUtil.clamp(l2, Short.MIN_VALUE, Short.MAX_VALUE);
        glyph.mTop = (short)MathUtil.clamp(t2, Short.MIN_VALUE, Short.MAX_VALUE);
        glyph.mWidth = (short)MathUtil.clamp(r - l2, 0, 65535);
        glyph.mHeight = (short)MathUtil.clamp(b - t2, 0, 65535);
    }

    @Nonnull
    public final Glyph makeGlyph(int glyphID) {
        Glyph glyph = new Glyph(glyphID);
        glyph.mMaskFormat = this.getMaskFormat();
        GlyphMetrics metrics = this.generateMetrics(glyph);
        assert (!metrics.mNeverRequestPath || !metrics.mComputeFromPath);
        glyph.mMaskFormat = metrics.mMaskFormat;
        if (metrics.mComputeFromPath || this.mGenerateImageFromPath && !metrics.mNeverRequestPath) {
            this.internalGetPath(glyph);
            Path devPath = glyph.getPath();
            if (devPath != null) {
                if (glyph.mMaskFormat != 0 && glyph.mMaskFormat != 1) {
                    glyph.mMaskFormat = 1;
                }
                Rect2fc bounds = devPath.getBounds();
                ScalerContext.saturate_glyph_bounds(glyph, bounds.left(), bounds.top(), bounds.right(), bounds.bottom());
            }
        } else {
            ScalerContext.saturate_glyph_bounds(glyph, metrics.mLeft, metrics.mTop, metrics.mRight, metrics.mBottom);
            if (metrics.mNeverRequestPath) {
                glyph.setPath((Path)null);
            }
        }
        if (glyph.mWidth == 0 || glyph.mHeight == 0) {
            glyph.mHeight = 0;
            glyph.mWidth = 0;
            glyph.mTop = 0;
            glyph.mLeft = 0;
        }
        return glyph;
    }

    public final void getImage(Glyph glyph) {
        if (!this.mGenerateImageFromPath) {
            this.generateImage(glyph, glyph.getImageBase(), glyph.getImageAddress());
        } else {
            assert (glyph.setPathHasBeenCalled());
            Path devPath = glyph.getPath();
            if (devPath == null) {
                this.generateImage(glyph, glyph.getImageBase(), glyph.getImageAddress());
            } else {
                assert (glyph.getMaskFormat() != 3);
                ScalerContext.generateImageFromPath(glyph, devPath);
            }
        }
    }

    private static void generateImageFromPath(Glyph glyph, Path path) {
        assert (glyph.getMaskFormat() == 0 || glyph.getMaskFormat() == 1);
        Matrix matrix = Matrix.makeTranslate(-glyph.getLeft(), -glyph.getTop());
        Paint paint = new Paint();
        paint.setStyle(0);
        paint.setAntiAlias(glyph.getMaskFormat() != 0);
        paint.setBlendMode(BlendMode.SRC);
        BufferedImage bufferedImage = new BufferedImage(glyph.getWidth(), glyph.getHeight(), 10);
        DrawBase draw = new DrawBase();
        draw.mG2D = bufferedImage.createGraphics();
        draw.mCTM = matrix;
        draw.drawPath(path, paint);
        byte[] data = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
        switch (glyph.getMaskFormat()) {
            case 0: {
                PixelUtils.packA8ToBW(data, Unsafe.ARRAY_BYTE_BASE_OFFSET, glyph.getWidth(), glyph.getImageBase(), glyph.getImageAddress(), glyph.getRowBytes(), glyph.getWidth(), glyph.getHeight());
                break;
            }
            case 1: {
                PixelUtils.copyImage(data, Unsafe.ARRAY_BYTE_BASE_OFFSET, glyph.getWidth(), glyph.getImageBase(), glyph.getImageAddress(), glyph.getRowBytes(), glyph.getRowBytes(), glyph.getHeight());
            }
        }
        paint.close();
    }

    public final void getPath(@Nonnull Glyph glyph) {
        this.internalGetPath(glyph);
    }

    private void internalGetPath(@Nonnull Glyph glyph) {
        if (glyph.setPathHasBeenCalled()) {
            return;
        }
        Path path = new Path();
        if (!this.generatePath(glyph, path)) {
            glyph.setPath((Path)null);
            return;
        }
        if (this.mDesc.getFrameWidth() >= 0.0f || this.mDesc.getPathEffect() != null) {
            Matrix matrix = new Matrix();
            Matrix inverse = new Matrix();
            this.mDesc.getDeviceMatrix(matrix);
            if (!matrix.invert(inverse)) {
                glyph.setPath(new Path());
                return;
            }
            Path localPath = new Path();
            path.transform(inverse, localPath);
            StrokeRec strokeRec = new StrokeRec();
            if (this.mDesc.getFrameWidth() >= 0.0f) {
                strokeRec.setStrokeStyle(this.mDesc.getFrameWidth(), (this.mDesc.getFlags() & 1) != 0);
                strokeRec.setStrokeParams(0, this.mDesc.getStrokeJoin(), 0, this.mDesc.getMiterLimit());
            }
            if (this.mDesc.getPathEffect() != null) {
                // empty if block
            }
            path.reset();
            if (strokeRec.applyToPath(localPath, path)) {
                localPath.set(path);
            }
            localPath.transform(matrix, path);
            localPath.recycle();
        }
        path.trimToSize();
        glyph.setPath(path);
        path.recycle();
    }

    protected abstract GlyphMetrics generateMetrics(Glyph var1);

    protected abstract void generateImage(Glyph var1, Object var2, long var3);

    protected abstract boolean generatePath(Glyph var1, Path var2);

    public static class GlyphMetrics {
        public float mLeft;
        public float mTop;
        public float mRight;
        public float mBottom;
        public byte mMaskFormat;
        public boolean mNeverRequestPath;
        public boolean mComputeFromPath;

        public GlyphMetrics(byte maskFormat) {
            this.mMaskFormat = maskFormat;
        }
    }
}

