/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core;

import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.render.core.ScalerContext;
import yslelf.cloudpick.render.core.Strike;
import yslelf.cloudpick.render.core.StrikeDesc;

public final class StrikeCache {
    private static final StrikeCache gCache = new StrikeCache();
    final ReentrantLock mLock = new ReentrantLock();
    @GuardedBy(value="mLock")
    Strike mHead;
    @GuardedBy(value="mLock")
    Strike mTail;
    @GuardedBy(value="mLock")
    private final HashMap<StrikeDesc, Strike> mStrikes = new HashMap();
    @GuardedBy(value="mLock")
    long mCacheSizeLimit = 0x200000L;
    @GuardedBy(value="mLock")
    long mTotalMemoryUsed;
    @GuardedBy(value="mLock")
    int mCacheCountLimit = 2048;
    @GuardedBy(value="mLock")
    int mCacheCount;

    @ApiStatus.Internal
    public StrikeCache() {
    }

    @Nonnull
    public static StrikeCache getGlobalStrikeCache() {
        return gCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Strike findOrCreateStrike(@Nonnull StrikeDesc desc) {
        this.mLock.lock();
        try {
            Strike strike = this.internalFindStrike(desc);
            if (strike == null) {
                strike = this.internalCreateStrike(desc.copy());
            }
            this.internalPurge(0L);
            Strike strike2 = strike;
            return strike2;
        }
        finally {
            this.mLock.unlock();
        }
    }

    private long internalPurge(long minBytesNeeded) {
        if (this.mCacheCount == 0) {
            return 0L;
        }
        long bytesNeeded = 0L;
        if (this.mTotalMemoryUsed > this.mCacheSizeLimit) {
            bytesNeeded = this.mTotalMemoryUsed - this.mCacheSizeLimit;
        }
        if ((bytesNeeded = Math.max(bytesNeeded, minBytesNeeded)) != 0L) {
            bytesNeeded = Math.max(bytesNeeded, this.mTotalMemoryUsed >> 2);
        }
        int countNeeded = 0;
        if (this.mCacheCount > this.mCacheCountLimit) {
            countNeeded = this.mCacheCount - this.mCacheCountLimit;
            countNeeded = Math.max(countNeeded, this.mCacheCount >> 2);
        }
        if (countNeeded == 0 && bytesNeeded == 0L) {
            return 0L;
        }
        long bytesFreed = 0L;
        int countFreed = 0;
        Strike strike = this.mTail;
        while (strike != null && (bytesFreed < bytesNeeded || countFreed < countNeeded)) {
            Strike prev = strike.mPrev;
            bytesFreed += strike.mMemoryUsed;
            ++countFreed;
            --this.mCacheCount;
            this.mTotalMemoryUsed -= strike.mMemoryUsed;
            if (strike.mPrev != null) {
                strike.mPrev.mNext = strike.mNext;
            } else {
                this.mHead = strike.mNext;
            }
            if (strike.mNext != null) {
                strike.mNext.mPrev = strike.mPrev;
            } else {
                this.mTail = strike.mPrev;
            }
            strike.mNext = null;
            strike.mPrev = null;
            strike.mRemoved = true;
            Strike old = this.mStrikes.remove(strike.getStrikeDesc());
            assert (old == strike);
            strike = prev;
        }
        return bytesFreed;
    }

    @Nullable
    private Strike internalFindStrike(@Nonnull StrikeDesc desc) {
        if (this.mHead != null && this.mHead.getStrikeDesc().equals(desc)) {
            return this.mHead;
        }
        Strike strike = this.mStrikes.get(desc);
        if (strike == null) {
            return null;
        }
        if (this.mHead != strike) {
            strike.mPrev.mNext = strike.mNext;
            if (strike.mNext != null) {
                strike.mNext.mPrev = strike.mPrev;
            } else {
                this.mTail = strike.mPrev;
            }
            this.mHead.mPrev = strike;
            strike.mNext = this.mHead;
            strike.mPrev = null;
            this.mHead = strike;
        }
        return strike;
    }

    @Nonnull
    private Strike internalCreateStrike(@Nonnull StrikeDesc desc) {
        ScalerContext scalerContext = desc.createScalerContext();
        Strike strike = new Strike(this, desc, scalerContext);
        Strike old = this.mStrikes.put(desc, strike);
        assert (old == null);
        assert (strike.mPrev == null && strike.mNext == null);
        ++this.mCacheCount;
        this.mTotalMemoryUsed += strike.mMemoryUsed;
        if (this.mHead != null) {
            this.mHead.mPrev = strike;
            strike.mNext = this.mHead;
        }
        if (this.mTail == null) {
            this.mTail = strike;
        }
        this.mHead = strike;
        return strike;
    }

    public long getTotalMemoryUsed() {
        this.mLock.lock();
        try {
            long l2 = this.mTotalMemoryUsed;
            return l2;
        }
        finally {
            this.mLock.unlock();
        }
    }
}

