/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.Font;
import yslelf.cloudpick.render.core.Matrix;
import yslelf.cloudpick.render.core.Matrixc;
import yslelf.cloudpick.render.core.Paint;
import yslelf.cloudpick.render.core.PathEffect;
import yslelf.cloudpick.render.core.ScalerContext;
import yslelf.cloudpick.render.core.Strike;
import yslelf.cloudpick.render.core.StrikeCache;
import yslelf.cloudpick.render.core.Typeface;

public final class StrikeDesc {
    public static final int kFrameAndFill_Flag = 1;
    public static final int kLinearMetrics_Flag = 2;
    private Typeface mTypeface;
    private float mTextSize;
    private float mPostScaleX;
    private float mPostScaleY;
    private float mPostShearX;
    private float mPostShearY;
    private float mFrameWidth;
    private float mMiterLimit;
    private byte mMaskFormat;
    private byte mStrokeJoin;
    private short mFlags;
    private PathEffect mPathEffect;
    private transient int mHash;

    public StrikeDesc() {
    }

    public StrikeDesc(StrikeDesc other) {
        this.mTypeface = other.mTypeface;
        this.mPathEffect = other.mPathEffect;
        this.mTextSize = other.mTextSize;
        this.mPostScaleX = other.mPostScaleX;
        this.mPostScaleY = other.mPostScaleY;
        this.mPostShearX = other.mPostShearX;
        this.mPostShearY = other.mPostShearY;
        this.mFrameWidth = other.mFrameWidth;
        this.mMiterLimit = other.mMiterLimit;
        this.mMaskFormat = other.mMaskFormat;
        this.mStrokeJoin = other.mStrokeJoin;
        this.mFlags = other.mFlags;
        this.mHash = other.mHash;
    }

    public static float round_mat_elem(float x) {
        return (float)Math.round(x * 1024.0f) / 1024.0f;
    }

    @Nonnull
    public StrikeDesc update(@Nonnull Font font, @Nullable Paint paint, @Nonnull Matrixc deviceMatrix) {
        if (deviceMatrix.hasPerspective()) {
            throw new IllegalArgumentException();
        }
        this.mTypeface = font.getTypeface();
        this.mTextSize = font.getSize();
        int typeMask = deviceMatrix.getType();
        if ((typeMask & 2) != 0) {
            this.mPostScaleX = StrikeDesc.round_mat_elem(deviceMatrix.getScaleX());
            this.mPostScaleY = StrikeDesc.round_mat_elem(deviceMatrix.getScaleY());
        } else {
            this.mPostScaleY = 1.0f;
            this.mPostScaleX = 1.0f;
        }
        if ((typeMask & 4) != 0) {
            this.mPostShearX = StrikeDesc.round_mat_elem(deviceMatrix.getShearX());
            this.mPostShearY = StrikeDesc.round_mat_elem(deviceMatrix.getShearY());
        } else {
            this.mPostShearY = 0.0f;
            this.mPostShearX = 0.0f;
        }
        int style2 = paint != null ? paint.getStyle() : 0;
        float strokeWidth = paint != null ? paint.getStrokeWidth() : 0.0f;
        int flags = 0;
        if (style2 != 0 && strokeWidth >= 0.0f) {
            this.mFrameWidth = strokeWidth;
            this.mMiterLimit = paint.getStrokeJoin() == 0 ? paint.getStrokeMiter() : 0.0f;
            this.mStrokeJoin = (byte)paint.getStrokeJoin();
            if (style2 == 2) {
                flags |= 1;
            }
        } else {
            this.mFrameWidth = -1.0f;
            this.mMiterLimit = 0.0f;
            this.mStrokeJoin = 0;
        }
        switch (font.getEdging()) {
            case 0: {
                byte by = 0;
                break;
            }
            case 1: {
                byte by = 1;
                break;
            }
            default: {
                assert (false);
                byte by = this.mMaskFormat = 1;
            }
        }
        if (font.isLinearMetrics()) {
            flags |= 2;
        }
        this.mFlags = (short)flags;
        this.mPathEffect = paint != null ? paint.getPathEffect() : null;
        int h2 = this.mTypeface.hashCode();
        h2 = 31 * h2 + Float.floatToIntBits(this.mTextSize);
        h2 = 31 * h2 + Float.floatToIntBits(this.mPostScaleX);
        h2 = 31 * h2 + Float.floatToIntBits(this.mPostScaleY);
        h2 = 31 * h2 + Float.floatToIntBits(this.mPostShearX);
        h2 = 31 * h2 + Float.floatToIntBits(this.mPostShearY);
        h2 = 31 * h2 + Float.floatToIntBits(this.mFrameWidth);
        h2 = 31 * h2 + Float.floatToIntBits(this.mMiterLimit);
        h2 = 31 * h2 + this.mMaskFormat;
        h2 = 31 * h2 + this.mStrokeJoin;
        h2 = 31 * h2 + this.mFlags;
        this.mHash = h2 = 31 * h2 + Objects.hashCode(this.mPathEffect);
        return this;
    }

    @Nonnull
    public StrikeDesc updateForMask(@Nonnull Font font, @Nonnull Paint paint, @Nonnull Matrixc deviceMatrix) {
        return this.update(font, paint, deviceMatrix);
    }

    public void getLocalMatrix(Matrix dst) {
        dst.setScale(this.mTextSize, this.mTextSize);
    }

    public void getDeviceMatrix(Matrix dst) {
        dst.set(this.mPostScaleX, this.mPostShearY, 0.0f, this.mPostShearX, this.mPostScaleY, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void getTotalMatrix(Matrix dst) {
        this.getDeviceMatrix(dst);
        dst.preScale(this.mTextSize, this.mTextSize);
    }

    public float getTextSize() {
        return this.mTextSize;
    }

    public float getPostScaleX() {
        return this.mPostScaleX;
    }

    public float getPostScaleY() {
        return this.mPostScaleY;
    }

    public float getPostShearX() {
        return this.mPostShearX;
    }

    public float getPostShearY() {
        return this.mPostShearY;
    }

    public float getFrameWidth() {
        return this.mFrameWidth;
    }

    public float getMiterLimit() {
        return this.mMiterLimit;
    }

    public byte getMaskFormat() {
        return this.mMaskFormat;
    }

    public int getStrokeJoin() {
        return this.mStrokeJoin;
    }

    public int getFlags() {
        return this.mFlags & 0xFFFF;
    }

    public PathEffect getPathEffect() {
        return this.mPathEffect;
    }

    @Nonnull
    public Strike findOrCreateStrike() {
        return StrikeCache.getGlobalStrikeCache().findOrCreateStrike(this);
    }

    @Nonnull
    public Strike findOrCreateStrike(@Nonnull StrikeCache cache) {
        return cache.findOrCreateStrike(this);
    }

    @Nonnull
    public ScalerContext createScalerContext() {
        return this.mTypeface.createScalerContext(this);
    }

    public int hashCode() {
        return this.mHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof StrikeDesc) {
            StrikeDesc that = (StrikeDesc)o;
            return this.mTextSize == that.mTextSize && this.mPostScaleX == that.mPostScaleX && this.mPostScaleY == that.mPostScaleY && this.mPostShearX == that.mPostShearX && this.mPostShearY == that.mPostShearY && this.mFrameWidth == that.mFrameWidth && this.mMiterLimit == that.mMiterLimit && this.mMaskFormat == that.mMaskFormat && this.mStrokeJoin == that.mStrokeJoin && this.mFlags == that.mFlags && this.mTypeface.equals(that.mTypeface) && Objects.equals(this.mPathEffect, that.mPathEffect);
        }
        return false;
    }

    @Nonnull
    public StrikeDesc copy() {
        return new StrikeDesc(this);
    }

    public long getMemorySize() {
        return 64L;
    }
}

