/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core;

import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.render.core.ImageInfo;
import yslelf.cloudpick.render.engine.BackendFormat;
import yslelf.cloudpick.render.engine.BackendImage;
import yslelf.cloudpick.render.engine.Caps;
import yslelf.cloudpick.render.engine.trash.SharedContext;

public final class SurfaceCharacterization {
    private final SharedContext mContextInfo;
    private final long mCacheMaxResourceBytes;
    private final ImageInfo mImageInfo;
    private final BackendFormat mBackendFormat;
    private final int mOrigin;
    private final int mSampleCount;
    private final boolean mTexturable;
    private final boolean mMipmapped;
    private final boolean mGLWrapDefaultFramebuffer;
    private final boolean mVkSupportInputAttachment;
    private final boolean mVkSecondaryCommandBuffer;
    private final boolean mIsProtected;

    @ApiStatus.Internal
    public SurfaceCharacterization(SharedContext contextInfo, long cacheMaxResourceBytes, ImageInfo imageInfo, BackendFormat backendFormat, int origin, int sampleCount, boolean texturable, boolean mipmapped, boolean glWrapDefaultFramebuffer, boolean vkSupportInputAttachment, boolean vkSecondaryCommandBuffer, boolean isProtected) {
        this.mContextInfo = contextInfo;
        this.mCacheMaxResourceBytes = cacheMaxResourceBytes;
        this.mImageInfo = imageInfo;
        this.mBackendFormat = backendFormat;
        this.mOrigin = origin;
        this.mSampleCount = sampleCount;
        this.mTexturable = texturable;
        this.mMipmapped = mipmapped;
        this.mGLWrapDefaultFramebuffer = glWrapDefaultFramebuffer;
        this.mVkSupportInputAttachment = vkSupportInputAttachment;
        this.mVkSecondaryCommandBuffer = vkSecondaryCommandBuffer;
        this.mIsProtected = isProtected;
        assert (this.validate());
    }

    private boolean validate() {
        Caps caps = this.mContextInfo.getCaps();
        int ct = this.getColorType();
        assert (this.mSampleCount > 0 && caps.isFormatRenderable(ct, this.mBackendFormat, this.mSampleCount));
        assert (caps.isFormatCompatible(ct, this.mBackendFormat));
        assert (!this.mMipmapped || this.mTexturable);
        assert (!this.mTexturable || !this.mGLWrapDefaultFramebuffer);
        int backend = this.mBackendFormat.getBackend();
        assert (!this.mGLWrapDefaultFramebuffer || backend == 0);
        assert (!this.mVkSecondaryCommandBuffer && !this.mVkSupportInputAttachment || backend == 1);
        assert (!this.mVkSecondaryCommandBuffer || !this.mVkSupportInputAttachment);
        assert (!this.mTexturable || !this.mVkSecondaryCommandBuffer);
        return true;
    }

    @Nullable
    public SurfaceCharacterization createResized(int width, int height) {
        Caps caps = this.mContextInfo.getCaps();
        if (caps == null) {
            return null;
        }
        if (width <= 0 || height <= 0 || width > caps.maxRenderTargetSize() || height > caps.maxRenderTargetSize()) {
            return null;
        }
        return new SurfaceCharacterization(this.mContextInfo, this.mCacheMaxResourceBytes, this.mImageInfo.makeWH(width, height), this.mBackendFormat, this.mOrigin, this.mSampleCount, this.mTexturable, this.mMipmapped, this.mGLWrapDefaultFramebuffer, this.mVkSupportInputAttachment, this.mVkSecondaryCommandBuffer, this.mIsProtected);
    }

    @Nullable
    public SurfaceCharacterization createBackendFormat(int colorType, BackendFormat backendFormat) {
        if (backendFormat == null) {
            return null;
        }
        return new SurfaceCharacterization(this.mContextInfo, this.mCacheMaxResourceBytes, this.mImageInfo.makeColorType(colorType), backendFormat, this.mOrigin, this.mSampleCount, this.mTexturable, this.mMipmapped, this.mGLWrapDefaultFramebuffer, this.mVkSupportInputAttachment, this.mVkSecondaryCommandBuffer, this.mIsProtected);
    }

    @Nullable
    public SurfaceCharacterization createDefaultFramebuffer(boolean useDefaultFramebuffer) {
        if (this.mTexturable || this.mVkSupportInputAttachment || this.mVkSecondaryCommandBuffer) {
            return null;
        }
        return new SurfaceCharacterization(this.mContextInfo, this.mCacheMaxResourceBytes, this.mImageInfo, this.mBackendFormat, this.mOrigin, this.mSampleCount, false, this.mMipmapped, useDefaultFramebuffer, false, false, this.mIsProtected);
    }

    @ApiStatus.Internal
    public SharedContext getContextInfo() {
        return this.mContextInfo;
    }

    public long getCacheMaxResourceBytes() {
        return this.mCacheMaxResourceBytes;
    }

    public ImageInfo getImageInfo() {
        return this.mImageInfo;
    }

    public BackendFormat getBackendFormat() {
        return this.mBackendFormat;
    }

    public int getOrigin() {
        return this.mOrigin;
    }

    public int getWidth() {
        return this.mImageInfo.width();
    }

    public int getHeight() {
        return this.mImageInfo.height();
    }

    public int getColorType() {
        return this.mImageInfo.colorType();
    }

    public int getSampleCount() {
        return this.mSampleCount;
    }

    public boolean isTexturable() {
        return this.mTexturable;
    }

    public boolean isMipmapped() {
        return this.mMipmapped;
    }

    public boolean glWrapDefaultFramebuffer() {
        return this.mGLWrapDefaultFramebuffer;
    }

    public boolean vkSupportInputAttachment() {
        return this.mVkSupportInputAttachment;
    }

    public boolean vkSecondaryCommandBuffer() {
        return this.mVkSecondaryCommandBuffer;
    }

    public boolean isProtected() {
        return this.mIsProtected;
    }

    public boolean isCompatible(BackendImage texture) {
        if (this.mGLWrapDefaultFramebuffer) {
            return false;
        }
        if (this.mVkSecondaryCommandBuffer) {
            return false;
        }
        if (this.mIsProtected != texture.isProtected()) {
            return false;
        }
        if (this.mMipmapped && !texture.isMipmapped()) {
            return false;
        }
        if (this.getWidth() != texture.getWidth() || this.getHeight() != texture.getHeight()) {
            return false;
        }
        return this.mBackendFormat.equals(texture.getBackendFormat());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SurfaceCharacterization that = (SurfaceCharacterization)o;
        if (this.mCacheMaxResourceBytes != that.mCacheMaxResourceBytes) {
            return false;
        }
        if (this.mOrigin != that.mOrigin) {
            return false;
        }
        if (this.mSampleCount != that.mSampleCount) {
            return false;
        }
        if (this.mTexturable != that.mTexturable) {
            return false;
        }
        if (this.mMipmapped != that.mMipmapped) {
            return false;
        }
        if (this.mGLWrapDefaultFramebuffer != that.mGLWrapDefaultFramebuffer) {
            return false;
        }
        if (this.mVkSupportInputAttachment != that.mVkSupportInputAttachment) {
            return false;
        }
        if (this.mVkSecondaryCommandBuffer != that.mVkSecondaryCommandBuffer) {
            return false;
        }
        if (this.mIsProtected != that.mIsProtected) {
            return false;
        }
        if (!this.mContextInfo.equals(that.mContextInfo)) {
            return false;
        }
        if (!this.mImageInfo.equals(that.mImageInfo)) {
            return false;
        }
        return this.mBackendFormat.equals(that.mBackendFormat);
    }

    public int hashCode() {
        int result = this.mContextInfo.hashCode();
        result = 31 * result + (int)(this.mCacheMaxResourceBytes ^ this.mCacheMaxResourceBytes >>> 32);
        result = 31 * result + this.mImageInfo.hashCode();
        result = 31 * result + this.mBackendFormat.hashCode();
        result = 31 * result + this.mOrigin;
        result = 31 * result + this.mSampleCount;
        result = 31 * result + (this.mTexturable ? 1 : 0);
        result = 31 * result + (this.mMipmapped ? 1 : 0);
        result = 31 * result + (this.mGLWrapDefaultFramebuffer ? 1 : 0);
        result = 31 * result + (this.mVkSupportInputAttachment ? 1 : 0);
        result = 31 * result + (this.mVkSecondaryCommandBuffer ? 1 : 0);
        result = 31 * result + (this.mIsProtected ? 1 : 0);
        return result;
    }
}

