/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core;

import java.lang.ref.Reference;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.render.core.Font;
import yslelf.cloudpick.render.core.Glyph;
import yslelf.cloudpick.render.core.MathUtil;
import yslelf.cloudpick.render.core.Matrix;
import yslelf.cloudpick.render.core.Rect2f;
import yslelf.cloudpick.render.core.Rect2fc;
import yslelf.cloudpick.render.core.Strike;
import yslelf.cloudpick.render.core.StrikeDesc;

public final class TextBlob {
    private final int mRunCount;
    private final Font[] mFonts;
    private final int[] mCounts;
    private final int[] mGlyphs;
    private final float[] mPositions;
    private final Rect2f mBounds;

    @Nullable
    public static TextBlob make(@Nonnull int[] glyphs, int glyphOffset, @Nonnull float[] positions, int positionOffset, int glyphCount, @Nonnull Font font, @Nullable Rect2fc bounds) {
        if (glyphCount <= 0) {
            return null;
        }
        return TextBlob.makeNoCopy(Arrays.copyOfRange(glyphs, glyphOffset, glyphOffset + glyphCount), Arrays.copyOfRange(positions, positionOffset, positionOffset + glyphCount * 2), new Font(font), bounds);
    }

    @ApiStatus.Internal
    public static TextBlob makeNoCopy(@Nonnull int[] glyphs, @Nonnull float[] positions, @Nonnull Font font, @Nullable Rect2fc bounds) {
        assert (glyphs.length > 0 && positions.length == glyphs.length * 2);
        Rect2f finalBounds = new Rect2f();
        if (bounds != null) {
            bounds.store(finalBounds);
        } else {
            TextBlob.computeTightBounds(glyphs, 0, positions, 0, glyphs.length, font, finalBounds);
        }
        return new TextBlob(1, new Font[]{font}, new int[]{glyphs.length}, glyphs, positions, finalBounds);
    }

    static void computeTightBounds(int[] glyphs, int glyphOffset, float[] positions, int positionOffset, int glyphCount, Font font, Rect2f bounds) {
        Glyph[] glyphPtrs = new Glyph[glyphCount];
        Strike strike = new StrikeDesc().update(font, null, Matrix.identity()).findOrCreateStrike();
        strike.getMetrics(glyphs, glyphOffset, glyphCount, glyphPtrs);
        int i = 0;
        int j = positionOffset;
        while (i < glyphCount) {
            Glyph glyphPtr = glyphPtrs[i];
            if (!glyphPtr.isEmpty()) {
                float l2 = (float)glyphPtr.getLeft() + positions[j];
                float t2 = (float)glyphPtr.getTop() + positions[j + 1];
                float r = (float)(glyphPtr.getLeft() + glyphPtr.getWidth()) + positions[j];
                float b = (float)(glyphPtr.getTop() + glyphPtr.getHeight()) + positions[j + 1];
                bounds.join(l2, t2, r, b);
            }
            ++i;
            j += 2;
        }
    }

    TextBlob(int runCount, Font[] fonts, int[] counts, int[] glyphs, float[] positions, Rect2f bounds) {
        this.mRunCount = runCount;
        this.mFonts = fonts;
        this.mCounts = counts;
        this.mGlyphs = glyphs;
        this.mPositions = positions;
        this.mBounds = bounds;
    }

    @Nonnull
    public Rect2fc getBounds() {
        return this.mBounds;
    }

    public void getBounds(@Nonnull Rect2f bounds) {
        this.mBounds.store(bounds);
    }

    @ApiStatus.Internal
    public int getRunCount() {
        return this.mRunCount;
    }

    @ApiStatus.Internal
    public Font[] getFonts() {
        return this.mFonts;
    }

    @ApiStatus.Internal
    public int[] getCounts() {
        return this.mCounts;
    }

    @ApiStatus.Internal
    public int[] getGlyphs() {
        return this.mGlyphs;
    }

    @ApiStatus.Internal
    public float[] getPositions() {
        return this.mPositions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Reference) {
            Reference r = (Reference)o;
            return r.refersTo(this);
        }
        return false;
    }

    public static final class Builder {
        private int[] mGlyphs;
        private int mGlyphOffset;
        private float[] mPositions;
        private int mPositionOffset;
        private Font[] mFonts;
        private int[] mCounts;
        private int mRunCount;
        private Rect2f mBounds = new Rect2f();
        private boolean mDeferredBounds = false;
        private final RunBuffer mCurrentRunBuffer = new RunBuffer();

        @Nonnull
        public RunBuffer allocRunPos(@Nonnull Font font, int count, @Nullable Rect2fc bounds) {
            if (count <= 0) {
                return this.mCurrentRunBuffer;
            }
            if (count > 0x3FFFFFFF || this.mPositions != null && (long)this.mPositions.length + (long)count * 2L > Integer.MAX_VALUE) {
                throw new IllegalStateException();
            }
            if (!this.mergeRun(font, count)) {
                this.updateDeferredBounds();
                if (this.mGlyphs != null) {
                    this.mGlyphOffset = this.mGlyphs.length;
                    this.mPositionOffset = this.mPositions.length;
                } else {
                    assert (this.mGlyphOffset == 0);
                    assert (this.mPositionOffset == 0);
                }
                this.reserve(count, true);
                this.mFonts[this.mRunCount] = new Font(font);
                this.mCounts[this.mRunCount] = count;
                ++this.mRunCount;
            }
            if (!this.mDeferredBounds) {
                if (bounds != null) {
                    this.mBounds.join(bounds);
                } else {
                    this.mDeferredBounds = true;
                }
            }
            return this.mCurrentRunBuffer;
        }

        @Nullable
        public TextBlob build() {
            if (this.mRunCount == 0) {
                assert (this.mGlyphs == null);
                assert (this.mPositions == null);
                assert (this.mGlyphOffset == 0);
                assert (this.mPositionOffset == 0);
                assert (this.mFonts == null);
                assert (this.mCounts == null);
                assert (this.mBounds.isEmpty());
                return null;
            }
            this.updateDeferredBounds();
            assert (this.validate());
            TextBlob blob = new TextBlob(this.mRunCount, this.mFonts, this.mCounts, this.mGlyphs, this.mPositions, this.mBounds);
            this.mGlyphs = null;
            this.mPositions = null;
            this.mGlyphOffset = 0;
            this.mPositionOffset = 0;
            this.mFonts = null;
            this.mCounts = null;
            this.mRunCount = 0;
            this.mBounds = new Rect2f();
            return blob;
        }

        private boolean mergeRun(@Nonnull Font font, int count) {
            assert (count > 0);
            if (this.mRunCount == 0) {
                return false;
            }
            int lastRun = this.mRunCount - 1;
            Font lastRunFont = this.mFonts[lastRun];
            int lastRunCount = this.mCounts[lastRun];
            assert (lastRunCount > 0);
            if (!lastRunFont.equals(font)) {
                return false;
            }
            assert (lastRunCount + count > lastRunCount);
            this.mGlyphOffset = this.mGlyphs.length;
            this.mPositionOffset = this.mPositions.length;
            this.reserve(count, false);
            int n2 = lastRun;
            this.mCounts[n2] = this.mCounts[n2] + count;
            return true;
        }

        private void reserve(int count, boolean addRun) {
            assert (count > 0);
            if (this.mGlyphs == null) {
                assert (this.mPositions == null);
                this.mGlyphs = new int[count];
                this.mPositions = new float[count * 2];
            } else {
                assert (this.mPositions != null);
                this.mGlyphs = Arrays.copyOf(this.mGlyphs, this.mGlyphs.length + count);
                this.mPositions = Arrays.copyOf(this.mPositions, this.mPositions.length + count * 2);
            }
            if (addRun) {
                if (this.mFonts == null) {
                    assert (this.mCounts == null);
                    this.mFonts = new Font[1];
                    this.mCounts = new int[1];
                } else if (this.mRunCount == this.mFonts.length) {
                    assert (this.mCounts != null);
                    int cap = this.mFonts.length + MathUtil.clamp(this.mFonts.length >> 3, 4, 1024);
                    assert (cap > 0);
                    this.mFonts = Arrays.copyOf(this.mFonts, cap);
                    this.mCounts = Arrays.copyOf(this.mCounts, cap);
                }
            }
        }

        private void updateDeferredBounds() {
            assert (!this.mDeferredBounds || this.mRunCount > 0);
            if (!this.mDeferredBounds) {
                return;
            }
            int lastRun = this.mRunCount - 1;
            Font lastRunFont = this.mFonts[lastRun];
            int lastRunCount = this.mCounts[lastRun];
            TextBlob.computeTightBounds(this.mGlyphs, this.mGlyphOffset - lastRunCount, this.mPositions, this.mPositionOffset - lastRunCount * 2, lastRunCount, lastRunFont, this.mBounds);
            this.mDeferredBounds = false;
        }

        private boolean validate() {
            int count = 0;
            for (int i = 0; i < this.mRunCount; ++i) {
                assert (this.mFonts[i] != null);
                assert (this.mCounts[i] > 0);
                count += this.mCounts[i];
            }
            assert (this.mGlyphs.length == count);
            assert (this.mPositions.length == count * 2);
            return true;
        }

        public final class RunBuffer {
            public RunBuffer addGlyph(int glyph) {
                Builder.this.mGlyphs[Builder.this.mGlyphOffset++] = glyph;
                return this;
            }

            public RunBuffer addPosition(float x, float y) {
                Builder.this.mPositions[Builder.this.mPositionOffset++] = x;
                Builder.this.mPositions[Builder.this.mPositionOffset++] = y;
                return this;
            }

            public RunBuffer addGlyphs(@Nonnull int[] glyphs, int offset, int count) {
                System.arraycopy(glyphs, offset, Builder.this.mGlyphs, Builder.this.mGlyphOffset, count);
                Builder.this.mGlyphOffset += count;
                return this;
            }

            public RunBuffer addPositions(@Nonnull float[] positions, int offset, int count) {
                System.arraycopy(positions, offset, Builder.this.mPositions, Builder.this.mPositionOffset, count * 2);
                Builder.this.mPositionOffset += count * 2;
                return this;
            }
        }
    }
}

