/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.render.core.Rect2f;
import yslelf.cloudpick.render.core.Rect2fc;

public class Vertices {
    public static final int kPoints_VertexMode = 0;
    public static final int kLines_VertexMode = 1;
    public static final int kLineStrip_VertexMode = 2;
    public static final int kTriangles_VertexMode = 3;
    public static final int kTriangleStrip_VertexMode = 4;
    public static final int kVertexModeCount = 5;
    private final int mVertexMode;
    private final float[] mPositions;
    private final float[] mTexCoords;
    private final byte[] mColors;
    private final short[] mIndices;
    private final int mVertexCount;
    private final int mIndexCount;
    private final Rect2f mBounds;

    Vertices(int vertexMode, float[] positions, float[] texCoords, byte[] colors, short[] indices, int vertexCount, int indexCount) {
        this.mVertexMode = vertexMode;
        this.mPositions = positions;
        this.mTexCoords = texCoords;
        this.mColors = colors;
        this.mIndices = indices;
        this.mVertexCount = vertexCount;
        this.mIndexCount = indexCount;
        Rect2f bounds = new Rect2f();
        bounds.setBounds(positions, 0, vertexCount);
        if (vertexMode == 0 || vertexMode == 1 || vertexMode == 2) {
            bounds.outset(1.0f, 1.0f);
        }
        this.mBounds = bounds;
    }

    @Nonnull
    public static Vertices makeCopy(int vertexMode, int vertexCount, @Nonnull float[] positions, int positionOffset, @Nullable float[] texCoords, int texCoordOffset, @Nullable int[] colors, int colorOffset) {
        return Vertices.makeCopy(vertexMode, vertexCount, positions, positionOffset, texCoords, texCoordOffset, colors, colorOffset, null, 0, 0);
    }

    @Nonnull
    public static Vertices makeCopy(int vertexMode, int vertexCount, @Nonnull float[] positions, int positionOffset, @Nullable float[] texCoords, int texCoordOffset, @Nullable int[] colors, int colorOffset, @Nullable short[] indices, int indexOffset, int indexCount) {
        float[] newPositions = Arrays.copyOfRange(positions, positionOffset, positionOffset + vertexCount * 2);
        float[] newTexCoords = null;
        if (texCoords != null) {
            newTexCoords = Arrays.copyOfRange(texCoords, texCoordOffset, texCoordOffset + vertexCount * 2);
        }
        byte[] newColors = null;
        if (colors != null) {
            newColors = new byte[vertexCount * 4];
            int i = 0;
            int j = colorOffset;
            int k = 0;
            while (i < vertexCount) {
                int color = colors[j];
                newColors[k] = (byte)(color >> 16 & 0xFF);
                newColors[k | 1] = (byte)(color >> 8 & 0xFF);
                newColors[k | 2] = (byte)(color & 0xFF);
                newColors[k | 3] = (byte)(color >>> 24);
                ++i;
                ++j;
                k += 4;
            }
        }
        short[] newIndices = null;
        if (indices != null) {
            newIndices = Arrays.copyOfRange(indices, indexOffset, indexOffset + indexCount);
        }
        return new Vertices(vertexMode, newPositions, newTexCoords, newColors, newIndices, vertexCount, indexCount);
    }

    @Nonnull
    public static Vertices makeCopy(int vertexMode, @Nonnull FloatBuffer positions, @Nullable FloatBuffer texCoords, @Nullable IntBuffer colors, @Nullable ShortBuffer indices) {
        int vertexCount = positions.remaining() / 2;
        float[] newPositions = new float[vertexCount * 2];
        positions.get(positions.position(), newPositions);
        float[] newTexCoords = null;
        if (texCoords != null) {
            newTexCoords = new float[vertexCount * 2];
            texCoords.get(texCoords.position(), newTexCoords);
        }
        byte[] newColors = null;
        if (colors != null) {
            newColors = new byte[vertexCount * 4];
            int i = 0;
            int j = colors.position();
            int k = 0;
            while (i < vertexCount) {
                int color = colors.get(j);
                newColors[k] = (byte)(color >> 16 & 0xFF);
                newColors[k | 1] = (byte)(color >> 8 & 0xFF);
                newColors[k | 2] = (byte)(color & 0xFF);
                newColors[k | 3] = (byte)(color >>> 24);
                ++i;
                ++j;
                k += 4;
            }
        }
        int indexCount = 0;
        short[] newIndices = null;
        if (indices != null) {
            indexCount = indices.remaining();
            newIndices = new short[indexCount];
            indices.get(indices.position(), newIndices);
        }
        return new Vertices(vertexMode, newPositions, newTexCoords, newColors, newIndices, vertexCount, indexCount);
    }

    @Nonnull
    public Rect2fc getBounds() {
        return this.mBounds;
    }

    public void getBounds(Rect2f bounds) {
        this.mBounds.store(bounds);
    }

    @ApiStatus.Internal
    public int getVertexMode() {
        return this.mVertexMode;
    }

    @ApiStatus.Internal
    public boolean hasColors() {
        return this.mColors != null;
    }

    @ApiStatus.Internal
    public boolean hasTexCoords() {
        return this.mTexCoords != null;
    }

    @ApiStatus.Internal
    public boolean hasIndices() {
        return this.mIndices != null;
    }

    @ApiStatus.Internal
    public int getVertexCount() {
        return this.mVertexCount;
    }

    @ApiStatus.Internal
    public int getIndexCount() {
        return this.mIndexCount;
    }

    @ApiStatus.Internal
    public float[] getPositions() {
        return this.mPositions;
    }

    @ApiStatus.Internal
    public float[] getTexCoords() {
        return this.mTexCoords;
    }

    @ApiStatus.Internal
    public byte[] getColors() {
        return this.mColors;
    }

    @ApiStatus.Internal
    public short[] getIndices() {
        return this.mIndices;
    }
}

