/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core.effects;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.Color;
import yslelf.cloudpick.render.core.ColorInt;
import yslelf.cloudpick.render.core.ColorSpace;
import yslelf.cloudpick.render.core.MathUtil;
import yslelf.cloudpick.render.core.RefCounted;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.core.Size;
import yslelf.cloudpick.render.core.effects.ComposeColorFilter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ColorFilter
extends RefCounted {
    default public boolean isAlphaUnchanged() {
        return false;
    }

    @ColorInt
    default public int filterColor(@ColorInt int col) {
        float[] dst4 = Color.load_and_premul(col);
        this.filterColor4f(dst4, dst4, null);
        float a = MathUtil.clamp(dst4[3], 0.0f, 1.0f);
        int result = (int)(a * 255.0f + 0.5f) << 24;
        if (result == 0) {
            return 0;
        }
        a = 255.0f / a;
        for (int i = 0; i < 3; ++i) {
            result |= (int)MathUtil.clamp(dst4[2 - i] * a + 0.5f, 0.0f, 255.0f) << (i << 3);
        }
        return result;
    }

    public void filterColor4f(@Size(value=4L) float[] var1, @Size(value=4L) float[] var2, ColorSpace var3);

    @Nonnull
    @SharedPtr
    default public ColorFilter compose(@Nullable @SharedPtr ColorFilter before) {
        this.ref();
        if (before == null) {
            return this;
        }
        return new ComposeColorFilter(before, this);
    }

    @Nonnull
    @SharedPtr
    default public ColorFilter andThen(@Nullable @SharedPtr ColorFilter after) {
        this.ref();
        if (after == null) {
            return this;
        }
        return new ComposeColorFilter(this, after);
    }
}

