/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core.effects;

import java.util.Objects;
import yslelf.cloudpick.render.core.ColorSpace;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.core.effects.ColorFilter;

public final class ComposeColorFilter
extends RefCnt
implements ColorFilter {
    @SharedPtr
    private final ColorFilter mAfter;
    @SharedPtr
    private final ColorFilter mBefore;

    ComposeColorFilter(@SharedPtr ColorFilter before, @SharedPtr ColorFilter after) {
        this.mBefore = Objects.requireNonNull(before);
        this.mAfter = Objects.requireNonNull(after);
    }

    @Override
    protected void deallocate() {
        this.mAfter.unref();
        this.mBefore.unref();
    }

    @RawPtr
    public ColorFilter getBefore() {
        return this.mBefore;
    }

    @RawPtr
    public ColorFilter getAfter() {
        return this.mAfter;
    }

    @Override
    public boolean isAlphaUnchanged() {
        return this.mAfter.isAlphaUnchanged() && this.mBefore.isAlphaUnchanged();
    }

    @Override
    public void filterColor4f(float[] col, float[] out, ColorSpace dstCS) {
        this.mBefore.filterColor4f(col, out, dstCS);
        this.mAfter.filterColor4f(out, out, dstCS);
    }
}

