/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core.image;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import yslelf.cloudpick.render.core.Image;
import yslelf.cloudpick.render.core.PixelUtils;
import yslelf.cloudpick.render.core.Pixels;
import yslelf.cloudpick.render.core.Pixmap;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;

public class RasterImage
extends Image {
    public static final int COPY_MODE_IF_MUTABLE = 0;
    public static final int COPY_MODE_ALWAYS = 1;
    public static final int COPY_MODE_NEVER = 2;
    final Pixmap mPixmap;
    @SharedPtr
    Pixels mPixels;

    public RasterImage(@Nonnull Pixmap pixmap, @Nonnull @RawPtr Pixels pixels, boolean mayBeMutable) {
        super(pixmap.getInfo());
        if (!mayBeMutable && !pixels.isImmutable()) {
            throw new IllegalArgumentException();
        }
        this.mPixmap = pixmap;
        this.mPixels = RefCnt.create(pixels);
    }

    @Nullable
    @SharedPtr
    public static Image makeFromBitmap(@Nonnull Pixmap pixmap, @RawPtr Pixels pixels) {
        return RasterImage.makeFromRasterBitmap(pixmap, pixels, 0);
    }

    @Nullable
    @SharedPtr
    public static Image makeFromRasterBitmap(@Nonnull Pixmap pixmap, @RawPtr Pixels pixels, int copyMode) {
        if (pixels == null) {
            return null;
        }
        if (!pixmap.getInfo().isValid() || pixmap.getRowBytes() < pixmap.getInfo().minRowBytes()) {
            return null;
        }
        if (pixels.getAddress() == 0L && pixels.getBase() == null) {
            return null;
        }
        if (copyMode == 1 || !pixels.isImmutable() && copyMode != 2) {
            long size = pixmap.getInfo().computeByteSize(pixmap.getRowBytes());
            if (size < 0L) {
                return null;
            }
            long addr = MemoryUtil.nmemAlloc((long)size);
            if (addr == 0L) {
                return null;
            }
            PixelUtils.copyImage(pixels.getBase(), pixels.getAddress(), pixmap.getRowBytes(), null, addr, pixmap.getRowBytes(), pixmap.getRowBytes(), pixmap.getHeight());
            Pixmap newPixmap = new Pixmap(pixmap.getInfo(), null, addr, pixmap.getRowBytes());
            Pixels newPixels = new Pixels(pixmap.getWidth(), pixmap.getHeight(), null, addr, pixmap.getRowBytes(), MemoryUtil::nmemFree);
            newPixels.setImmutable();
            RasterImage result = new RasterImage(newPixmap, newPixels, false);
            newPixels.unref();
            return result;
        }
        return new RasterImage(pixmap, pixels, copyMode == 2);
    }

    @Override
    protected void deallocate() {
        this.mPixels = RefCnt.move(this.mPixels);
    }

    @Override
    public boolean isRasterBacked() {
        return true;
    }
}

