/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core.j2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.render.core.BlendMode;
import yslelf.cloudpick.render.core.Matrixc;
import yslelf.cloudpick.render.core.Paint;
import yslelf.cloudpick.render.core.Path;
import yslelf.cloudpick.render.core.PathUtils;
import yslelf.cloudpick.render.core.Rect2fc;
import yslelf.cloudpick.render.core.j2d.J2DUtils;

@ApiStatus.Internal
public class DrawBase {
    public Graphics2D mG2D;
    public Matrixc mCTM;
    public Shape mClip;
    private static final float MAX_FOR_MATH = 8.5070587E37f;
    private static final BasicStroke sHairlineStroke = new BasicStroke(0.0f);

    public void drawPath(Path path, Paint paint) {
        boolean doFill = true;
        Path tmpPath = new Path();
        if (paint.getStyle() != 0 || paint.getPathEffect() != null) {
            doFill = PathUtils.fillPathWithPaint(path, paint, tmpPath, null, this.mCTM);
            path = tmpPath;
        }
        path.transform(this.mCTM, tmpPath);
        this.drawDevicePath(tmpPath, paint, doFill);
        tmpPath.recycle();
    }

    private void drawDevicePath(Path path, Paint paint, boolean doFill) {
        Rect2fc bounds = path.getBounds();
        if (!(bounds.left() >= -8.5070587E37f && bounds.top() >= -8.5070587E37f && bounds.right() <= 8.5070587E37f && bounds.bottom() <= 8.5070587E37f)) {
            return;
        }
        Path2D j2dPath = J2DUtils.toPath2D(path, null);
        this.mG2D.setTransform(new AffineTransform());
        this.preparePaint(paint);
        if (doFill) {
            this.mG2D.fill(j2dPath);
        } else {
            this.mG2D.setStroke(sHairlineStroke);
            this.mG2D.draw(j2dPath);
        }
    }

    private void preparePaint(Paint paint) {
        this.mG2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, paint.isAntiAlias() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.mG2D.setRenderingHint(RenderingHints.KEY_DITHERING, paint.isDither() ? RenderingHints.VALUE_DITHER_ENABLE : RenderingHints.VALUE_DITHER_DEFAULT);
        this.mG2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.mG2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        this.mG2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        this.mG2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.mG2D.setColor(new Color(paint.r(), paint.g(), paint.b(), paint.a()));
        BlendMode bm = paint.getBlendMode();
        if (bm == null) {
            bm = BlendMode.SRC_OVER;
        }
        AlphaComposite comp = switch (bm) {
            case BlendMode.CLEAR -> AlphaComposite.Clear;
            case BlendMode.SRC -> AlphaComposite.Src;
            case BlendMode.DST -> AlphaComposite.Dst;
            case BlendMode.SRC_OVER -> AlphaComposite.SrcOver;
            case BlendMode.DST_OVER -> AlphaComposite.DstOver;
            case BlendMode.SRC_IN -> AlphaComposite.SrcIn;
            case BlendMode.DST_IN -> AlphaComposite.DstIn;
            case BlendMode.SRC_OUT -> AlphaComposite.SrcOut;
            case BlendMode.DST_OUT -> AlphaComposite.DstOut;
            case BlendMode.SRC_ATOP -> AlphaComposite.SrcAtop;
            case BlendMode.DST_ATOP -> AlphaComposite.DstAtop;
            case BlendMode.XOR -> AlphaComposite.Xor;
            default -> AlphaComposite.SrcOver;
        };
        this.mG2D.setComposite(comp);
    }
}

