/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core.j2d;

import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.Path;
import yslelf.cloudpick.render.core.PathConsumer;
import yslelf.cloudpick.render.core.PathIterable;

public class J2DUtils {
    @Nonnull
    public static Path2D toPath2D(@Nonnull Path src, @Nullable Path2D dst) {
        int winding = J2DUtils.toWindingRule(src.getFillRule());
        if (dst == null) {
            dst = new Path2D.Float(winding, src.countVerbs());
        } else {
            dst.reset();
            dst.setWindingRule(winding);
        }
        return new J2DPathConverter().convert(src, dst);
    }

    public static Path toPath(@Nonnull PathIterator pi, @Nullable Path dst) {
        if (dst == null) {
            dst = new Path();
        }
        dst.setFillRule(J2DUtils.toFillRule(pi.getWindingRule()));
        float[] coords = new float[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    dst.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    dst.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    dst.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    dst.cubicTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    dst.close();
                }
            }
            pi.next();
        }
        return dst;
    }

    public static int toWindingRule(int fillRule) {
        return switch (fillRule) {
            case 0 -> 1;
            case 1 -> 0;
            default -> throw new AssertionError(fillRule);
        };
    }

    public static int toFillRule(int windingRule) {
        return switch (windingRule) {
            case 1 -> 0;
            case 0 -> 1;
            default -> throw new AssertionError(windingRule);
        };
    }

    public static class J2DPathConverter
    implements PathConsumer {
        private Path2D mDst;

        public Path2D convert(PathIterable src, Path2D dst) {
            this.mDst = dst;
            src.forEach(this);
            this.mDst = null;
            return dst;
        }

        @Override
        public void moveTo(float x, float y) {
            this.mDst.moveTo(x, y);
        }

        @Override
        public void lineTo(float x, float y) {
            this.mDst.lineTo(x, y);
        }

        @Override
        public void quadTo(float x1, float y1, float x2, float y2) {
            this.mDst.quadTo(x1, y1, x2, y2);
        }

        @Override
        public void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.mDst.curveTo(x1, y1, x2, y2, x3, y3);
        }

        @Override
        public void close() {
            this.mDst.closePath();
        }

        @Override
        public void done() {
        }
    }
}

