/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core.j2d;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import sun.misc.Unsafe;
import yslelf.cloudpick.render.core.ColorSpace;
import yslelf.cloudpick.render.core.ImageInfo;
import yslelf.cloudpick.render.core.Pixels;
import yslelf.cloudpick.render.core.Pixmap;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.Size;

public class Raster
implements AutoCloseable {
    public static final int FORMAT_UNKNOWN = 0;
    public static final int FORMAT_GRAY_8 = 1;
    public static final int FORMAT_GRAY_16 = 2;
    public static final int FORMAT_RGB_565 = 3;
    public static final int FORMAT_RGB_888 = 4;
    @Nullable
    protected final BufferedImage mBufImg;
    protected Pixmap mPixmap;
    protected Pixels mPixels;

    public Raster(@Nullable BufferedImage bufImg, @Nonnull ImageInfo info, @Nullable Object data, int baseOffset, int rowBytes) {
        this.mBufImg = bufImg;
        this.mPixmap = new Pixmap(info, data, baseOffset, rowBytes);
        this.mPixels = new Pixels(info.width(), info.height(), data, baseOffset, rowBytes, null);
    }

    @Nonnull
    public static Raster createRaster(@Size(min=1L) int width, @Size(min=1L) int height, int format) {
        byte[] data;
        int baseOffset;
        BufferedImage bufImg;
        int rowBytes;
        int at;
        int ct;
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Image dimensions " + width + "x" + height + " must be positive");
        }
        if (width > 32768 || height > 32768) {
            throw new IllegalArgumentException("Image dimensions " + width + "x" + height + " must be less than or equal to 32768");
        }
        int imageType = switch (format) {
            case 1 -> {
                ct = 22;
                at = 1;
                rowBytes = width;
                yield 10;
            }
            case 2 -> {
                ct = 0;
                at = 1;
                rowBytes = width << 1;
                yield 11;
            }
            case 3 -> {
                ct = 1;
                at = 1;
                rowBytes = width << 1;
                yield 8;
            }
            case 4 -> {
                ct = 0;
                at = 1;
                rowBytes = width * 3;
                if (rowBytes * height < 0) {
                    throw new IllegalArgumentException("Image is too large");
                }
                yield 5;
            }
            case 0 -> {
                ct = 0;
                at = 0;
                rowBytes = 0;
                yield 0;
            }
            default -> throw new IllegalArgumentException("Unrecognized format " + format);
        };
        ImageInfo info = new ImageInfo(width, height, ct, at);
        if (imageType != 0) {
            bufImg = new BufferedImage(width, height, imageType);
            data = switch (imageType) {
                case 5, 10 -> {
                    DataBuffer dataBuffer = (DataBufferByte)bufImg.getRaster().getDataBuffer();
                    if (!$assertionsDisabled && dataBuffer.getNumBanks() != 1) {
                        throw new AssertionError();
                    }
                    baseOffset = Unsafe.ARRAY_BYTE_BASE_OFFSET;
                    yield ((DataBufferByte)dataBuffer).getData();
                }
                case 8, 11 -> {
                    DataBuffer dataBuffer = (DataBufferUShort)bufImg.getRaster().getDataBuffer();
                    if (!$assertionsDisabled && dataBuffer.getNumBanks() != 1) {
                        throw new AssertionError();
                    }
                    baseOffset = Unsafe.ARRAY_SHORT_BASE_OFFSET;
                    yield (Object[])((DataBufferUShort)dataBuffer).getData();
                }
                default -> {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    baseOffset = 0;
                    yield null;
                }
            };
        } else {
            bufImg = null;
            data = null;
            baseOffset = 0;
        }
        return new Raster(bufImg, info, data, baseOffset, rowBytes);
    }

    public int getFormat() {
        if (this.mBufImg == null) {
            return 0;
        }
        return switch (this.mBufImg.getType()) {
            case 10 -> 1;
            case 11 -> 2;
            case 8 -> 3;
            case 5 -> 4;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                yield 0;
            }
        };
    }

    @Nonnull
    public ImageInfo getInfo() {
        return this.mPixmap.getInfo();
    }

    public int getWidth() {
        return this.mPixmap.getWidth();
    }

    public int getHeight() {
        return this.mPixmap.getHeight();
    }

    public int getColorType() {
        return this.mPixmap.getColorType();
    }

    public int getAlphaType() {
        return this.mPixmap.getAlphaType();
    }

    @Nullable
    public ColorSpace getColorSpace() {
        return this.mPixmap.getColorSpace();
    }

    public Pixmap getPixmap() {
        return this.mPixmap;
    }

    @RawPtr
    public Pixels getPixels() {
        return this.mPixels;
    }

    @Override
    public void close() {
        this.mPixels = RefCnt.move(this.mPixels);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @ApiStatus.Internal
    public static @interface Format {
    }
}

