/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core.shaders;

import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.BlendMode;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.core.shaders.ColorShader;
import yslelf.cloudpick.render.core.shaders.Shader;

public final class BlendShader
extends RefCnt
implements Shader {
    private final BlendMode mMode;
    @SharedPtr
    private final Shader mSrc;
    @SharedPtr
    private final Shader mDst;

    BlendShader(BlendMode mode, @SharedPtr Shader src, @SharedPtr Shader dst) {
        this.mMode = mode;
        this.mSrc = src;
        this.mDst = dst;
    }

    @Nullable
    @SharedPtr
    public static Shader make(BlendMode mode, @SharedPtr Shader src, @SharedPtr Shader dst) {
        if (src == null || dst == null || mode == null) {
            RefCnt.move(src);
            RefCnt.move(dst);
            return null;
        }
        switch (mode) {
            case CLEAR: {
                RefCnt.move(src);
                RefCnt.move(dst);
                return new ColorShader(0);
            }
            case SRC: {
                RefCnt.move(dst);
                return src;
            }
            case DST: {
                RefCnt.move(src);
                return dst;
            }
        }
        return new BlendShader(mode, src, dst);
    }

    @Override
    protected void deallocate() {
        this.mSrc.unref();
        this.mDst.unref();
    }

    public BlendMode getMode() {
        return this.mMode;
    }

    @RawPtr
    public Shader getSrc() {
        return this.mSrc;
    }

    @RawPtr
    public Shader getDst() {
        return this.mDst;
    }
}

