/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core.shaders;

import yslelf.cloudpick.render.core.shaders.Shader;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class GradientShader
implements Shader {
    public static final float kDegenerateTolerance = 1.5258789E-5f;

    @Override
    public void ref() {
    }

    @Override
    public void unref() {
    }

    public static class Interpolation {
        public static final byte kDestination_ColorSpace = 0;
        public static final byte kSRGB_ColorSpace = 1;
        public static final byte kSRGBLinear_ColorSpace = 2;
        public static final byte kLab_ColorSpace = 3;
        public static final byte kOKLab_ColorSpace = 4;
        public static final byte kOKLabGamutMap_ColorSpace = 5;
        public static final byte kHSL_ColorSpace = 6;
        public static final byte kHWB_ColorSpace = 7;
        public static final byte kLCH_ColorSpace = 8;
        public static final byte kOKLCH_ColorSpace = 9;
        public static final byte kOKLCHGamutMap_ColorSpace = 10;
        public static final byte kLast_ColorSpace = 10;
        public static final int kColorSpaceCount = 11;
        public static final byte kShorter_HueMethod = 0;
        public static final byte kLonger_HueMethod = 1;
        public static final byte kIncreasing_HueMethod = 2;
        public static final byte kDecreasing_HueMethod = 3;
        public static final byte kLast_HueMethod = 3;
        public static final int kHueMethodCount = 4;

        public static int make(boolean inPremul, byte colorSpace, byte hueMethod) {
            assert (colorSpace >= 0 && colorSpace <= 10);
            assert (hueMethod >= 0 && hueMethod <= 3);
            return (inPremul ? 1 : 0) | colorSpace << 8 | hueMethod << 16;
        }

        public static boolean isInPremul(int interpolation) {
            return (interpolation & 1) != 0;
        }

        public static byte getColorSpace(int interpolation) {
            return (byte)(interpolation >> 8);
        }

        public static byte getHueMethod(int interpolation) {
            return (byte)(interpolation >> 16);
        }
    }
}

