/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core.shaders;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.BlendMode;
import yslelf.cloudpick.render.core.Image;
import yslelf.cloudpick.render.core.Matrix;
import yslelf.cloudpick.render.core.Matrixc;
import yslelf.cloudpick.render.core.Paint;
import yslelf.cloudpick.render.core.RawPtr;
import yslelf.cloudpick.render.core.Rect2f;
import yslelf.cloudpick.render.core.Rect2fc;
import yslelf.cloudpick.render.core.RefCnt;
import yslelf.cloudpick.render.core.SamplingOptions;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.core.shaders.BlendShader;
import yslelf.cloudpick.render.core.shaders.EmptyShader;
import yslelf.cloudpick.render.core.shaders.LocalMatrixShader;
import yslelf.cloudpick.render.core.shaders.Shader;

public final class ImageShader
extends RefCnt
implements Shader {
    @SharedPtr
    public final Image mImage;
    public final SamplingOptions mSampling;
    public final int mTileModeX;
    public final int mTileModeY;
    public final Rect2f mSubset;

    ImageShader(Image image, Rect2fc subset, int tileModeX, int tileModeY, SamplingOptions sampling) {
        this.mImage = image;
        this.mSampling = sampling;
        this.mTileModeX = tileModeX;
        this.mTileModeY = tileModeY;
        this.mSubset = new Rect2f(subset);
    }

    @Nullable
    @SharedPtr
    public static Shader make(@SharedPtr Image image, int tileModeX, int tileModeY, SamplingOptions sampling, @Nullable Matrixc localMatrix) {
        Rect2fc subset = image != null ? new Rect2f(0.0f, 0.0f, image.getWidth(), image.getHeight()) : Rect2f.empty();
        return ImageShader.makeSubset(image, subset, tileModeX, tileModeY, sampling, localMatrix);
    }

    @Nullable
    @SharedPtr
    public static Shader makeSubset(@SharedPtr Image image, Rect2fc subset, int tileModeX, int tileModeY, SamplingOptions sampling, @Nullable Matrixc localMatrix) {
        if (!(!sampling.mUseCubic || sampling.mCubicB >= 0.0f && sampling.mCubicB <= 1.0f && sampling.mCubicC >= 0.0f && sampling.mCubicC <= 1.0f)) {
            RefCnt.move(image);
            return null;
        }
        if (image == null || subset.isEmpty()) {
            RefCnt.move(image);
            return new EmptyShader();
        }
        if (!(0.0f <= subset.left() && 0.0f <= subset.top() && (float)image.getWidth() >= subset.right() && (float)image.getHeight() >= subset.bottom())) {
            image.unref();
            return null;
        }
        @SharedPtr ImageShader s = new ImageShader(image, subset, tileModeX, tileModeY, sampling);
        Matrix lm = localMatrix != null ? new Matrix(localMatrix) : new Matrix();
        return new LocalMatrixShader(s, lm);
    }

    @Override
    protected void deallocate() {
        RefCnt.move(this.mImage);
    }

    @RawPtr
    public Image getImage() {
        return this.mImage;
    }

    public SamplingOptions getSampling() {
        return this.mSampling;
    }

    public int getTileModeX() {
        return this.mTileModeX;
    }

    public int getTileModeY() {
        return this.mTileModeY;
    }

    public Rect2fc getSubset() {
        return this.mSubset;
    }

    public static float[] makeCubicMatrix(float B, float C) {
        return new float[]{0.16666667f * B, 1.0f - 0.33333334f * B, 0.16666667f * B, 0.0f, -0.5f * B - C, 0.0f, 0.5f * B + C, 0.0f, 0.5f * B + 2.0f * C, -3.0f + 2.0f * B + C, 3.0f - 2.5f * B - 2.0f * C, -C, -0.16666667f * B - C, 2.0f - 1.5f * B - C, -2.0f + 1.5f * B + C, 0.16666667f * B + C};
    }

    @Nonnull
    public static Rect2f preparePaintForDrawImageRect(@RawPtr Image image, SamplingOptions sampling, Rect2fc src, Rect2fc dst, boolean strictSubset, Paint paint) {
        assert (paint.getStyle() == 0 && paint.getPathEffect() == null);
        Rect2f imageBounds = new Rect2f();
        image.getBounds(imageBounds);
        assert (src.isFinite() && dst.isFinite() && dst.isSorted());
        Matrix localMatrix = new Matrix();
        localMatrix.setRectToRect(src, dst);
        Rect2f modifiedSrc = new Rect2f(src);
        Rect2f modifiedDst = new Rect2f(dst);
        if (!imageBounds.contains(modifiedSrc)) {
            if (!modifiedSrc.intersect(imageBounds)) {
                return modifiedDst;
            }
            localMatrix.mapRect((Rect2fc)modifiedSrc, modifiedDst);
        }
        boolean imageIsAlphaOnly = image.isAlphaOnly();
        @SharedPtr Shader imageShader = strictSubset ? ImageShader.makeSubset(RefCnt.create(image), modifiedSrc, 2, 2, sampling, localMatrix) : ImageShader.make(RefCnt.create(image), 2, 2, sampling, localMatrix);
        if (imageShader == null) {
            modifiedDst.setEmpty();
            return modifiedDst;
        }
        if (imageIsAlphaOnly && paint.getShader() != null) {
            imageShader = BlendShader.make(BlendMode.DST_IN, imageShader, paint.refShader());
        }
        paint.setShader(imageShader);
        return modifiedDst;
    }
}

