/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core.shaders;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import yslelf.cloudpick.render.core.ColorSpace;
import yslelf.cloudpick.render.core.Matrix;
import yslelf.cloudpick.render.core.Matrixc;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.core.shaders.Color4fShader;
import yslelf.cloudpick.render.core.shaders.Gradient1DShader;
import yslelf.cloudpick.render.core.shaders.LocalMatrixShader;
import yslelf.cloudpick.render.core.shaders.Shader;

public final class RadialGradient
extends Gradient1DShader {
    private final float mCenterX;
    private final float mCenterY;
    private final float mRadius;

    @VisibleForTesting
    public RadialGradient(float centerX, float centerY, float radius, @Nonnull float[] colors, @Nullable ColorSpace colorSpace, @Nullable float[] positions, int colorCount, int tileMode, int interpolation) {
        super(colors, colorSpace, positions, colorCount, tileMode, interpolation, RadialGradient.rad_to_unit_matrix(centerX, centerY, radius));
        this.mCenterX = centerX;
        this.mCenterY = centerY;
        this.mRadius = radius;
    }

    private static Matrix rad_to_unit_matrix(float centerX, float centerY, float radius) {
        float inv = 1.0f / radius;
        Matrix matrix = new Matrix();
        matrix.setTranslate(-centerX, -centerY);
        matrix.postScale(inv, inv);
        return matrix;
    }

    @CheckReturnValue
    @Nullable
    @SharedPtr
    public static Shader make(float centerX, float centerY, float radius, @Nonnull float[] colors, @Nullable ColorSpace colorSpace, @Nullable float[] positions, int colorCount, int tileMode, int interpolation, @Nullable Matrixc localMatrix) {
        if (!(radius >= 0.0f)) {
            return null;
        }
        if (!Float.isFinite(centerX) || !Float.isFinite(centerY)) {
            return null;
        }
        if (!RadialGradient.checkGradient1D(colors, positions, colorCount, tileMode)) {
            return null;
        }
        if (colorCount == 1) {
            return new Color4fShader(colors[0], colors[1], colors[2], colors[3], colorSpace);
        }
        if (localMatrix != null && !localMatrix.invert(null)) {
            return null;
        }
        if (Math.abs(radius) <= 1.5258789E-5f) {
            return RadialGradient.makeDegenerateGradient(colors, colorSpace, positions, colorCount, tileMode);
        }
        @SharedPtr RadialGradient s = new RadialGradient(centerX, centerY, radius, colors, colorSpace, positions, colorCount, tileMode, interpolation);
        Matrix lm = localMatrix != null ? new Matrix(localMatrix) : new Matrix();
        return new LocalMatrixShader(s, lm);
    }

    @Override
    public int asGradient() {
        return 2;
    }

    public float getCenterX() {
        return this.mCenterX;
    }

    public float getCenterY() {
        return this.mCenterY;
    }

    public float getRadius() {
        return this.mRadius;
    }
}

