/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.core.shaders;

import javax.annotation.Nonnull;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.render.core.Matrix;
import yslelf.cloudpick.render.core.Matrixc;
import yslelf.cloudpick.render.core.RefCounted;
import yslelf.cloudpick.render.core.SharedPtr;
import yslelf.cloudpick.render.core.shaders.LocalMatrixShader;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Shader
extends RefCounted {
    public static final int TILE_MODE_REPEAT = 0;
    public static final int TILE_MODE_MIRROR = 1;
    public static final int TILE_MODE_CLAMP = 2;
    public static final int TILE_MODE_DECAL = 3;
    @ApiStatus.Internal
    public static final int LAST_TILE_MODE = 3;
    @ApiStatus.Internal
    public static final int GRADIENT_TYPE_NONE = 0;
    @ApiStatus.Internal
    public static final int GRADIENT_TYPE_LINEAR = 1;
    @ApiStatus.Internal
    public static final int GRADIENT_TYPE_RADIAL = 2;
    @ApiStatus.Internal
    public static final int GRADIENT_TYPE_ANGULAR = 3;

    default public boolean isOpaque() {
        return false;
    }

    @ApiStatus.Internal
    default public boolean isConstant() {
        return false;
    }

    @ApiStatus.Internal
    default public int asGradient() {
        return 0;
    }

    @Nonnull
    @SharedPtr
    default public Shader makeWithLocalMatrix(@Nonnull Matrixc localMatrix) {
        Shader base;
        Matrix lm = new Matrix(localMatrix);
        Shader shader = this;
        if (shader instanceof LocalMatrixShader) {
            LocalMatrixShader lms = (LocalMatrixShader)shader;
            lm.preConcat(lms.getLocalMatrix());
            base = lms.getBase();
        } else {
            base = this;
        }
        base.ref();
        return new LocalMatrixShader(base, lm);
    }
}

