/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.render.engine;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.render.core.BlendMode;

public final class BlendInfo {
    public static final byte FACTOR_ZERO = 0;
    public static final byte FACTOR_ONE = 1;
    public static final byte FACTOR_SRC_COLOR = 2;
    public static final byte FACTOR_ONE_MINUS_SRC_COLOR = 3;
    public static final byte FACTOR_DST_COLOR = 4;
    public static final byte FACTOR_ONE_MINUS_DST_COLOR = 5;
    public static final byte FACTOR_SRC_ALPHA = 6;
    public static final byte FACTOR_ONE_MINUS_SRC_ALPHA = 7;
    public static final byte FACTOR_DST_ALPHA = 8;
    public static final byte FACTOR_ONE_MINUS_DST_ALPHA = 9;
    public static final byte FACTOR_CONSTANT_COLOR = 10;
    public static final byte FACTOR_ONE_MINUS_CONSTANT_COLOR = 11;
    public static final byte FACTOR_CONSTANT_ALPHA = 12;
    public static final byte FACTOR_ONE_MINUS_CONSTANT_ALPHA = 13;
    public static final byte FACTOR_SRC_ALPHA_SATURATE = 14;
    public static final byte FACTOR_SRC1_COLOR = 15;
    public static final byte FACTOR_ONE_MINUS_SRC1_COLOR = 16;
    public static final byte FACTOR_SRC1_ALPHA = 17;
    public static final byte FACTOR_ONE_MINUS_SRC1_ALPHA = 18;
    public static final byte FACTOR_UNKNOWN = -1;
    public static final byte EQUATION_ADD = 0;
    public static final byte EQUATION_SUBTRACT = 1;
    public static final byte EQUATION_REVERSE_SUBTRACT = 2;
    public static final byte EQUATION_MULTIPLY = 3;
    public static final byte EQUATION_SCREEN = 4;
    public static final byte EQUATION_OVERLAY = 5;
    public static final byte EQUATION_DARKEN = 6;
    public static final byte EQUATION_LIGHTEN = 7;
    public static final byte EQUATION_COLORDODGE = 8;
    public static final byte EQUATION_COLORBURN = 9;
    public static final byte EQUATION_HARDLIGHT = 10;
    public static final byte EQUATION_SOFTLIGHT = 11;
    public static final byte EQUATION_DIFFERENCE = 12;
    public static final byte EQUATION_EXCLUSION = 13;
    public static final byte EQUATION_HSL_HUE = 14;
    public static final byte EQUATION_HSL_SATURATION = 15;
    public static final byte EQUATION_HSL_COLOR = 16;
    public static final byte EQUATION_HSL_LUMINOSITY = 17;
    public static final byte EQUATION_UNKNOWN = -1;
    public final byte mEquation;
    public final byte mSrcFactor;
    public final byte mDstFactor;
    public final boolean mColorWrite;
    public static final BlendInfo BLEND_CLEAR = new BlendInfo(0, 0, 0, true);
    public static final BlendInfo BLEND_SRC = new BlendInfo(0, 1, 0, true);
    public static final BlendInfo BLEND_DST = new BlendInfo(0, 0, 1, false);
    public static final BlendInfo BLEND_SRC_OVER = new BlendInfo(0, 1, 7, true);
    public static final BlendInfo BLEND_DST_OVER = new BlendInfo(0, 9, 1, true);
    public static final BlendInfo BLEND_SRC_IN = new BlendInfo(0, 8, 0, true);
    public static final BlendInfo BLEND_DST_IN = new BlendInfo(0, 0, 6, true);
    public static final BlendInfo BLEND_SRC_OUT = new BlendInfo(0, 9, 0, true);
    public static final BlendInfo BLEND_DST_OUT = new BlendInfo(0, 0, 7, true);
    public static final BlendInfo BLEND_SRC_ATOP = new BlendInfo(0, 8, 7, true);
    public static final BlendInfo BLEND_DST_ATOP = new BlendInfo(0, 9, 6, true);
    public static final BlendInfo BLEND_XOR = new BlendInfo(0, 9, 7, true);
    public static final BlendInfo BLEND_PLUS = new BlendInfo(0, 1, 1, true);
    public static final BlendInfo BLEND_MINUS = new BlendInfo(2, 1, 1, true);
    public static final BlendInfo BLEND_MODULATE = new BlendInfo(0, 0, 2, true);
    public static final BlendInfo BLEND_SCREEN = new BlendInfo(0, 1, 3, true);

    public BlendInfo(byte equation, byte srcFactor, byte dstFactor, boolean colorWrite) {
        this.mEquation = equation;
        this.mSrcFactor = srcFactor;
        this.mDstFactor = dstFactor;
        this.mColorWrite = colorWrite;
    }

    public boolean blendShouldDisable() {
        return (this.mEquation == 0 || this.mEquation == 1) && this.mSrcFactor == 1 && this.mDstFactor == 0;
    }

    public static boolean blendCoeffRefsSrc(byte factor) {
        return factor == 2 || factor == 3 || factor == 6 || factor == 7;
    }

    public static boolean blendCoeffRefsDst(byte factor) {
        return factor == 4 || factor == 5 || factor == 8 || factor == 9;
    }

    public static boolean blendCoeffRefsSrc1(byte factor) {
        return factor == 15 || factor == 16 || factor == 17 || factor == 18;
    }

    public static boolean blendCoeffsUseSrcColor(byte srcFactor, byte dstFactor) {
        return srcFactor != 0 || BlendInfo.blendCoeffRefsSrc(dstFactor);
    }

    public static boolean blendCoeffsUseDstColor(byte srcFactor, byte dstFactor, boolean srcColorIsOpaque) {
        return BlendInfo.blendCoeffRefsDst(srcFactor) || dstFactor != 0 && (dstFactor != 7 || !srcColorIsOpaque);
    }

    public static boolean blendModifiesDst(byte equation, byte srcFactor, byte dstFactor) {
        return equation != 0 && equation != 2 || srcFactor != 0 || dstFactor != 1;
    }

    @Nullable
    public static BlendInfo getSimpleBlendInfo(@Nonnull BlendMode mode) {
        return switch (mode) {
            case BlendMode.CLEAR -> BLEND_CLEAR;
            case BlendMode.SRC -> BLEND_SRC;
            case BlendMode.DST -> BLEND_DST;
            case BlendMode.SRC_OVER -> BLEND_SRC_OVER;
            case BlendMode.DST_OVER -> BLEND_DST_OVER;
            case BlendMode.SRC_IN -> BLEND_SRC_IN;
            case BlendMode.DST_IN -> BLEND_DST_IN;
            case BlendMode.SRC_OUT -> BLEND_SRC_OUT;
            case BlendMode.DST_OUT -> BLEND_DST_OUT;
            case BlendMode.SRC_ATOP -> BLEND_SRC_ATOP;
            case BlendMode.DST_ATOP -> BLEND_DST_ATOP;
            case BlendMode.XOR -> BLEND_XOR;
            case BlendMode.PLUS, BlendMode.PLUS_CLAMPED -> BLEND_PLUS;
            case BlendMode.MINUS, BlendMode.MINUS_CLAMPED -> BLEND_MINUS;
            case BlendMode.MODULATE -> BLEND_MODULATE;
            case BlendMode.SCREEN -> BLEND_SCREEN;
            default -> null;
        };
    }
}

